/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalsubtree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.kse.crypto.x509.GeneralSubtrees;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalsubtree.DGeneralSubtreeChooser;
import org.kse.gui.crypto.generalsubtree.GeneralSubtreesTableCellRend;
import org.kse.gui.crypto.generalsubtree.GeneralSubtreesTableHeadRend;
import org.kse.gui.crypto.generalsubtree.GeneralSubtreesTableModel;
import org.kse.utilities.os.OperatingSystem;

public class JGeneralSubtrees
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalsubtree/resources");
    private JPanel jpGeneralSubtreeButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspGeneralSubtrees;
    private JKseTable jtGeneralSubtrees;
    private String title;
    private GeneralSubtrees generalSubtrees;
    private boolean enabled = true;

    public JGeneralSubtrees(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_general_subtree.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JGeneralSubtrees.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JGeneralSubtrees.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralSubtrees.this);
                    JGeneralSubtrees.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralSubtrees.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_general_subtree.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JGeneralSubtrees.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JGeneralSubtrees.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralSubtrees.this);
                    JGeneralSubtrees.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralSubtrees.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_general_subtree.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JGeneralSubtrees.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JGeneralSubtrees.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JGeneralSubtrees.this);
                    JGeneralSubtrees.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JGeneralSubtrees.this);
                }
            }
        });
        this.jpGeneralSubtreeButtons = new JPanel();
        this.jpGeneralSubtreeButtons.setLayout(new BoxLayout(this.jpGeneralSubtreeButtons, 1));
        this.jpGeneralSubtreeButtons.add(Box.createVerticalGlue());
        this.jpGeneralSubtreeButtons.add(this.jbAdd);
        this.jpGeneralSubtreeButtons.add(Box.createVerticalStrut(3));
        this.jpGeneralSubtreeButtons.add(this.jbEdit);
        this.jpGeneralSubtreeButtons.add(Box.createVerticalStrut(3));
        this.jpGeneralSubtreeButtons.add(this.jbRemove);
        this.jpGeneralSubtreeButtons.add(Box.createVerticalGlue());
        GeneralSubtreesTableModel generalSubtreesTableModel = new GeneralSubtreesTableModel();
        this.jtGeneralSubtrees = new JKseTable(generalSubtreesTableModel);
        TableRowSorter<GeneralSubtreesTableModel> sorter = new TableRowSorter<GeneralSubtreesTableModel>(generalSubtreesTableModel);
        sorter.setComparator(0, new GeneralSubtreesTableModel.GeneralSubtreeBaseComparator());
        sorter.setComparator(1, new GeneralSubtreesTableModel.GeneralSubtreeMinimumComparator());
        sorter.setComparator(2, new GeneralSubtreesTableModel.GeneralSubtreeMaximumComparator());
        this.jtGeneralSubtrees.setRowSorter(sorter);
        this.jtGeneralSubtrees.setShowGrid(false);
        this.jtGeneralSubtrees.setRowMargin(0);
        this.jtGeneralSubtrees.getColumnModel().setColumnMargin(0);
        this.jtGeneralSubtrees.getTableHeader().setReorderingAllowed(false);
        this.jtGeneralSubtrees.setAutoResizeMode(4);
        this.jtGeneralSubtrees.setRowHeight(Math.max(18, this.jtGeneralSubtrees.getRowHeight()));
        for (int i = 0; i < this.jtGeneralSubtrees.getColumnCount(); ++i) {
            TableColumn column = this.jtGeneralSubtrees.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new GeneralSubtreesTableHeadRend(this.jtGeneralSubtrees.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new GeneralSubtreesTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtGeneralSubtrees.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JGeneralSubtrees.this.updateButtonControls();
                }
            }
        });
        this.jtGeneralSubtrees.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JGeneralSubtrees.this.maybeEditGeneralSubtree(evt);
            }
        });
        this.jtGeneralSubtrees.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JGeneralSubtrees.this);
                        this.deleteLastPressed = false;
                        JGeneralSubtrees.this.removeSelectedGeneralSubtree();
                    }
                    finally {
                        CursorUtil.setCursorFree(JGeneralSubtrees.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JGeneralSubtrees.this);
                        JGeneralSubtrees.this.removeSelectedGeneralSubtree();
                    }
                    finally {
                        CursorUtil.setCursorFree(JGeneralSubtrees.this);
                    }
                }
            }
        });
        this.jspGeneralSubtrees = PlatformUtil.createScrollPane(this.jtGeneralSubtrees, 20, 31);
        this.jspGeneralSubtrees.getViewport().setBackground(this.jtGeneralSubtrees.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 150));
        this.add((Component)this.jspGeneralSubtrees, "Center");
        this.add((Component)this.jpGeneralSubtreeButtons, "East");
        this.populate();
    }

    public GeneralSubtrees getGeneralSubtrees() {
        return this.generalSubtrees;
    }

    public void setGeneralSubtrees(GeneralSubtrees generalSubtrees) {
        this.generalSubtrees = generalSubtrees;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspGeneralSubtrees.setToolTipText(toolTipText);
        this.jtGeneralSubtrees.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.generalSubtrees == null) {
            this.generalSubtrees = new GeneralSubtrees(new ArrayList<GeneralSubtree>());
        }
        this.reloadGeneralSubtreesTable();
        this.selectFirstGeneralSubtreeInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        DGeneralSubtreeChooser dGeneralSubtreeChooser = null;
        dGeneralSubtreeChooser = container instanceof JDialog ? new DGeneralSubtreeChooser((JDialog)container, this.title, null) : new DGeneralSubtreeChooser((JFrame)container, this.title, null);
        dGeneralSubtreeChooser.setLocationRelativeTo(container);
        dGeneralSubtreeChooser.setVisible(true);
        GeneralSubtree newGeneralSubtree = dGeneralSubtreeChooser.getGeneralSubtree();
        if (newGeneralSubtree == null) {
            return;
        }
        this.generalSubtrees.getGeneralSubtrees().add(newGeneralSubtree);
        this.populate();
        this.selectGeneralSubtreeInTable(newGeneralSubtree);
    }

    private void removePressed() {
        this.removeSelectedGeneralSubtree();
    }

    private void removeSelectedGeneralSubtree() {
        int selectedRow = this.jtGeneralSubtrees.getSelectedRow();
        if (selectedRow != -1) {
            GeneralSubtree generalSubtree = (GeneralSubtree)this.jtGeneralSubtrees.getValueAt(selectedRow, 0);
            this.generalSubtrees.getGeneralSubtrees().remove(generalSubtree);
            this.reloadGeneralSubtreesTable();
            this.selectFirstGeneralSubtreeInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedGeneralSubtree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditGeneralSubtree(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtGeneralSubtrees.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtGeneralSubtrees.setRowSelectionInterval(row, row);
                this.editSelectedGeneralSubtree();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtGeneralSubtrees.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedGeneralSubtree() {
        int selectedRow = this.jtGeneralSubtrees.getSelectedRow();
        if (selectedRow != -1) {
            GeneralSubtree generalSubtree = (GeneralSubtree)this.jtGeneralSubtrees.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            DGeneralSubtreeChooser dGeneralSubtreeChooser = null;
            dGeneralSubtreeChooser = container instanceof JDialog ? new DGeneralSubtreeChooser((JDialog)container, this.title, generalSubtree) : new DGeneralSubtreeChooser((JFrame)container, this.title, generalSubtree);
            dGeneralSubtreeChooser.setLocationRelativeTo(container);
            dGeneralSubtreeChooser.setVisible(true);
            GeneralSubtree newGeneralSubtree = dGeneralSubtreeChooser.getGeneralSubtree();
            if (newGeneralSubtree == null) {
                return;
            }
            this.generalSubtrees.getGeneralSubtrees().remove(generalSubtree);
            this.generalSubtrees.getGeneralSubtrees().add(newGeneralSubtree);
            this.populate();
            this.selectGeneralSubtreeInTable(newGeneralSubtree);
        }
    }

    private void selectGeneralSubtreeInTable(GeneralSubtree generalSubtree) {
        for (int i = 0; i < this.jtGeneralSubtrees.getRowCount(); ++i) {
            if (!generalSubtree.equals(this.jtGeneralSubtrees.getValueAt(i, 0))) continue;
            this.jtGeneralSubtrees.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadGeneralSubtreesTable() {
        this.getGeneralSubtreesTableModel().load(this.generalSubtrees);
    }

    private void selectFirstGeneralSubtreeInTable() {
        if (this.getGeneralSubtreesTableModel().getRowCount() > 0) {
            this.jtGeneralSubtrees.changeSelection(0, 0, false, false);
        }
    }

    private GeneralSubtreesTableModel getGeneralSubtreesTableModel() {
        return (GeneralSubtreesTableModel)this.jtGeneralSubtrees.getModel();
    }
}

