/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policymapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kse.crypto.x509.PolicyMapping;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.oid.JObjectId;

public class DPolicyMappingChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policymapping/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPolicyMapping;
    private JLabel jlIssuerDomainPolicy;
    private JObjectId joiIssuerDomainPolicy;
    private JLabel jlSubjectDomainPolicy;
    private JObjectId joiSubjectDomainPolicy;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PolicyMapping policyMapping;

    public DPolicyMappingChooser(JFrame parent, String title, PolicyMapping policyMapping) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyMapping);
    }

    public DPolicyMappingChooser(JDialog parent, String title, PolicyMapping policyMapping) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyMapping);
    }

    private void initComponents(PolicyMapping policyMapping) {
        this.jlIssuerDomainPolicy = new JLabel(res.getString("DPolicyMappingChooser.jlIssuerDomainPolicy.text"));
        GridBagConstraints gbc_jlIssuerDomainPolicy = new GridBagConstraints();
        gbc_jlIssuerDomainPolicy.gridx = 0;
        gbc_jlIssuerDomainPolicy.gridy = 0;
        gbc_jlIssuerDomainPolicy.gridwidth = 1;
        gbc_jlIssuerDomainPolicy.gridheight = 1;
        gbc_jlIssuerDomainPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_jlIssuerDomainPolicy.anchor = 13;
        this.joiIssuerDomainPolicy = new JObjectId(res.getString("DPolicyMappingChooser.IssuerDomainPolicy.Title"));
        this.joiIssuerDomainPolicy.setToolTipText(res.getString("DPolicyMappingChooser.joiIssuerDomainPolicy.tooltip"));
        GridBagConstraints gbc_joiIssuerDomainPolicy = new GridBagConstraints();
        gbc_joiIssuerDomainPolicy.gridx = 1;
        gbc_joiIssuerDomainPolicy.gridy = 0;
        gbc_joiIssuerDomainPolicy.gridwidth = 1;
        gbc_joiIssuerDomainPolicy.gridheight = 1;
        gbc_joiIssuerDomainPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_joiIssuerDomainPolicy.anchor = 17;
        this.jlSubjectDomainPolicy = new JLabel(res.getString("DPolicyMappingChooser.jlSubjectDomainPolicy.text"));
        GridBagConstraints gbc_jlSubjectDomainPolicy = new GridBagConstraints();
        gbc_jlSubjectDomainPolicy.gridx = 0;
        gbc_jlSubjectDomainPolicy.gridy = 1;
        gbc_jlSubjectDomainPolicy.gridwidth = 1;
        gbc_jlSubjectDomainPolicy.gridheight = 1;
        gbc_jlSubjectDomainPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_jlSubjectDomainPolicy.anchor = 13;
        this.joiSubjectDomainPolicy = new JObjectId(res.getString("DPolicyMappingChooser.SubjectDomainPolicy.Title"));
        this.joiSubjectDomainPolicy.setToolTipText(res.getString("DPolicyMappingChooser.joiSubjectDomainPolicy.tooltip"));
        GridBagConstraints gbc_joiSubjectDomainPolicy = new GridBagConstraints();
        gbc_joiSubjectDomainPolicy.gridx = 1;
        gbc_joiSubjectDomainPolicy.gridy = 1;
        gbc_joiSubjectDomainPolicy.gridwidth = 1;
        gbc_joiSubjectDomainPolicy.gridheight = 1;
        gbc_joiSubjectDomainPolicy.insets = new Insets(5, 5, 5, 5);
        gbc_joiSubjectDomainPolicy.anchor = 17;
        this.jpPolicyMapping = new JPanel(new GridBagLayout());
        this.jpPolicyMapping.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpPolicyMapping.add((Component)this.jlIssuerDomainPolicy, gbc_jlIssuerDomainPolicy);
        this.jpPolicyMapping.add((Component)this.joiIssuerDomainPolicy, gbc_joiIssuerDomainPolicy);
        this.jpPolicyMapping.add((Component)this.jlSubjectDomainPolicy, gbc_jlSubjectDomainPolicy);
        this.jpPolicyMapping.add((Component)this.joiSubjectDomainPolicy, gbc_joiSubjectDomainPolicy);
        this.jbOK = new JButton(res.getString("DPolicyMappingChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappingChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPolicyMappingChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappingChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyMappingChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpPolicyMapping);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(policyMapping);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(PolicyMapping policyMapping) {
        if (policyMapping != null) {
            ASN1ObjectIdentifier issuerDomainPolicy = policyMapping.getIssuerDomainPolicy();
            ASN1ObjectIdentifier subjectDomainPolicy = policyMapping.getSubjectDomainPolicy();
            this.joiIssuerDomainPolicy.setObjectId(issuerDomainPolicy);
            this.joiSubjectDomainPolicy.setObjectId(subjectDomainPolicy);
        }
    }

    public PolicyMapping getPolicyMapping() {
        return this.policyMapping;
    }

    private void okPressed() {
        ASN1ObjectIdentifier issuerDomainPolicy = this.joiIssuerDomainPolicy.getObjectId();
        if (issuerDomainPolicy == null) {
            JOptionPane.showMessageDialog(this, res.getString("DPolicyMappingChooser.IssuerDomainPolicyValueReq.message"), this.getTitle(), 2);
            return;
        }
        ASN1ObjectIdentifier subjectDomainPolicy = this.joiSubjectDomainPolicy.getObjectId();
        if (subjectDomainPolicy == null) {
            JOptionPane.showMessageDialog(this, res.getString("DPolicyMappingChooser.SubjectDomainPolicyValueReq.message"), this.getTitle(), 2);
            return;
        }
        this.policyMapping = new PolicyMapping(issuerDomainPolicy, subjectDomainPolicy);
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

