/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policymapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.CertPolicyId;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.kse.crypto.x509.PolicyMapping;
import org.kse.crypto.x509.PolicyMappingsUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policymapping.DPolicyMappingChooser;
import org.kse.gui.crypto.policymapping.PolicyMappingsTableCellRend;
import org.kse.gui.crypto.policymapping.PolicyMappingsTableHeadRend;
import org.kse.gui.crypto.policymapping.PolicyMappingsTableModel;
import org.kse.utilities.os.OperatingSystem;

public class JPolicyMappings
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policymapping/resources");
    private JPanel jpPolicyMappingButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspPolicyMappings;
    private JKseTable jtPolicyMappings;
    private String title;
    private PolicyMappings policyMappings;
    private boolean enabled = true;

    public JPolicyMappings(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_policy_map.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JPolicyMappings.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JPolicyMappings.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyMappings.this);
                    JPolicyMappings.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyMappings.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_policy_map.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JPolicyMappings.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JPolicyMappings.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyMappings.this);
                    JPolicyMappings.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyMappings.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_policy_map.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JPolicyMappings.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JPolicyMappings.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JPolicyMappings.this);
                    JPolicyMappings.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JPolicyMappings.this);
                }
            }
        });
        this.jpPolicyMappingButtons = new JPanel();
        this.jpPolicyMappingButtons.setLayout(new BoxLayout(this.jpPolicyMappingButtons, 1));
        this.jpPolicyMappingButtons.add(Box.createVerticalGlue());
        this.jpPolicyMappingButtons.add(this.jbAdd);
        this.jpPolicyMappingButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyMappingButtons.add(this.jbEdit);
        this.jpPolicyMappingButtons.add(Box.createVerticalStrut(3));
        this.jpPolicyMappingButtons.add(this.jbRemove);
        this.jpPolicyMappingButtons.add(Box.createVerticalGlue());
        PolicyMappingsTableModel policyMappingsTableModel = new PolicyMappingsTableModel();
        this.jtPolicyMappings = new JKseTable(policyMappingsTableModel);
        TableRowSorter<PolicyMappingsTableModel> sorter = new TableRowSorter<PolicyMappingsTableModel>(policyMappingsTableModel);
        sorter.setComparator(0, new PolicyMappingsTableModel.IssuerDomainPolicyComparator());
        sorter.setComparator(1, new PolicyMappingsTableModel.SubjectDomainPolicyComparator());
        this.jtPolicyMappings.setRowSorter(sorter);
        this.jtPolicyMappings.setShowGrid(false);
        this.jtPolicyMappings.setRowMargin(0);
        this.jtPolicyMappings.getColumnModel().setColumnMargin(0);
        this.jtPolicyMappings.getTableHeader().setReorderingAllowed(false);
        this.jtPolicyMappings.setAutoResizeMode(4);
        this.jtPolicyMappings.setRowHeight(Math.max(18, this.jtPolicyMappings.getRowHeight()));
        for (int i = 0; i < this.jtPolicyMappings.getColumnCount(); ++i) {
            TableColumn column = this.jtPolicyMappings.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new PolicyMappingsTableHeadRend(this.jtPolicyMappings.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new PolicyMappingsTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtPolicyMappings.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JPolicyMappings.this.updateButtonControls();
                }
            }
        });
        this.jtPolicyMappings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPolicyMappings.this.maybeEditPolicyMapping(evt);
            }
        });
        this.jtPolicyMappings.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JPolicyMappings.this);
                        this.deleteLastPressed = false;
                        JPolicyMappings.this.removeSelectedPolicyMapping();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyMappings.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JPolicyMappings.this);
                        JPolicyMappings.this.removeSelectedPolicyMapping();
                    }
                    finally {
                        CursorUtil.setCursorFree(JPolicyMappings.this);
                    }
                }
            }
        });
        this.jspPolicyMappings = PlatformUtil.createScrollPane(this.jtPolicyMappings, 20, 31);
        this.jspPolicyMappings.getViewport().setBackground(this.jtPolicyMappings.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 150));
        this.add((Component)this.jspPolicyMappings, "Center");
        this.add((Component)this.jpPolicyMappingButtons, "East");
        this.populate();
    }

    public PolicyMappings getPolicyMappings() {
        return this.policyMappings;
    }

    public void setPolicyMappings(PolicyMappings policyMappings) {
        this.policyMappings = policyMappings;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspPolicyMappings.setToolTipText(toolTipText);
        this.jtPolicyMappings.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.policyMappings == null) {
            this.policyMappings = new PolicyMappings(new CertPolicyId[0], new CertPolicyId[0]);
        }
        this.reloadPolicyMappingsTable();
        this.selectFirstPolicyMappingInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        DPolicyMappingChooser dPolicyMappingChooser = null;
        dPolicyMappingChooser = container instanceof JDialog ? new DPolicyMappingChooser((JDialog)container, this.title, null) : new DPolicyMappingChooser((JFrame)container, this.title, null);
        dPolicyMappingChooser.setLocationRelativeTo(container);
        dPolicyMappingChooser.setVisible(true);
        PolicyMapping newPolicyMapping = dPolicyMappingChooser.getPolicyMapping();
        if (newPolicyMapping == null) {
            return;
        }
        this.policyMappings = PolicyMappingsUtil.add(newPolicyMapping, this.policyMappings);
        this.populate();
        this.selectPolicyMappingInTable(newPolicyMapping);
    }

    private void removePressed() {
        this.removeSelectedPolicyMapping();
    }

    private void removeSelectedPolicyMapping() {
        int selectedRow = this.jtPolicyMappings.getSelectedRow();
        if (selectedRow != -1) {
            PolicyMapping policyMapping = (PolicyMapping)((Object)this.jtPolicyMappings.getValueAt(selectedRow, 0));
            this.policyMappings = PolicyMappingsUtil.remove(policyMapping, this.policyMappings);
            this.reloadPolicyMappingsTable();
            this.selectFirstPolicyMappingInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedPolicyMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditPolicyMapping(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtPolicyMappings.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtPolicyMappings.setRowSelectionInterval(row, row);
                this.editSelectedPolicyMapping();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtPolicyMappings.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedPolicyMapping() {
        int selectedRow = this.jtPolicyMappings.getSelectedRow();
        if (selectedRow != -1) {
            PolicyMapping policyMapping = (PolicyMapping)((Object)this.jtPolicyMappings.getValueAt(selectedRow, 0));
            Container container = this.getTopLevelAncestor();
            DPolicyMappingChooser dPolicyMappingChooser = null;
            dPolicyMappingChooser = container instanceof JDialog ? new DPolicyMappingChooser((JDialog)container, this.title, policyMapping) : new DPolicyMappingChooser((JFrame)container, this.title, policyMapping);
            dPolicyMappingChooser.setLocationRelativeTo(container);
            dPolicyMappingChooser.setVisible(true);
            PolicyMapping newPolicyMapping = dPolicyMappingChooser.getPolicyMapping();
            if (newPolicyMapping == null) {
                return;
            }
            this.policyMappings = PolicyMappingsUtil.remove(policyMapping, this.policyMappings);
            this.policyMappings = PolicyMappingsUtil.add(newPolicyMapping, this.policyMappings);
            this.populate();
            this.selectPolicyMappingInTable(newPolicyMapping);
        }
    }

    private void selectPolicyMappingInTable(PolicyMapping policyMapping) {
        for (int i = 0; i < this.jtPolicyMappings.getRowCount(); ++i) {
            if (!policyMapping.equals(this.jtPolicyMappings.getValueAt(i, 0))) continue;
            this.jtPolicyMappings.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadPolicyMappingsTable() {
        this.getPolicyMappingsTableModel().load(this.policyMappings);
    }

    private void selectFirstPolicyMappingInTable() {
        if (this.getPolicyMappingsTableModel().getRowCount() > 0) {
            this.jtPolicyMappings.changeSelection(0, 0, false, false);
        }
    }

    private PolicyMappingsTableModel getPolicyMappingsTableModel() {
        return (PolicyMappingsTableModel)this.jtPolicyMappings.getModel();
    }
}

