/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.datetime;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DDateTimeChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/datetime/resources");
    private static final String[] MONTH_NAMES = new String[]{res.getString("DDateTimeChooser.Month.January"), res.getString("DDateTimeChooser.Month.February"), res.getString("DDateTimeChooser.Month.March"), res.getString("DDateTimeChooser.Month.April"), res.getString("DDateTimeChooser.Month.May"), res.getString("DDateTimeChooser.Month.June"), res.getString("DDateTimeChooser.Month.July"), res.getString("DDateTimeChooser.Month.August"), res.getString("DDateTimeChooser.Month.September"), res.getString("DDateTimeChooser.Month.October"), res.getString("DDateTimeChooser.Month.November"), res.getString("DDateTimeChooser.Month.December")};
    private static final String[] DAY_NAMES = new String[]{res.getString("DDateTimeChooser.Day.Mon"), res.getString("DDateTimeChooser.Day.Tue"), res.getString("DDateTimeChooser.Day.Wed"), res.getString("DDateTimeChooser.Day.Thu"), res.getString("DDateTimeChooser.Day.Fri"), res.getString("DDateTimeChooser.Day.Sat"), res.getString("DDateTimeChooser.Day.Sun")};
    private static final Color LIGHT_BLUE;
    private static final Color WEEK_DAY_BACKGROUND;
    private static final Color WEEK_DAY_FOREGROUND;
    private static final Color DAY_FOREGROUND;
    private static final Color DAY_BACKGROUND;
    private static final Color SELECTED_DAY_FOREGROUND;
    private static final Color SELECTED_DAY_BACKGROUND;
    private static final String EMPTY_DAY = "";
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpMonthYear;
    private JComboBox<?> jcbMonth;
    private JSpinner jsYear;
    private JPanel jpDaysOfMonth;
    private JLabel[][] jlDaysOfMonth;
    private JLabel jlSelectedDayOfMonth;
    private JPanel jpTime;
    private JSpinner jsHour;
    private JLabel jlTimeSeparator1;
    private JSpinner jsMinute;
    private JLabel jlTimeSeparator2;
    private JSpinner jsSecond;
    private JPanel jpShortcuts;
    private JButton jbStartOfYear;
    private JButton jbNow;
    private JButton jbEndOfYear;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private int indexOfFirstDayOfMonth;
    private int lastDayOfSelectedMonth;
    private Date date;

    public DDateTimeChooser(JFrame parent, String title, Date date) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(date);
    }

    public DDateTimeChooser(JDialog parent, String title, Date date) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(date);
    }

    private void initComponents(Date date) {
        int j;
        int i;
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.jcbMonth = new JComboBox<String>(MONTH_NAMES);
        this.jcbMonth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DDateTimeChooser.this.update();
            }
        });
        this.jsYear = new JSpinner(new SpinnerNumberModel(calendar.get(1), 1900, 2100, 1));
        this.jsYear.setEditor(new JSpinner.NumberEditor(this.jsYear, "0000"));
        this.jsYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DDateTimeChooser.this.update();
            }
        });
        this.jlDaysOfMonth = new JLabel[7][7];
        for (i = 0; i < 7; ++i) {
            this.jlDaysOfMonth[0][i] = new JLabel(DAY_NAMES[i], 0);
            this.jlDaysOfMonth[0][i].setOpaque(true);
            this.jlDaysOfMonth[0][i].setForeground(WEEK_DAY_FOREGROUND);
            this.jlDaysOfMonth[0][i].setBackground(WEEK_DAY_BACKGROUND);
        }
        for (i = 1; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.jlDaysOfMonth[i][j] = new JLabel(EMPTY_DAY, 0);
                this.jlDaysOfMonth[i][j].setOpaque(true);
                this.jlDaysOfMonth[i][j].setForeground(DAY_FOREGROUND);
                this.jlDaysOfMonth[i][j].setBackground(DAY_BACKGROUND);
                this.jlDaysOfMonth[i][j].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        DDateTimeChooser.this.selectDay((JLabel)evt.getSource());
                    }
                });
                this.jlDaysOfMonth[i][j].setBorder(new MatteBorder(2, 0, 0, 0, Color.WHITE));
            }
        }
        this.jpMonthYear = new JPanel();
        this.jpMonthYear.add(this.jcbMonth);
        this.jpMonthYear.add(this.jsYear);
        this.jpDaysOfMonth = new JPanel(new DayOfMonthGridLayout(7, 7));
        this.jpDaysOfMonth.setBackground(DAY_BACKGROUND);
        this.jpDaysOfMonth.setBorder(new CompoundBorder(BorderFactory.createLoweredBevelBorder(), new EmptyBorder(2, 2, 2, 2)));
        this.jpDaysOfMonth.setFocusable(true);
        this.jpDaysOfMonth.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                DDateTimeChooser.this.setSelectedDay(DDateTimeChooser.this.jlSelectedDayOfMonth);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DDateTimeChooser.this.setSelectedDay(DDateTimeChooser.this.jlSelectedDayOfMonth);
            }
        });
        this.jpDaysOfMonth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DDateTimeChooser.this.calendarKeyboardNavigation(evt);
            }
        });
        for (i = 0; i < 7; ++i) {
            for (j = 0; j < 7; ++j) {
                this.jpDaysOfMonth.add(this.jlDaysOfMonth[i][j]);
            }
        }
        this.jsHour = new JSpinner(new SpinnerNumberModel(calendar.get(11), 0, 23, 1));
        this.jsHour.setEditor(new JSpinner.NumberEditor(this.jsHour, "00"));
        this.jlTimeSeparator1 = new JLabel(":");
        this.jsMinute = new JSpinner(new SpinnerNumberModel(calendar.get(12), 0, 59, 1));
        this.jsMinute.setEditor(new JSpinner.NumberEditor(this.jsMinute, "00"));
        this.jlTimeSeparator2 = new JLabel(":");
        this.jsSecond = new JSpinner(new SpinnerNumberModel(calendar.get(13), 0, 59, 1));
        this.jsSecond.setEditor(new JSpinner.NumberEditor(this.jsSecond, "00"));
        this.jpTime = new JPanel(new FlowLayout(1));
        this.jpTime.add(this.jsHour);
        this.jpTime.add(this.jlTimeSeparator1);
        this.jpTime.add(this.jsMinute);
        this.jpTime.add(this.jlTimeSeparator2);
        this.jpTime.add(this.jsSecond);
        this.jbNow = new JButton(res.getString("DDateTimeChooser.jbNow.text"));
        this.jbNow.setMargin(new Insets(2, 2, 2, 2));
        this.jbNow.addActionListener(e -> this.populate(new Date()));
        this.jbStartOfYear = new JButton(res.getString("DDateTimeChooser.jbStartOfYear.text"));
        this.jbStartOfYear.setMargin(new Insets(2, 2, 2, 2));
        this.jbStartOfYear.addActionListener(e -> {
            Calendar cal = Calendar.getInstance();
            cal.set(1, (Integer)this.jsYear.getValue());
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.populate(cal.getTime());
        });
        this.jbEndOfYear = new JButton(res.getString("DDateTimeChooser.jbEndOfYear.text"));
        this.jbEndOfYear.setMargin(new Insets(2, 2, 2, 2));
        this.jbEndOfYear.addActionListener(e -> {
            Calendar cal = Calendar.getInstance();
            cal.set(1, (Integer)this.jsYear.getValue());
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 0);
            this.populate(cal.getTime());
        });
        this.jpShortcuts = new JPanel(new FlowLayout(1));
        this.jpShortcuts.add(this.jbStartOfYear);
        this.jpShortcuts.add(this.jbNow);
        this.jpShortcuts.add(this.jbEndOfYear);
        JPanel jpDateTime = new JPanel();
        jpDateTime.setLayout(new BoxLayout(jpDateTime, 1));
        jpDateTime.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        jpDateTime.add(this.jpMonthYear);
        jpDateTime.add(this.jpDaysOfMonth);
        jpDateTime.add(this.jpTime);
        jpDateTime.add(this.jpShortcuts);
        this.jbOK = new JButton(res.getString("DDateTimeChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDateTimeChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DDateTimeChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDateTimeChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DDateTimeChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jpDateTime);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(date);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    public Date getDate() {
        return this.date;
    }

    private void populate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        this.jsYear.setValue(calendar.get(1));
        this.jcbMonth.setSelectedIndex(calendar.get(2));
        this.setSelectedDay(calendar.get(5));
        this.jsHour.setValue(calendar.get(11));
        this.jsMinute.setValue(calendar.get(12));
        this.jsSecond.setValue(calendar.get(13));
    }

    private int getSelectedDayOfMonth() {
        if (this.jlSelectedDayOfMonth == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.jlSelectedDayOfMonth.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void setSelectedDay(JLabel newDay) {
        if (this.jlSelectedDayOfMonth != null) {
            this.jlSelectedDayOfMonth.setForeground(DAY_FOREGROUND);
            this.jlSelectedDayOfMonth.setBackground(DAY_BACKGROUND);
        }
        this.jlSelectedDayOfMonth = newDay;
        this.jlSelectedDayOfMonth.setForeground(SELECTED_DAY_FOREGROUND);
        this.jlSelectedDayOfMonth.setBackground(SELECTED_DAY_BACKGROUND);
    }

    private void setSelectedDay(int newDay) {
        this.setSelectedDay(this.jlDaysOfMonth[(newDay + this.indexOfFirstDayOfMonth - 1) / 7 + 1][(newDay + this.indexOfFirstDayOfMonth - 1) % 7]);
    }

    private void update() {
        int day = this.getSelectedDayOfMonth();
        for (int i = 0; i < 7; ++i) {
            this.jlDaysOfMonth[1][i].setText(EMPTY_DAY);
            this.jlDaysOfMonth[5][i].setText(EMPTY_DAY);
            this.jlDaysOfMonth[6][i].setText(EMPTY_DAY);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, 1);
        calendar.set(2, this.jcbMonth.getSelectedIndex());
        calendar.set(1, (Integer)this.jsYear.getValue());
        this.calculateIndexOfFirstDayOfMonth(calendar);
        this.lastDayOfSelectedMonth = ((Calendar)calendar).getActualMaximum(5);
        for (int i = 0; i < this.lastDayOfSelectedMonth; ++i) {
            this.jlDaysOfMonth[(i + this.indexOfFirstDayOfMonth) / 7 + 1][(i + this.indexOfFirstDayOfMonth) % 7].setText(String.valueOf(i + 1));
        }
        if (day != -1) {
            if (day > this.lastDayOfSelectedMonth) {
                day = this.lastDayOfSelectedMonth;
            }
            this.setSelectedDay(day);
        }
    }

    private void calculateIndexOfFirstDayOfMonth(Calendar calendar) {
        int dayOfWeek = calendar.get(7);
        this.indexOfFirstDayOfMonth = dayOfWeek - 2;
        if (this.indexOfFirstDayOfMonth < 0) {
            this.indexOfFirstDayOfMonth = 6;
        }
    }

    private void selectDay(JLabel jlDay) {
        if (!jlDay.getText().equals(EMPTY_DAY)) {
            this.setSelectedDay(jlDay);
        }
        this.jpDaysOfMonth.requestFocus();
    }

    private void calendarKeyboardNavigation(KeyEvent evt) {
        int day = this.getSelectedDayOfMonth();
        switch (evt.getKeyCode()) {
            case 37: {
                if (day <= 1) break;
                this.setSelectedDay(day - 1);
                break;
            }
            case 39: {
                if (day >= this.lastDayOfSelectedMonth) break;
                this.setSelectedDay(day + 1);
                break;
            }
            case 38: {
                if (day <= 7) break;
                this.setSelectedDay(day - 7);
                break;
            }
            case 40: {
                if (day > this.lastDayOfSelectedMonth - 7) break;
                this.setSelectedDay(day + 7);
            }
        }
    }

    private void okPressed() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(5, this.getSelectedDayOfMonth());
        calendar.set(2, this.jcbMonth.getSelectedIndex());
        calendar.set(1, (Integer)this.jsYear.getValue());
        calendar.set(11, (Integer)this.jsHour.getValue());
        calendar.set(12, (Integer)this.jsMinute.getValue());
        calendar.set(13, (Integer)this.jsSecond.getValue());
        calendar.set(14, 0);
        this.date = calendar.getTime();
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    static {
        WEEK_DAY_BACKGROUND = LIGHT_BLUE = new Color(51, 119, 204);
        WEEK_DAY_FOREGROUND = Color.WHITE;
        DAY_FOREGROUND = LIGHT_BLUE;
        DAY_BACKGROUND = Color.WHITE;
        SELECTED_DAY_FOREGROUND = Color.WHITE;
        SELECTED_DAY_BACKGROUND = Color.BLUE;
    }

    private class DayOfMonthGridLayout
    implements LayoutManager {
        private int rows;
        private int cols;

        public DayOfMonthGridLayout(int rows, int cols) {
            this.rows = rows;
            this.cols = cols;
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
        }

        @Override
        public void removeLayoutComponent(Component child) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Component[] children = parent.getComponents();
                int length = children.length;
                int prefWidth = 0;
                int prefHeight = 0;
                for (int i = 0; i < length; ++i) {
                    Dimension prefSize = children[i].getPreferredSize();
                    if (prefSize.width > prefWidth) {
                        prefWidth = prefSize.width;
                    }
                    if (prefSize.height <= prefHeight) continue;
                    prefHeight = prefSize.height;
                }
                return new Dimension(this.cols * prefWidth + insets.left + insets.right, this.rows * prefHeight + insets.top + insets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Component[] children = parent.getComponents();
                int length = children.length;
                int minWidth = 0;
                int minHeight = 0;
                for (int i = 0; i < length; ++i) {
                    Dimension minSize = children[i].getMinimumSize();
                    if (minSize.width > minWidth) {
                        minWidth = minSize.width;
                    }
                    if (minSize.height <= minHeight) continue;
                    minHeight = minSize.height;
                }
                return new Dimension(this.cols * minWidth + insets.left + insets.right, this.rows * minHeight + insets.top + insets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int col;
                int x;
                int row;
                Insets insets = parent.getInsets();
                int width = (parent.getWidth() - (insets.left + insets.right)) / this.cols + 1;
                int widthRemainder = (parent.getWidth() - (insets.left + insets.right)) % this.cols;
                int height = (parent.getHeight() - (insets.top + insets.bottom)) / this.rows + 1;
                int heightRemainder = (parent.getHeight() - (insets.top + insets.bottom)) % this.rows;
                Component[] children = parent.getComponents();
                int i = 0;
                int y = 0;
                for (row = 0; row < heightRemainder; ++row) {
                    x = 0;
                    for (col = 0; col < widthRemainder; ++col) {
                        children[i++].setBounds(x + insets.left, y + insets.top, width, height);
                        x += width;
                    }
                    --width;
                    for (col = widthRemainder; col < this.cols; ++col) {
                        children[i++].setBounds(x + insets.left, y + insets.top, width, height);
                        x += width;
                    }
                    y += height;
                    ++width;
                }
                --height;
                for (row = heightRemainder; row < this.rows; ++row) {
                    x = 0;
                    for (col = 0; col < widthRemainder; ++col) {
                        children[i++].setBounds(x + insets.left, y + insets.top, width, height);
                        x += width;
                    }
                    --width;
                    for (col = widthRemainder; col < this.cols; ++col) {
                        children[i++].setBounds(x + insets.left, y + insets.top, width, height);
                        x += width;
                    }
                    y += height;
                    ++width;
                }
            }
        }
    }
}

