/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.kse.ApplicationSettings;
import org.kse.crypto.Password;
import org.kse.gui.JEscDialog;
import org.kse.gui.KseFrame;
import org.kse.gui.MiGUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.actions.OpenAction;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.history.KeyStoreHistory;

public class DExamineSsl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private transient ApplicationSettings applicationSettings = ApplicationSettings.getInstance();
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlSslHost;
    private JComboBox<String> jcbSslHost;
    private JLabel jlSslPort;
    private JComboBox<String> jcbSslPort;
    private JCheckBox jcbClientAuth;
    private JComboBox<KeyStoreHistory> jcbKeyStore;
    private JButton jbLoadKeystore;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private String sslHost;
    private int sslPort = -1;
    private KseFrame kseFrame;
    private boolean cancelled = true;

    public DExamineSsl(JFrame parent, KseFrame kseFrame) {
        super((Window)parent, res.getString("DExamineSsl.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.kseFrame = kseFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.jlSslHost = new JLabel(res.getString("DExamineSsl.jlSslHost.text"));
        this.jcbSslHost = new JComboBox();
        this.jcbSslHost.setEditable(true);
        this.jcbSslHost.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.jcbSslHost.setToolTipText(res.getString("DExamineSsl.jtfSslHost.tooltip"));
        this.jcbSslHost.setModel(new DefaultComboBoxModel<String>(this.getSslHosts()));
        this.jlSslPort = new JLabel(res.getString("DExamineSsl.jlSslPort.text"));
        this.jcbSslPort = new JComboBox();
        this.jcbSslPort.setEditable(true);
        this.jcbSslPort.setToolTipText(res.getString("DExamineSsl.jtfSslPort.tooltip"));
        this.jcbSslPort.setModel(new DefaultComboBoxModel<String>(this.getSslPorts()));
        this.jcbClientAuth = new JCheckBox(res.getString("DExamineSsl.jlEnableClientAuth.text"));
        this.jcbKeyStore = new JComboBox<KeyStoreHistory>(this.getKeystoreNames());
        this.jcbKeyStore.setToolTipText(res.getString("DExamineSsl.jcbKeyStore.tooltip"));
        this.jbLoadKeystore = new JButton();
        this.jbLoadKeystore.setIcon(new ImageIcon(this.getClass().getResource("images/open.png")));
        this.jbLoadKeystore.setToolTipText(res.getString("DExamineSsl.jbLoadKeystore.tooltip"));
        this.jbOK = new JButton(res.getString("DExamineSsl.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DExamineSsl.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[para]unrel[right]unrel[]", "[]unrel[]"));
        MiGUtil.addSeparator(pane, res.getString("DExamineSsl.jlConnSettings.text"));
        pane.add((Component)this.jlSslHost, "skip");
        pane.add(this.jcbSslHost, "sgx, wrap");
        pane.add((Component)this.jlSslPort, "skip");
        pane.add(this.jcbSslPort, "sgx, wrap para");
        MiGUtil.addSeparator(pane, res.getString("DExamineSsl.jlClientAuth.text"));
        pane.add((Component)this.jcbClientAuth, "left, spanx, wrap");
        pane.add((Component)new JLabel(res.getString("DExamineSsl.jlKeyStore.text")), "skip");
        pane.add(this.jcbKeyStore, "sgx");
        pane.add((Component)this.jbLoadKeystore, "wrap para");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jcbClientAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExamineSsl.this.updateClientAuthComponents();
            }
        });
        this.jbLoadKeystore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenAction openAction = new OpenAction(DExamineSsl.this.kseFrame);
                openAction.actionPerformed(evt);
                DExamineSsl.this.updateClientAuthComponents();
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExamineSsl.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExamineSsl.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DExamineSsl.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DExamineSsl.this.closeDialog();
            }
        });
        this.updateClientAuthComponents();
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private ComboBoxModel<KeyStoreHistory> getKeystoreNames() {
        KeyStoreHistory[] keyStoreHistories = this.kseFrame.getKeyStoreHistories();
        return new DefaultComboBoxModel<KeyStoreHistory>(keyStoreHistories);
    }

    public String getSslHost() {
        return this.sslHost;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public boolean useClientAuth() {
        return this.jcbClientAuth.isSelected();
    }

    public KeyStoreHistory getKeyStore() {
        return (KeyStoreHistory)this.jcbKeyStore.getSelectedItem();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private String[] getSslHosts() {
        String sslHosts = this.applicationSettings.getSslHosts();
        String[] hosts = sslHosts.split(";");
        return hosts;
    }

    private String[] getSslPorts() {
        String sslPorts = this.applicationSettings.getSslPorts();
        String[] ports = sslPorts.split(";");
        return ports;
    }

    private void updateClientAuthComponents() {
        this.jcbKeyStore.setEnabled(this.jcbClientAuth.isSelected());
        this.jbLoadKeystore.setEnabled(this.jcbClientAuth.isSelected());
        this.jcbKeyStore.setModel(this.getKeystoreNames());
    }

    private void okPressed() {
        String sslHost = ((String)this.jcbSslHost.getSelectedItem()).trim();
        if (sslHost.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.SslHostReq.message"), this.getTitle(), 2);
            return;
        }
        String sslPortStr = ((String)this.jcbSslPort.getSelectedItem()).trim();
        if (sslPortStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.SslPortReq.message"), this.getTitle(), 2);
            return;
        }
        int sslPort = 0;
        try {
            sslPort = Integer.parseInt(sslPortStr);
            if (sslPort < 1) {
                JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.PositiveIntegerSslPortReq.message"), this.getTitle(), 2);
                return;
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.PositiveIntegerSslPortReq.message"), this.getTitle(), 2);
            return;
        }
        this.sslHost = sslHost;
        this.sslPort = sslPort;
        if (this.useClientAuth()) {
            KeyStoreHistory ksh = (KeyStoreHistory)this.jcbKeyStore.getSelectedItem();
            if (ksh == null) {
                JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.NoKeyStoreSelected.message"), this.getTitle(), 2);
                return;
            }
            Password keyStorePassword = ksh.getCurrentState().getPassword();
            if (keyStorePassword == null && ksh.getCurrentState().getType().hasEntryPasswords()) {
                JOptionPane.showMessageDialog(this, res.getString("DExamineSsl.NoPasswordSetForKeyStore.message"), this.getTitle(), 2);
                return;
            }
        }
        this.applicationSettings.addSslHost(sslHost);
        this.applicationSettings.addSslPort(sslPortStr);
        this.cancelled = false;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DialogViewer.run(new DExamineSsl(new JFrame(), new KseFrame()));
    }
}

