/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kse.crypto.CryptoException;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;
import org.kse.utilities.io.IOUtils;

public class DViewCertCsrPem
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCopy;
    private JButton jbExport;
    private JPanel jpPem;
    private JScrollPane jspPem;
    private JTextArea jtaPem;
    private X509Certificate cert;
    private PKCS10CertificationRequest pkcs10Csr;

    public DViewCertCsrPem(JFrame parent, String title, X509Certificate cert) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.cert = cert;
        this.initComponents();
    }

    public DViewCertCsrPem(JDialog parent, String title, X509Certificate cert) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.cert = cert;
        this.initComponents();
    }

    public DViewCertCsrPem(JFrame parent, String title, PKCS10CertificationRequest pkcs10Csr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    public DViewCertCsrPem(JDialog parent, String title, PKCS10CertificationRequest pkcs10Csr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jbOK = new JButton(res.getString("DViewCertCsrPem.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewCertCsrPem.this.okPressed();
            }
        });
        this.jbCopy = new JButton(res.getString("DViewCertCsrPem.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DViewCertCsrPem.jbCopy.mnemonic").charAt(0));
        if (this.cert != null) {
            this.jbCopy.setToolTipText(res.getString("DViewCertCsrPem.jbCertCopy.tooltip"));
        } else {
            this.jbCopy.setToolTipText(res.getString("DViewCertCsrPem.jbCsrCopy.tooltip"));
        }
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertCsrPem.this);
                    DViewCertCsrPem.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertCsrPem.this);
                }
            }
        });
        this.jbExport = new JButton(res.getString("DViewCertCsrPem.jbExport.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExport, res.getString("DViewCertCsrPem.jbExport.mnemonic").charAt(0));
        if (this.cert != null) {
            this.jbExport.setToolTipText(res.getString("DViewCertCsrPem.jbCertExport.tooltip"));
        } else {
            this.jbExport.setToolTipText(res.getString("DViewCertCsrPem.jbCsrExport.tooltip"));
        }
        this.jbExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCertCsrPem.this);
                    DViewCertCsrPem.this.exportPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCertCsrPem.this);
                }
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, new JButton[]{this.jbCopy, this.jbExport});
        this.jpPem = new JPanel(new BorderLayout());
        this.jpPem.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtaPem = this.cert != null ? new JTextArea(X509CertUtil.getCertEncodedX509Pem(this.cert)) : new JTextArea(Pkcs10Util.getCsrEncodedDerPem(this.pkcs10Csr));
        this.jtaPem.setCaretPosition(0);
        this.jtaPem.setEditable(false);
        this.jtaPem.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaPem.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jspPem = PlatformUtil.createScrollPane(this.jtaPem, 22, 32);
        this.jspPem.setPreferredSize(new Dimension(500, 300));
        this.jpPem.add((Component)this.jspPem, "Center");
        this.getContentPane().add((Component)this.jpPem, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewCertCsrPem.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewCertCsrPem.this.jbOK.requestFocus();
            }
        });
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void copyPressed() {
        String policy = this.jtaPem.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(policy);
        clipboard.setContents(copy, copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportPressed() {
        File chosenFile = null;
        FileWriter fw = null;
        String title = this.cert != null ? res.getString("DViewCertCsrPem.ExportPemCertificate.Title") : res.getString("DViewCertCsrPem.ExportPemCsr.Title");
        try {
            String message;
            int selected;
            int rtnValue;
            String certPem = this.jtaPem.getText();
            JFileChooser chooser = FileChooserFactory.getX509FileChooser();
            chooser.setCurrentDirectory(CurrentDirectory.get());
            chooser.setDialogTitle(title);
            chooser.setMultiSelectionEnabled(false);
            int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DViewCertCsrPem.ChooseExportFile.button"));
            if (rtnValue != 0) {
                return;
            }
            chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            if (chosenFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DViewCertCsrPem.OverWriteFile.message"), chosenFile), title, 0)) != 0) {
                IOUtils.closeQuietly(fw);
                return;
            }
            fw = new FileWriter(chosenFile);
            fw.write(certPem);
            fw.flush();
            IOUtils.closeQuietly(fw);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DViewCertCsrPem.NoWriteFile.message"), chosenFile), title, 2);
            return;
        }
        catch (Exception ex) {
            DError.displayError(this, (Throwable)ex);
            return;
        }
        finally {
            IOUtils.closeQuietly(fw);
        }
        JOptionPane.showMessageDialog(this, res.getString("DViewCertCsrPem.ExportPemCertificateSuccessful.message"), title, 1);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

