/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.RevokedCertsTableCellRend;
import org.kse.gui.dialogs.RevokedCertsTableHeadRend;
import org.kse.gui.dialogs.RevokedCertsTableModel;
import org.kse.gui.dialogs.extensions.DViewExtensions;
import org.kse.gui.error.DError;
import org.kse.utilities.StringUtils;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewCrl
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JPanel jpOK;
    private JButton jbOK;
    private JPanel jpCRL;
    private JLabel jlVersion;
    private JTextField jtfVersion;
    private JLabel jlIssuer;
    private JDistinguishedName jdnIssuer;
    private JLabel jlEffectiveDate;
    private JTextField jtfEffectiveDate;
    private JLabel jlNextUpdate;
    private JTextField jtfNextUpdate;
    private JLabel jlSignatureAlgorithm;
    private JTextField jtfSignatureAlgorithm;
    private JPanel jpCrlButtons;
    private JButton jbCrlExtensions;
    private JButton jbCrlAsn1;
    private JPanel jpRevokedCertsTable;
    private JLabel jlRevokedCerts;
    private JScrollPane jspRevokedCertsTable;
    private JKseTable jtRevokedCerts;
    private JPanel jpCrlEntryExtensions;
    private JButton jbCrlEntryExtensions;
    private X509CRL crl;

    public DViewCrl(JFrame parent, String title, X509CRL crl) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.crl = crl;
        this.initComponents();
    }

    public DViewCrl(JDialog parent, String title, Dialog.ModalityType modality, X509CRL crl) {
        super((Window)parent, title, modality);
        this.crl = crl;
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 1;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        GridBagConstraints gbcCtrl = new GridBagConstraints();
        gbcCtrl.gridx = 1;
        gbcCtrl.gridwidth = 1;
        gbcCtrl.gridheight = 1;
        gbcCtrl.insets = new Insets(5, 5, 5, 5);
        gbcCtrl.anchor = 17;
        this.jlVersion = new JLabel(res.getString("DViewCrl.jlVersion.text"));
        GridBagConstraints gbc_jlVersion = (GridBagConstraints)gbcLbl.clone();
        gbc_jlVersion.gridy = 0;
        this.jtfVersion = new JTextField(3);
        this.jtfVersion.setEditable(false);
        this.jtfVersion.setToolTipText(res.getString("DViewCrl.jtfVersion.tooltip"));
        GridBagConstraints gbc_jtfVersion = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfVersion.gridy = 0;
        this.jlIssuer = new JLabel(res.getString("DViewCrl.jlIssuer.text"));
        GridBagConstraints gbc_jlIssuer = (GridBagConstraints)gbcLbl.clone();
        gbc_jlIssuer.gridy = 1;
        this.jdnIssuer = new JDistinguishedName(res.getString("DViewCrl.Issuer.Title"), 30, false);
        this.jdnIssuer.setToolTipText(res.getString("DViewCrl.jdnIssuer.tooltip"));
        GridBagConstraints gbc_jdnIssuer = (GridBagConstraints)gbcCtrl.clone();
        gbc_jdnIssuer.gridy = 1;
        this.jlEffectiveDate = new JLabel(res.getString("DViewCrl.jlEffectiveDate.text"));
        GridBagConstraints gbc_jlEffectiveDate = (GridBagConstraints)gbcLbl.clone();
        gbc_jlEffectiveDate.gridy = 2;
        this.jtfEffectiveDate = new JTextField(30);
        this.jtfEffectiveDate.setEditable(false);
        this.jtfEffectiveDate.setToolTipText(res.getString("DViewCrl.jtfEffectiveDate.tooltip"));
        GridBagConstraints gbc_jtfEffectiveDate = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfEffectiveDate.gridy = 2;
        this.jlNextUpdate = new JLabel(res.getString("DViewCrl.jlNextUpdate.text"));
        GridBagConstraints gbc_jlNextUpdate = (GridBagConstraints)gbcLbl.clone();
        gbc_jlNextUpdate.gridy = 3;
        this.jtfNextUpdate = new JTextField(30);
        this.jtfNextUpdate.setEditable(false);
        this.jtfNextUpdate.setToolTipText(res.getString("DViewCrl.jtfNextUpdate.tooltip"));
        GridBagConstraints gbc_jtfNextUpdate = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfNextUpdate.gridy = 3;
        this.jlSignatureAlgorithm = new JLabel(res.getString("DViewCrl.jlSignatureAlgorithm.text"));
        GridBagConstraints gbc_jlSignatureAlgorithm = (GridBagConstraints)gbcLbl.clone();
        gbc_jlSignatureAlgorithm.gridy = 4;
        this.jtfSignatureAlgorithm = new JTextField(15);
        this.jtfSignatureAlgorithm.setEditable(false);
        this.jtfSignatureAlgorithm.setToolTipText(res.getString("DViewCrl.jtfSignatureAlgorithm.tooltip"));
        GridBagConstraints gbc_jtfSignatureAlgorithm = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfSignatureAlgorithm.gridy = 4;
        this.jbCrlExtensions = new JButton(res.getString("DViewCrl.jbCrlExtensions.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCrlExtensions, res.getString("DViewCrl.jbCrlExtensions.mnemonic").charAt(0));
        this.jbCrlExtensions.setToolTipText(res.getString("DViewCrl.jbCrlExtensions.tooltip"));
        this.jbCrlExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCrl.this);
                    DViewCrl.this.crlExtensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCrl.this);
                }
            }
        });
        this.jbCrlAsn1 = new JButton(res.getString("DViewCrl.jbCrlAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCrlAsn1, res.getString("DViewCrl.jbCrlAsn1.mnemonic").charAt(0));
        this.jbCrlAsn1.setToolTipText(res.getString("DViewCrl.jbCrlAsn1.tooltip"));
        this.jbCrlAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCrl.this);
                    DViewCrl.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCrl.this);
                }
            }
        });
        this.jpCrlButtons = new JPanel(new FlowLayout(0, 5, 0));
        this.jpCrlButtons.add(this.jbCrlExtensions);
        this.jpCrlButtons.add(this.jbCrlAsn1);
        GridBagConstraints gbc_jpCrlButtons = new GridBagConstraints();
        gbc_jpCrlButtons.gridx = 0;
        gbc_jpCrlButtons.gridy = 5;
        gbc_jpCrlButtons.gridwidth = 2;
        gbc_jpCrlButtons.gridheight = 1;
        gbc_jpCrlButtons.insets = new Insets(5, 0, 5, 0);
        gbc_jpCrlButtons.anchor = 13;
        this.jlRevokedCerts = new JLabel(res.getString("DViewCrl.jlRevokedCerts.text"));
        RevokedCertsTableModel rcModel = new RevokedCertsTableModel();
        this.jtRevokedCerts = new JKseTable(rcModel);
        TableRowSorter<RevokedCertsTableModel> sorter = new TableRowSorter<RevokedCertsTableModel>(rcModel);
        this.jtRevokedCerts.setRowSorter(sorter);
        this.jtRevokedCerts.setShowGrid(false);
        this.jtRevokedCerts.setRowMargin(0);
        this.jtRevokedCerts.getColumnModel().setColumnMargin(0);
        this.jtRevokedCerts.getTableHeader().setReorderingAllowed(false);
        this.jtRevokedCerts.setAutoResizeMode(4);
        for (int i = 0; i < this.jtRevokedCerts.getColumnCount(); ++i) {
            TableColumn column = this.jtRevokedCerts.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(100);
            }
            column.setHeaderRenderer(new RevokedCertsTableHeadRend(this.jtRevokedCerts.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new RevokedCertsTableCellRend());
        }
        ListSelectionModel listSelectionModel = this.jtRevokedCerts.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    try {
                        CursorUtil.setCursorBusy(DViewCrl.this);
                        DViewCrl.this.crlEntrySelection();
                    }
                    finally {
                        CursorUtil.setCursorFree(DViewCrl.this);
                    }
                }
            }
        });
        this.jtRevokedCerts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DViewCrl.this.maybeDisplayCrlEntryExtensions(evt);
            }
        });
        this.jspRevokedCertsTable = PlatformUtil.createScrollPane(this.jtRevokedCerts, 20, 30);
        this.jspRevokedCertsTable.getViewport().setBackground(this.jtRevokedCerts.getBackground());
        this.jpRevokedCertsTable = new JPanel(new BorderLayout(10, 10));
        this.jpRevokedCertsTable.setPreferredSize(new Dimension(100, 200));
        this.jpRevokedCertsTable.add((Component)this.jlRevokedCerts, "North");
        this.jpRevokedCertsTable.add((Component)this.jspRevokedCertsTable, "Center");
        this.jpRevokedCertsTable.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        this.jbCrlEntryExtensions = new JButton(res.getString("DViewCrl.jbCrlEntryExtensions.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCrlEntryExtensions, res.getString("DViewCrl.jbCrlEntryExtensions.mnemonic").charAt(0));
        this.jbCrlEntryExtensions.setToolTipText(res.getString("DViewCrl.jbCrlEntryExtensions.tooltip"));
        this.jbCrlEntryExtensions.setEnabled(false);
        this.jbCrlEntryExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCrl.this);
                    DViewCrl.this.crlEntryExtensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCrl.this);
                }
            }
        });
        this.jpCrlEntryExtensions = new JPanel(new FlowLayout(2));
        this.jpCrlEntryExtensions.add(this.jbCrlEntryExtensions);
        this.jpRevokedCertsTable.add((Component)this.jpCrlEntryExtensions, "South");
        GridBagConstraints gbc_jpRevokedCertsTable = new GridBagConstraints();
        gbc_jpRevokedCertsTable.gridx = 0;
        gbc_jpRevokedCertsTable.gridy = 6;
        gbc_jpRevokedCertsTable.gridwidth = 2;
        gbc_jpRevokedCertsTable.gridheight = 1;
        gbc_jpRevokedCertsTable.insets = new Insets(5, 5, 5, 5);
        gbc_jpRevokedCertsTable.fill = 1;
        gbc_jpRevokedCertsTable.anchor = 10;
        this.jpCRL = new JPanel(new GridBagLayout());
        this.jpCRL.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new EtchedBorder()));
        this.jpCRL.add((Component)this.jlVersion, gbc_jlVersion);
        this.jpCRL.add((Component)this.jtfVersion, gbc_jtfVersion);
        this.jpCRL.add((Component)this.jlIssuer, gbc_jlIssuer);
        this.jpCRL.add((Component)this.jdnIssuer, gbc_jdnIssuer);
        this.jpCRL.add((Component)this.jlEffectiveDate, gbc_jlEffectiveDate);
        this.jpCRL.add((Component)this.jtfEffectiveDate, gbc_jtfEffectiveDate);
        this.jpCRL.add((Component)this.jlNextUpdate, gbc_jlNextUpdate);
        this.jpCRL.add((Component)this.jtfNextUpdate, gbc_jtfNextUpdate);
        this.jpCRL.add((Component)this.jlSignatureAlgorithm, gbc_jlSignatureAlgorithm);
        this.jpCRL.add((Component)this.jtfSignatureAlgorithm, gbc_jtfSignatureAlgorithm);
        this.jpCRL.add((Component)this.jpCrlButtons, gbc_jpCrlButtons);
        this.jpCRL.add((Component)this.jpRevokedCertsTable, gbc_jpRevokedCertsTable);
        this.populateDialog();
        this.jbOK = new JButton(res.getString("DViewCrl.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewCrl.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.getContentPane().add((Component)this.jpCRL, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewCrl.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewCrl.this.jbOK.requestFocus();
            }
        });
    }

    private void populateDialog() {
        Date currentDate = new Date();
        Date effectiveDate = this.crl.getThisUpdate();
        Date updateDate = this.crl.getNextUpdate();
        boolean effective = currentDate.before(effectiveDate);
        boolean updateAvailable = false;
        if (updateDate != null) {
            updateAvailable = currentDate.after(updateDate);
        }
        this.jtfVersion.setText(Integer.toString(this.crl.getVersion()));
        this.jtfVersion.setCaretPosition(0);
        this.jdnIssuer.setDistinguishedName(X500NameUtils.x500PrincipalToX500Name(this.crl.getIssuerX500Principal()));
        this.jtfEffectiveDate.setText(StringUtils.formatDate(effectiveDate));
        if (effective) {
            this.jtfEffectiveDate.setText(MessageFormat.format(res.getString("DViewCrl.jtfEffectiveDate.noteffective.text"), this.jtfEffectiveDate.getText()));
            this.jtfEffectiveDate.setForeground(Color.red);
        } else {
            this.jtfEffectiveDate.setForeground(this.jtfVersion.getForeground());
        }
        this.jtfEffectiveDate.setCaretPosition(0);
        if (updateDate != null) {
            this.jtfNextUpdate.setText(StringUtils.formatDate(updateDate));
        } else {
            this.jtfNextUpdate.setText(res.getString("DViewCrl.jtfNextUpdate.none.text"));
        }
        if (updateAvailable) {
            this.jtfNextUpdate.setText(MessageFormat.format(res.getString("DViewCrl.jtfNextUpdate.updateavailable.text"), this.jtfNextUpdate.getText()));
            this.jtfNextUpdate.setForeground(Color.red);
        } else {
            this.jtfNextUpdate.setForeground(this.jtfVersion.getForeground());
        }
        this.jtfNextUpdate.setCaretPosition(0);
        this.jtfSignatureAlgorithm.setText(this.crl.getSigAlgName());
        this.jtfSignatureAlgorithm.setCaretPosition(0);
        Set<String> critExts = this.crl.getCriticalExtensionOIDs();
        Set<String> nonCritExts = this.crl.getNonCriticalExtensionOIDs();
        if (critExts != null && critExts.size() != 0 || nonCritExts != null && nonCritExts.size() != 0) {
            this.jbCrlExtensions.setEnabled(true);
        } else {
            this.jbCrlExtensions.setEnabled(false);
        }
        Set<? extends X509CRLEntry> revokedCertsSet = this.crl.getRevokedCertificates();
        if (revokedCertsSet == null) {
            revokedCertsSet = new HashSet<X509CRLEntry>();
        }
        X509CRLEntry[] revokedCerts = revokedCertsSet.toArray(new X509CRLEntry[revokedCertsSet.size()]);
        RevokedCertsTableModel revokedCertsTableModel = (RevokedCertsTableModel)this.jtRevokedCerts.getModel();
        revokedCertsTableModel.load(revokedCerts);
        if (revokedCertsTableModel.getRowCount() > 0) {
            this.jtRevokedCerts.changeSelection(0, 0, false, false);
        }
    }

    private void crlEntrySelection() {
        int row = this.jtRevokedCerts.getSelectedRow();
        if (row != -1) {
            BigInteger serialNumber = (BigInteger)this.jtRevokedCerts.getValueAt(row, 0);
            Set<? extends X509CRLEntry> revokedCertsSet = this.crl.getRevokedCertificates();
            X509CRLEntry x509CrlEntry = null;
            for (X509CRLEntry x509CRLEntry : revokedCertsSet) {
                if (!serialNumber.equals(x509CRLEntry.getSerialNumber())) continue;
                x509CrlEntry = x509CRLEntry;
                break;
            }
            if (x509CrlEntry.hasExtensions()) {
                this.jbCrlEntryExtensions.setEnabled(true);
                return;
            }
        }
        this.jbCrlEntryExtensions.setEnabled(false);
    }

    private void crlExtensionsPressed() {
        DViewExtensions dViewExtensions = new DViewExtensions(this, res.getString("DViewCrl.Extensions.Title"), (X509Extension)this.crl);
        dViewExtensions.setLocationRelativeTo(this);
        dViewExtensions.setVisible(true);
    }

    private void asn1DumpPressed() {
        try {
            DViewAsn1Dump dViewAsn1Dump = new DViewAsn1Dump((JDialog)this, this.crl);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void crlEntryExtensionsPressed() {
        this.displayCrlEntryExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDisplayCrlEntryExtensions(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtRevokedCerts.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtRevokedCerts.setRowSelectionInterval(row, row);
                this.displayCrlEntryExtensions();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void displayCrlEntryExtensions() {
        int row = this.jtRevokedCerts.getSelectedRow();
        if (row != -1) {
            BigInteger serialNumber = (BigInteger)this.jtRevokedCerts.getValueAt(row, 0);
            Set<? extends X509CRLEntry> revokedCertsSet = this.crl.getRevokedCertificates();
            X509CRLEntry x509CrlEntry = null;
            for (X509CRLEntry x509CRLEntry : revokedCertsSet) {
                if (!serialNumber.equals(x509CRLEntry.getSerialNumber())) continue;
                x509CrlEntry = x509CRLEntry;
                break;
            }
            if (x509CrlEntry.hasExtensions()) {
                DViewExtensions dViewExtensions = new DViewExtensions(this, res.getString("DViewCrl.EntryExtensions.Title"), (X509Extension)x509CrlEntry);
                dViewExtensions.setLocationRelativeTo(this);
                dViewExtensions.setVisible(true);
            }
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

