/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.cert.X509Extension;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.csr.spkac.SpkacSubject;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.JDistinguishedName;
import org.kse.gui.dialogs.DViewAsn1Dump;
import org.kse.gui.dialogs.DViewPem;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.dialogs.DialogHelper;
import org.kse.gui.dialogs.extensions.DViewExtensions;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.asn1.Asn1Exception;

public class DViewCsr
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/resources");
    private JLabel jlFormat;
    private JTextField jtfFormat;
    private JLabel jlSubject;
    private JDistinguishedName jdnSubject;
    private JLabel jlPublicKey;
    private JTextField jtfPublicKey;
    private JButton jbViewPublicKeyDetails;
    private JLabel jlSignatureAlgorithm;
    private JTextField jtfSignatureAlgorithm;
    private JLabel jlChallenge;
    private JTextField jtfChallenge;
    private JLabel jlUnstructuredName;
    private JTextField jtfUnstructuredName;
    private JButton jbExtensions;
    private JButton jbPem;
    private JButton jbAsn1;
    private JButton jbOK;
    private PKCS10CertificationRequest pkcs10Csr;
    private Spkac spkacCsr;

    public DViewCsr(JFrame parent, String title, PKCS10CertificationRequest pkcs10Csr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pkcs10Csr = pkcs10Csr;
        this.initComponents();
    }

    public DViewCsr(JFrame parent, String title, Spkac spkacCsr) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.spkacCsr = spkacCsr;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jlFormat = new JLabel(res.getString("DViewCsr.jlFormat.text"));
        this.jtfFormat = new JTextField(15);
        this.jtfFormat.setEditable(false);
        this.jtfFormat.setToolTipText(res.getString("DViewCsr.jtfFormat.tooltip"));
        this.jlSubject = new JLabel(res.getString("DViewCsr.jlSubject.text"));
        this.jdnSubject = new JDistinguishedName(res.getString("DViewCsr.Subject.Title"), 30, false);
        this.jdnSubject.setToolTipText(res.getString("DViewCsr.jdnSubject.tooltip"));
        this.jlPublicKey = new JLabel(res.getString("DViewCsr.jlPublicKey.text"));
        this.jtfPublicKey = new JTextField(15);
        this.jtfPublicKey.setEditable(false);
        this.jtfPublicKey.setToolTipText(res.getString("DViewCsr.jtfPublicKey.tooltip"));
        this.jbViewPublicKeyDetails = new JButton();
        this.jbViewPublicKeyDetails.setToolTipText(res.getString("DViewCsr.jbViewPublicKeyDetails.tooltip"));
        this.jbViewPublicKeyDetails.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/viewpubkey.png"))));
        this.jlSignatureAlgorithm = new JLabel(res.getString("DViewCsr.jlSignatureAlgorithm.text"));
        this.jtfSignatureAlgorithm = new JTextField(15);
        this.jtfSignatureAlgorithm.setEditable(false);
        this.jtfSignatureAlgorithm.setToolTipText(res.getString("DViewCsr.jtfSignatureAlgorithm.tooltip"));
        this.jlChallenge = new JLabel(res.getString("DViewCsr.jlChallenge.text"));
        this.jtfChallenge = new JTextField(15);
        this.jtfChallenge.setEditable(false);
        this.jtfChallenge.setToolTipText(res.getString("DViewCsr.jtfChallenge.tooltip"));
        this.jlUnstructuredName = new JLabel(res.getString("DViewCsr.jlUnstructuredName.text"));
        this.jtfUnstructuredName = new JTextField(30);
        this.jtfUnstructuredName.setEditable(false);
        this.jtfUnstructuredName.setToolTipText(res.getString("DViewCsr.jtfUnstructuredName.tooltip"));
        this.jbExtensions = new JButton(res.getString("DViewCsr.jbExtensions.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbExtensions, res.getString("DViewCsr.jbExtensions.mnemonic").charAt(0));
        this.jbExtensions.setToolTipText(res.getString("DViewCsr.jbExtensions.tooltip"));
        this.jbPem = new JButton(res.getString("DViewCsr.jbPem.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbPem, res.getString("DViewCsr.jbPem.mnemonic").charAt(0));
        this.jbPem.setToolTipText(res.getString("DViewCsr.jbPem.tooltip"));
        this.jbAsn1 = new JButton(res.getString("DViewCsr.jbAsn1.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbAsn1, res.getString("DViewCsr.jbAsn1.mnemonic").charAt(0));
        this.jbAsn1.setToolTipText(res.getString("DViewCsr.jbAsn1.tooltip"));
        this.jbOK = new JButton(res.getString("DViewCsr.jbOK.text"));
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "[right]unrel[]", "[]unrel[]"));
        pane.add((Component)this.jlFormat, "");
        pane.add((Component)this.jtfFormat, "wrap");
        pane.add((Component)this.jlSubject, "");
        pane.add((Component)this.jdnSubject, "wrap");
        pane.add((Component)this.jlPublicKey, "");
        pane.add((Component)this.jtfPublicKey, "split 2");
        pane.add((Component)this.jbViewPublicKeyDetails, "wrap");
        pane.add((Component)this.jlSignatureAlgorithm, "");
        pane.add((Component)this.jtfSignatureAlgorithm, "wrap");
        pane.add((Component)this.jlChallenge, "");
        pane.add((Component)this.jtfChallenge, "wrap");
        pane.add((Component)this.jlUnstructuredName, "");
        pane.add((Component)this.jtfUnstructuredName, "wrap para");
        pane.add((Component)this.jbExtensions, "spanx, split");
        pane.add((Component)this.jbPem, "");
        pane.add((Component)this.jbAsn1, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap 15:push");
        pane.add((Component)this.jbOK, "spanx, tag ok");
        this.populateCsrDetails();
        this.jbViewPublicKeyDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCsr.this);
                    DViewCsr.this.pubKeyDetailsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCsr.this);
                }
            }
        });
        this.jbExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCsr.this);
                    DViewCsr.this.extensionsPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCsr.this);
                }
            }
        });
        this.jbPem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCsr.this);
                    DViewCsr.this.pemEncodingPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCsr.this);
                }
            }
        });
        this.jbAsn1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewCsr.this);
                    DViewCsr.this.asn1DumpPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewCsr.this);
                }
            }
        });
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewCsr.this.okPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewCsr.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populateCsrDetails() throws CryptoException {
        if (this.pkcs10Csr != null) {
            this.populatePkcs10CsrDetails();
        } else {
            this.populateSpkacCsrDetails();
        }
    }

    private void populatePkcs10CsrDetails() throws CryptoException {
        this.jtfFormat.setText(res.getString("DViewCsr.jtfFormat.Pkcs10.text"));
        this.jtfFormat.setCaretPosition(0);
        this.jdnSubject.setDistinguishedName(this.pkcs10Csr.getSubject());
        this.jbPem.setEnabled(true);
        this.jbAsn1.setEnabled(true);
        Attribute[] extReqAttr = this.pkcs10Csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
        if (extReqAttr != null && extReqAttr.length > 0) {
            this.jbExtensions.setEnabled(true);
        } else {
            this.jbExtensions.setEnabled(false);
        }
        DialogHelper.populatePkcs10Challenge(this.pkcs10Csr.getAttributes(), this.jtfChallenge);
        DialogHelper.populatePkcs10UnstructuredName(this.pkcs10Csr.getAttributes(), this.jtfUnstructuredName);
        this.populatePublicKey(this.getPkcs10PublicKey());
        String sigAlgId = this.pkcs10Csr.getSignatureAlgorithm().getAlgorithm().getId();
        SignatureType sigAlg = SignatureType.resolveOid(sigAlgId);
        if (sigAlg != null) {
            this.jtfSignatureAlgorithm.setText(sigAlg.friendly());
        } else {
            this.jtfSignatureAlgorithm.setText(sigAlgId);
        }
        this.jtfSignatureAlgorithm.setCaretPosition(0);
    }

    private void populateSpkacCsrDetails() throws CryptoException {
        this.jtfFormat.setText(res.getString("DViewCsr.jtfFormat.Spkac.text"));
        this.jtfFormat.setCaretPosition(0);
        this.jbExtensions.setEnabled(false);
        this.jbPem.setEnabled(false);
        this.jbAsn1.setEnabled(true);
        SpkacSubject subject = this.spkacCsr.getSubject();
        this.jdnSubject.setDistinguishedName(subject.getName());
        this.populatePublicKey(this.spkacCsr.getPublicKey());
        this.jtfSignatureAlgorithm.setText(this.spkacCsr.getSignatureAlgorithm().friendly());
        this.jtfSignatureAlgorithm.setCaretPosition(0);
        this.jtfChallenge.setText(this.spkacCsr.getChallenge());
        this.jtfChallenge.setCaretPosition(0);
    }

    private void populatePublicKey(PublicKey csrPublicKey) throws CryptoException {
        KeyInfo keyInfo = KeyPairUtil.getKeyInfo(csrPublicKey);
        this.jtfPublicKey.setText(keyInfo.getAlgorithm());
        Integer keySize = keyInfo.getSize();
        if (keySize != null) {
            this.jtfPublicKey.setText(MessageFormat.format(res.getString("DViewCsr.jtfPublicKey.text"), this.jtfPublicKey.getText(), "" + keySize));
        } else {
            this.jtfPublicKey.setText(MessageFormat.format(res.getString("DViewCsr.jtfPublicKey.text"), this.jtfPublicKey.getText(), "?"));
        }
        this.jtfPublicKey.setCaretPosition(0);
    }

    private PublicKey getPkcs10PublicKey() throws CryptoException {
        try {
            return new JcaPKCS10CertificationRequest(this.pkcs10Csr).getPublicKey();
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("DViewCsr.NoGetPublicKey.message"), ex);
        }
    }

    private void extensionsPressed() {
        X509ExtensionSet x509ExtensionSet = Pkcs10Util.getExtensions(this.pkcs10Csr);
        DViewExtensions dViewExtensions = new DViewExtensions(this, res.getString("DViewCertificate.Extensions.Title"), (X509Extension)x509ExtensionSet);
        dViewExtensions.setLocationRelativeTo(this);
        dViewExtensions.setVisible(true);
    }

    private void pubKeyDetailsPressed() {
        try {
            PublicKey publicKey = null;
            publicKey = this.pkcs10Csr != null ? this.getPkcs10PublicKey() : this.spkacCsr.getPublicKey();
            DViewPublicKey dViewPublicKey = new DViewPublicKey(this, res.getString("DViewCsr.PubKeyDetails.Title"), publicKey);
            dViewPublicKey.setLocationRelativeTo(this);
            dViewPublicKey.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void pemEncodingPressed() {
        try {
            DViewPem dViewCsrPem = new DViewPem((JDialog)this, res.getString("DViewCsr.Pem.Title"), this.pkcs10Csr);
            dViewCsrPem.setLocationRelativeTo(this);
            dViewCsrPem.setVisible(true);
        }
        catch (CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void asn1DumpPressed() {
        try {
            DViewAsn1Dump dViewAsn1Dump = this.pkcs10Csr != null ? new DViewAsn1Dump((JDialog)this, this.pkcs10Csr) : new DViewAsn1Dump((JDialog)this, this.spkacCsr);
            dViewAsn1Dump.setLocationRelativeTo(this);
            dViewAsn1Dump.setVisible(true);
        }
        catch (IOException | Asn1Exception e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPair keyPair = keyGen.genKeyPair();
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name("cn=test"), keyPair.getPublic());
        PKCS10CertificationRequest csr = csrBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate()));
        DViewCsr dialog = new DViewCsr(new JFrame(), "Title", csr);
        DialogViewer.run(dialog);
    }
}

