/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.security.PrivateKey;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.SignatureType;

public class DialogHelper {
    private DialogHelper() {
    }

    public static void populateSigAlgs(KeyPairType keyPairType, PrivateKey privateKey, JComboBox<SignatureType> jcbSignatureAlgorithm) throws CryptoException {
        List<SignatureType> sigAlgs;
        switch (keyPairType) {
            case RSA: {
                KeyInfo keyInfo = KeyPairUtil.getKeyInfo(privateKey);
                sigAlgs = SignatureType.rsaSignatureTypes(keyInfo.getSize());
                break;
            }
            case DSA: {
                sigAlgs = SignatureType.dsaSignatureTypes();
                break;
            }
            default: {
                sigAlgs = SignatureType.ecdsaSignatureTypes();
            }
        }
        jcbSignatureAlgorithm.removeAllItems();
        for (SignatureType sigAlg : sigAlgs) {
            jcbSignatureAlgorithm.addItem(sigAlg);
        }
        if (sigAlgs.contains((Object)SignatureType.SHA256_RSA)) {
            jcbSignatureAlgorithm.setSelectedItem((Object)SignatureType.SHA256_RSA);
        } else if (sigAlgs.contains((Object)SignatureType.SHA256_ECDSA)) {
            jcbSignatureAlgorithm.setSelectedItem((Object)SignatureType.SHA256_ECDSA);
        } else if (sigAlgs.contains((Object)SignatureType.SHA256_DSA)) {
            jcbSignatureAlgorithm.setSelectedItem((Object)SignatureType.SHA256_DSA);
        } else {
            jcbSignatureAlgorithm.setSelectedIndex(0);
        }
    }

    public static void populatePkcs10Challenge(Attribute[] attributes, JTextField textField) {
        ASN1ObjectIdentifier pkcs9AtChallengepassword = PKCSObjectIdentifiers.pkcs_9_at_challengePassword;
        DialogHelper.populateTextField(attributes, textField, pkcs9AtChallengepassword);
    }

    public static void populatePkcs10UnstructuredName(Attribute[] attributes, JTextField textField) {
        ASN1ObjectIdentifier pkcs9UnstructureName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
        DialogHelper.populateTextField(attributes, textField, pkcs9UnstructureName);
    }

    private static void populateTextField(Attribute[] attrs, JTextField textField, ASN1ObjectIdentifier pkcs9Attr) {
        if (attrs != null) {
            for (Attribute attribute : attrs) {
                ASN1ObjectIdentifier attributeOid = attribute.getAttrType();
                if (!attributeOid.equals((ASN1Primitive)pkcs9Attr)) continue;
                ASN1Encodable challenge = attribute.getAttributeValues()[0];
                if (challenge instanceof DERPrintableString) {
                    textField.setText(((DERPrintableString)challenge).getString());
                } else if (challenge instanceof DERUTF8String) {
                    textField.setText(((DERUTF8String)challenge).getString());
                }
                textField.setCaretPosition(0);
            }
        }
    }
}

