/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.x509.InhibitAnyPolicy;
import org.kse.gui.PlatformUtil;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DInhibitAnyPolicy
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpInhibitAnyPolicy;
    private JLabel jlInhibitAnyPolicy;
    private JPanel jpSkipCertificates;
    private JLabel jlSkipCertificates;
    private JTextField jtfSkipCertificates;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DInhibitAnyPolicy(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DInhibitAnyPolicy.Title"));
        this.initComponents();
    }

    public DInhibitAnyPolicy(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DInhibitAnyPolicy.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlInhibitAnyPolicy = new JLabel(res.getString("DInhibitAnyPolicy.jlInhibitAnyPolicy.text"));
        this.jlInhibitAnyPolicy.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.jlSkipCertificates = new JLabel(res.getString("DInhibitAnyPolicy.jlSkipCertificates.text"));
        this.jtfSkipCertificates = new JTextField(3);
        this.jpSkipCertificates = new JPanel(new FlowLayout(0, 5, 5));
        this.jpSkipCertificates.add(this.jlSkipCertificates);
        this.jpSkipCertificates.add(this.jtfSkipCertificates);
        this.jpInhibitAnyPolicy = new JPanel(new BorderLayout(5, 5));
        this.jpInhibitAnyPolicy.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpInhibitAnyPolicy.add((Component)this.jlInhibitAnyPolicy, "North");
        this.jpInhibitAnyPolicy.add((Component)this.jpSkipCertificates, "Center");
        this.jbOK = new JButton(res.getString("DInhibitAnyPolicy.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DInhibitAnyPolicy.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DInhibitAnyPolicy.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DInhibitAnyPolicy.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DInhibitAnyPolicy.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpInhibitAnyPolicy, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DInhibitAnyPolicy.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        InhibitAnyPolicy inhibitAnyPolicy = InhibitAnyPolicy.getInstance(value);
        this.jtfSkipCertificates.setText("" + inhibitAnyPolicy.getSkipCerts());
        this.jtfSkipCertificates.setCaretPosition(0);
    }

    private void okPressed() {
        int skipCertificates = -1;
        String skipCertificatesStr = this.jtfSkipCertificates.getText().trim();
        if (skipCertificatesStr.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DInhibitAnyPolicy.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        try {
            skipCertificates = Integer.parseInt(skipCertificatesStr);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, res.getString("DInhibitAnyPolicy.InvalidLengthValue.message"), this.getTitle(), 2);
            return;
        }
        if (skipCertificates < 0) {
            JOptionPane.showMessageDialog(this, res.getString("DInhibitAnyPolicy.InvalidLengthValue.message"), this.getTitle(), 2);
            return;
        }
        InhibitAnyPolicy inhibitAnyPolicy = new InhibitAnyPolicy(skipCertificates);
        try {
            this.value = inhibitAnyPolicy.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

