/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.generalname.JGeneralNames;
import org.kse.gui.dialogs.extensions.DExtension;
import org.kse.gui.error.DError;

public class DIssuerAlternativeName
extends DExtension {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpIssuerAlternativeName;
    private JLabel jlAlternativeName;
    private JGeneralNames jgnAlternativeName;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private byte[] value;

    public DIssuerAlternativeName(JDialog parent) {
        super(parent);
        this.setTitle(res.getString("DIssuerAlternativeName.Title"));
        this.initComponents();
    }

    public DIssuerAlternativeName(JDialog parent, byte[] value) throws IOException {
        super(parent);
        this.setTitle(res.getString("DIssuerAlternativeName.Title"));
        this.initComponents();
        this.prepopulateWithValue(value);
    }

    private void initComponents() {
        this.jlAlternativeName = new JLabel(res.getString("DIssuerAlternativeName.jlAlternativeName.text"));
        GridBagConstraints gbc_jlAlternativeName = new GridBagConstraints();
        gbc_jlAlternativeName.gridx = 0;
        gbc_jlAlternativeName.gridy = 1;
        gbc_jlAlternativeName.gridwidth = 1;
        gbc_jlAlternativeName.gridheight = 1;
        gbc_jlAlternativeName.insets = new Insets(5, 5, 5, 5);
        gbc_jlAlternativeName.anchor = 12;
        this.jgnAlternativeName = new JGeneralNames(res.getString("DIssuerAlternativeName.AlternativeName.Title"));
        this.jgnAlternativeName.setPreferredSize(new Dimension(400, 150));
        GridBagConstraints gbc_jgnAlternativeName = new GridBagConstraints();
        gbc_jgnAlternativeName.gridx = 1;
        gbc_jgnAlternativeName.gridy = 1;
        gbc_jgnAlternativeName.gridwidth = 1;
        gbc_jgnAlternativeName.gridheight = 1;
        gbc_jgnAlternativeName.insets = new Insets(5, 5, 5, 5);
        gbc_jgnAlternativeName.anchor = 17;
        this.jpIssuerAlternativeName = new JPanel(new GridBagLayout());
        this.jpIssuerAlternativeName.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpIssuerAlternativeName.add((Component)this.jlAlternativeName, gbc_jlAlternativeName);
        this.jpIssuerAlternativeName.add((Component)this.jgnAlternativeName, gbc_jgnAlternativeName);
        this.jbOK = new JButton(res.getString("DIssuerAlternativeName.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DIssuerAlternativeName.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DIssuerAlternativeName.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DIssuerAlternativeName.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DIssuerAlternativeName.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpIssuerAlternativeName, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DIssuerAlternativeName.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void prepopulateWithValue(byte[] value) throws IOException {
        GeneralNames issuerAlternativeName = GeneralNames.getInstance((Object)value);
        if (issuerAlternativeName != null) {
            this.jgnAlternativeName.setGeneralNames(issuerAlternativeName);
        }
    }

    private void okPressed() {
        GeneralNames issuerAlternativeName = this.jgnAlternativeName.getGeneralNames();
        if (issuerAlternativeName.getNames().length == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DIssuerAlternativeName.ValueReq.message"), this.getTitle(), 2);
            return;
        }
        try {
            this.value = issuerAlternativeName.getEncoded("DER");
        }
        catch (IOException e) {
            DError.displayError(this, (Throwable)e);
            return;
        }
        this.closeDialog();
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

