/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.extensions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kse.crypto.CryptoException;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.publickey.KeyIdentifierGenerator;
import org.kse.crypto.x509.ExtendedKeyUsageType;
import org.kse.crypto.x509.X509Ext;
import org.kse.crypto.x509.X509ExtensionSet;
import org.kse.crypto.x509.X509ExtensionType;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;

public class DSelectStandardExtensionTemplate
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/extensions/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JRadioButton jrbCA;
    private JRadioButton jrbSslServer;
    private JRadioButton jrbSslClient;
    private JRadioButton jrbCodeSigning;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private X509ExtensionSet extensions = new X509ExtensionSet();
    private PublicKey authorityPublicKey;
    private PublicKey subjectPublicKey;
    private boolean cancelled = true;

    public DSelectStandardExtensionTemplate(JDialog parent, PublicKey authorityPublicKey, PublicKey subjectPublicKey) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.authorityPublicKey = authorityPublicKey;
        this.subjectPublicKey = subjectPublicKey;
        this.setTitle(res.getString("DSelectStandardExtensionTemplate.Title"));
        this.initComponents();
    }

    private void initComponents() {
        this.jrbCA = new JRadioButton(res.getString("DSelectStandardExtensionTemplate.jrbCA.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbCA, res.getString("DSelectStandardExtensionTemplate.jrbCA.mnemonic").charAt(0));
        this.jrbCA.setToolTipText(res.getString("DSelectStandardExtensionTemplate.jrbCA.tooltip"));
        this.jrbCA.setSelected(true);
        this.jrbSslServer = new JRadioButton(res.getString("DSelectStandardExtensionTemplate.jrbSslServer.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbSslServer, res.getString("DSelectStandardExtensionTemplate.jrbSslServer.mnemonic").charAt(0));
        this.jrbSslServer.setToolTipText(res.getString("DSelectStandardExtensionTemplate.jrbSslServer.tooltip"));
        this.jrbSslClient = new JRadioButton(res.getString("DSelectStandardExtensionTemplate.jrbSslClient.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbSslClient, res.getString("DSelectStandardExtensionTemplate.jrbSslClient.mnemonic").charAt(0));
        this.jrbSslClient.setToolTipText(res.getString("DSelectStandardExtensionTemplate.jrbSslClient.tooltip"));
        this.jrbCodeSigning = new JRadioButton(res.getString("DSelectStandardExtensionTemplate.jrbCodeSigning.text"), false);
        PlatformUtil.setMnemonic((AbstractButton)this.jrbCodeSigning, res.getString("DSelectStandardExtensionTemplate.jrbCodeSigning.mnemonic").charAt(0));
        this.jrbCodeSigning.setToolTipText(res.getString("DSelectStandardExtensionTemplate.jrbCodeSigning.tooltip"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbCA);
        buttonGroup.add(this.jrbSslServer);
        buttonGroup.add(this.jrbSslClient);
        buttonGroup.add(this.jrbCodeSigning);
        this.jbOK = new JButton(res.getString("DAddExtensions.jbOK.text"));
        this.jbCancel = new JButton(res.getString("DAddExtensions.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("fill", "[]", "[]"));
        pane.add((Component)this.jrbCA, "growx, wrap");
        pane.add((Component)this.jrbSslServer, "wrap");
        pane.add((Component)this.jrbSslClient, "wrap");
        pane.add((Component)this.jrbCodeSigning, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSelectStandardExtensionTemplate.this.okPressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSelectStandardExtensionTemplate.this.cancelPressed();
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSelectStandardExtensionTemplate.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSelectStandardExtensionTemplate.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private void okPressed() {
        this.setExtensionsAsSelected();
        this.closeDialog();
    }

    private void setExtensionsAsSelected() {
        X509ExtensionSet extensionSet = new X509ExtensionSet();
        try {
            this.addAuthorityKeyIdentifier(extensionSet);
            this.addSubjectKeyIdentifier(extensionSet);
            if (this.jrbCA.isSelected()) {
                this.addBasicConstraints(extensionSet);
                this.addKeyUsage(extensionSet, 6);
            }
            if (this.jrbSslClient.isSelected()) {
                this.addKeyUsage(extensionSet, 160);
                this.addExtKeyUsage(extensionSet, ExtendedKeyUsageType.CLIENT_AUTH.oid());
            }
            if (this.jrbSslServer.isSelected()) {
                this.addKeyUsage(extensionSet, 160);
                this.addExtKeyUsage(extensionSet, ExtendedKeyUsageType.SERVER_AUTH.oid());
            }
            if (this.jrbCodeSigning.isSelected()) {
                this.addKeyUsage(extensionSet, 128);
                this.addExtKeyUsage(extensionSet, ExtendedKeyUsageType.CODE_SIGNING.oid());
            }
            this.extensions = extensionSet;
            this.cancelled = false;
        }
        catch (IOException | CryptoException e) {
            DError.displayError(this, (Throwable)e);
        }
    }

    private void addAuthorityKeyIdentifier(X509ExtensionSet extensionSet) throws CryptoException, IOException {
        KeyIdentifierGenerator akiGenerator = new KeyIdentifierGenerator(this.authorityPublicKey);
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(akiGenerator.generate160BitHashId());
        byte[] akiEncoded = X509Ext.wrapInOctetString(aki.getEncoded());
        extensionSet.addExtension(X509ExtensionType.AUTHORITY_KEY_IDENTIFIER.oid(), false, akiEncoded);
    }

    private void addSubjectKeyIdentifier(X509ExtensionSet extensionSet) throws CryptoException, IOException {
        KeyIdentifierGenerator skiGenerator = new KeyIdentifierGenerator(this.subjectPublicKey);
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier(skiGenerator.generate160BitHashId());
        byte[] skiEncoded = X509Ext.wrapInOctetString(ski.getEncoded());
        extensionSet.addExtension(X509ExtensionType.SUBJECT_KEY_IDENTIFIER.oid(), false, skiEncoded);
    }

    private void addBasicConstraints(X509ExtensionSet extensionSet) throws IOException {
        BasicConstraints bc = new BasicConstraints(true);
        byte[] bcEncoded = X509Ext.wrapInOctetString(bc.getEncoded());
        extensionSet.addExtension(X509ExtensionType.BASIC_CONSTRAINTS.oid(), true, bcEncoded);
    }

    private void addKeyUsage(X509ExtensionSet extensionSet, int usage) throws IOException {
        KeyUsage ku = new KeyUsage(usage);
        byte[] kuEncoded = X509Ext.wrapInOctetString(ku.getEncoded());
        extensionSet.addExtension(X509ExtensionType.KEY_USAGE.oid(), true, kuEncoded);
    }

    private void addExtKeyUsage(X509ExtensionSet extensionSet, String ekuOid) throws IOException {
        ExtendedKeyUsage eku = new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(ekuOid))});
        byte[] ekuEncoded = X509Ext.wrapInOctetString(eku.getEncoded());
        extensionSet.addExtension(X509ExtensionType.EXTENDED_KEY_USAGE.oid(), false, ekuEncoded);
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        KeyPair issuerKP = KeyPairUtil.generateKeyPair(KeyPairType.RSA, 1024, (Provider)new BouncyCastleProvider());
        KeyPair subjectKP = KeyPairUtil.generateKeyPair(KeyPairType.RSA, 1024, (Provider)new BouncyCastleProvider());
        DSelectStandardExtensionTemplate dialog = new DSelectStandardExtensionTemplate(new JDialog(), issuerKP.getPublic(), subjectKP.getPublic());
        DialogViewer.run(dialog);
    }
}

