/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs.sign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.signing.MidletSigner;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.JavaFXFileChooser;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.io.FileNameUtil;
import org.kse.utilities.io.IOUtils;

public class DSignMidlet
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/dialogs/sign/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlInputJad;
    private JTextField jtfInputJad;
    private JButton jbInputJadBrowse;
    private JLabel jlSignDirectly;
    private JCheckBox jcbSignDirectly;
    private JLabel jlOutputJad;
    private JTextField jtfOutputJad;
    private JButton jbOutputJadBrowse;
    private JLabel jlJar;
    private JTextField jtfJar;
    private JButton jbJarBrowse;
    private JPanel jpOptions;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private File inputJadFile;
    private File outputJadFile;
    private File jarFile;

    public DSignMidlet(JFrame parent) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(res.getString("DSignMidlet.Title"));
        this.initComponents();
    }

    private void initComponents() {
        GridBagConstraints gbcLbl = new GridBagConstraints();
        gbcLbl.gridx = 0;
        gbcLbl.gridwidth = 1;
        gbcLbl.gridheight = 1;
        gbcLbl.insets = new Insets(5, 5, 5, 5);
        gbcLbl.anchor = 13;
        gbcLbl.weightx = 0.0;
        GridBagConstraints gbcCtrl = new GridBagConstraints();
        gbcCtrl.gridx = 1;
        gbcCtrl.gridwidth = 1;
        gbcCtrl.gridheight = 1;
        gbcCtrl.insets = new Insets(5, 5, 5, 5);
        gbcCtrl.anchor = 17;
        gbcCtrl.fill = 0;
        gbcCtrl.weightx = 1.0;
        GridBagConstraints gbcBrws = new GridBagConstraints();
        gbcBrws.gridx = 2;
        gbcBrws.gridwidth = 1;
        gbcBrws.gridheight = 1;
        gbcBrws.insets = new Insets(5, 5, 5, 5);
        gbcBrws.anchor = 17;
        gbcBrws.fill = 0;
        gbcBrws.weightx = 1.0;
        this.jlInputJad = new JLabel(res.getString("DSignMidlet.jlInputJad.text"));
        GridBagConstraints gbc_jlInputJad = (GridBagConstraints)gbcLbl.clone();
        gbc_jlInputJad.gridy = 0;
        this.jtfInputJad = new JTextField(30);
        this.jtfInputJad.setCaretPosition(0);
        this.jtfInputJad.setToolTipText(res.getString("DSignMidlet.jtfInputJad.tooltip"));
        GridBagConstraints gbc_jtfInputJad = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfInputJad.gridy = 0;
        this.jbInputJadBrowse = new JButton(res.getString("DSignMidlet.jbInputJadBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbInputJadBrowse, res.getString("DSignMidlet.jbInputJadBrowse.mnemonic").charAt(0));
        this.jbInputJadBrowse.setToolTipText(res.getString("DSignMidlet.jbInputJadBrowse.tooltip"));
        this.jbInputJadBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignMidlet.this);
                    DSignMidlet.this.inputJadBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignMidlet.this);
                }
            }
        });
        GridBagConstraints gbc_jbInputJadBrowse = (GridBagConstraints)gbcBrws.clone();
        gbc_jbInputJadBrowse.gridy = 0;
        this.jlSignDirectly = new JLabel(res.getString("DSignMidlet.jlSignDirectly.text"));
        GridBagConstraints gbc_jlSignDirectly = (GridBagConstraints)gbcLbl.clone();
        gbc_jlSignDirectly.gridy = 1;
        this.jcbSignDirectly = new JCheckBox();
        this.jcbSignDirectly.setSelected(true);
        this.jcbSignDirectly.setToolTipText(res.getString("DSignMidlet.jcbSignDirectly.tooltip"));
        GridBagConstraints gbc_jcbSignDirectly = (GridBagConstraints)gbcCtrl.clone();
        gbc_jcbSignDirectly.gridy = 1;
        this.jcbSignDirectly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DSignMidlet.this.jtfOutputJad.setEnabled(!DSignMidlet.this.jcbSignDirectly.isSelected());
                DSignMidlet.this.jbOutputJadBrowse.setEnabled(!DSignMidlet.this.jcbSignDirectly.isSelected());
            }
        });
        this.jlOutputJad = new JLabel(res.getString("DSignMidlet.jlOutputJad.text"));
        GridBagConstraints gbc_jlOutputJad = (GridBagConstraints)gbcLbl.clone();
        gbc_jlOutputJad.gridy = 2;
        this.jtfOutputJad = new JTextField(30);
        this.jtfOutputJad.setEnabled(false);
        this.jtfOutputJad.setCaretPosition(0);
        this.jtfOutputJad.setToolTipText(res.getString("DSignMidlet.jtfOutputJad.tooltip"));
        GridBagConstraints gbc_jtfOutputJad = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfOutputJad.gridy = 2;
        this.jbOutputJadBrowse = new JButton(res.getString("DSignMidlet.jbOutputJadBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbOutputJadBrowse, res.getString("DSignMidlet.jbOutputJadBrowse.mnemonic").charAt(0));
        this.jbOutputJadBrowse.setToolTipText(res.getString("DSignMidlet.jbOutputJadBrowse.tooltip"));
        this.jbOutputJadBrowse.setEnabled(false);
        this.jbOutputJadBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignMidlet.this);
                    DSignMidlet.this.outputJadBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignMidlet.this);
                }
            }
        });
        GridBagConstraints gbc_jbOutputJadBrowse = (GridBagConstraints)gbcBrws.clone();
        gbc_jbOutputJadBrowse.gridy = 2;
        this.jlJar = new JLabel(res.getString("DSignMidlet.jlJar.text"));
        GridBagConstraints gbc_jlJar = (GridBagConstraints)gbcLbl.clone();
        gbc_jlJar.gridy = 3;
        this.jtfJar = new JTextField(30);
        this.jtfJar.setCaretPosition(0);
        this.jtfJar.setToolTipText(res.getString("DSignMidlet.jtfJar.tooltip"));
        GridBagConstraints gbc_jtfJar = (GridBagConstraints)gbcCtrl.clone();
        gbc_jtfJar.gridy = 3;
        this.jbJarBrowse = new JButton(res.getString("DSignMidlet.jbJarBrowse.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbJarBrowse, res.getString("DSignMidlet.jbJarBrowse.mnemonic").charAt(0));
        this.jbJarBrowse.setToolTipText(res.getString("DSignMidlet.jbJarBrowse.tooltip"));
        this.jbJarBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSignMidlet.this);
                    DSignMidlet.this.jarBrowsePressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSignMidlet.this);
                }
            }
        });
        GridBagConstraints gbc_jbJarBrowse = (GridBagConstraints)gbcBrws.clone();
        gbc_jbJarBrowse.gridy = 3;
        this.jpOptions = new JPanel(new GridBagLayout());
        this.jpOptions.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        this.jpOptions.add((Component)this.jlInputJad, gbc_jlInputJad);
        this.jpOptions.add((Component)this.jtfInputJad, gbc_jtfInputJad);
        this.jpOptions.add((Component)this.jbInputJadBrowse, gbc_jbInputJadBrowse);
        this.jpOptions.add((Component)this.jlSignDirectly, gbc_jlSignDirectly);
        this.jpOptions.add((Component)this.jcbSignDirectly, gbc_jcbSignDirectly);
        this.jpOptions.add((Component)this.jlOutputJad, gbc_jlOutputJad);
        this.jpOptions.add((Component)this.jtfOutputJad, gbc_jtfOutputJad);
        this.jpOptions.add((Component)this.jbOutputJadBrowse, gbc_jbOutputJadBrowse);
        this.jpOptions.add((Component)this.jlJar, gbc_jlJar);
        this.jpOptions.add((Component)this.jtfJar, gbc_jtfJar);
        this.jpOptions.add((Component)this.jbJarBrowse, gbc_jbJarBrowse);
        this.jbOK = new JButton(res.getString("DSignMidlet.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignMidlet.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DSignMidlet.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignMidlet.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSignMidlet.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jpOptions, "North");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSignMidlet.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    public File getInputJad() {
        return this.inputJadFile;
    }

    public File getOutputJad() {
        return this.outputJadFile;
    }

    public File getJar() {
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void okPressed() {
        String message;
        int selected;
        File outputJadFile;
        String inputJad = this.jtfInputJad.getText().trim();
        if (inputJad.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignMidlet.InputJadRequired.message"), this.getTitle(), 2);
            return;
        }
        File inputJadFile = new File(inputJad);
        if (!inputJadFile.isFile()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DSignMidlet.InputJadNotFile.message"), inputJadFile), this.getTitle(), 2);
            return;
        }
        try {
            MidletSigner.readJadFile(inputJadFile);
        }
        catch (IOException ex) {
            String problemStr = MessageFormat.format(res.getString("DSignMidlet.NoOpenJad.Problem"), inputJadFile.getName());
            String[] causes = new String[]{res.getString("DSignMidlet.NotJad.Cause"), res.getString("DSignMidlet.CorruptedJad.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this, res.getString("DSignMidlet.ProblemOpeningJad.Title"), problem);
            dProblem.setLocationRelativeTo(this);
            dProblem.setVisible(true);
            return;
        }
        boolean signDirectly = this.jcbSignDirectly.isSelected();
        if (signDirectly) {
            outputJadFile = inputJadFile;
        } else {
            String outputJad = this.jtfOutputJad.getText().trim();
            if (outputJad.length() == 0) {
                JOptionPane.showMessageDialog(this, res.getString("DSignMidlet.OutputJadRequired.message"), this.getTitle(), 2);
                return;
            }
            outputJadFile = new File(outputJad);
        }
        String jar = this.jtfJar.getText().trim();
        if (jar.length() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("DSignMidlet.JarRequired.message"), this.getTitle(), 2);
            return;
        }
        File jarFile = new File(jar);
        if (!jarFile.isFile()) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DSignMidlet.JarNotFile.message"), jarFile), this.getTitle(), 2);
            return;
        }
        JarFile jarFileTest = null;
        try {
            jarFileTest = new JarFile(jarFile);
        }
        catch (IOException ex) {
            try {
                String problemStr = MessageFormat.format(res.getString("DSignMidlet.NoOpenJar.Problem"), jarFile.getName());
                String[] causes = new String[]{res.getString("DSignMidlet.NotJar.Cause"), res.getString("DSignMidlet.CorruptedJar.Cause")};
                Problem problem = new Problem(problemStr, causes, ex);
                DProblem dProblem = new DProblem(this, res.getString("DSignMidlet.ProblemOpeningJar.Title"), problem);
                dProblem.setLocationRelativeTo(this);
                dProblem.setVisible(true);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarFileTest);
                throw throwable;
            }
            IOUtils.closeQuietly(jarFileTest);
            return;
        }
        IOUtils.closeQuietly(jarFileTest);
        if (!signDirectly && outputJadFile.isFile() && (selected = JOptionPane.showConfirmDialog(this, message = MessageFormat.format(res.getString("DSignMidlet.OverWriteOutputJadFile.message"), outputJadFile), this.getTitle(), 0)) != 0) {
            return;
        }
        this.inputJadFile = inputJadFile;
        this.outputJadFile = outputJadFile;
        this.jarFile = jarFile;
        this.closeDialog();
    }

    private void inputJadBrowsePressed() {
        JFileChooser chooser = FileChooserFactory.getJadFileChooser();
        File currentFile = new File(this.jtfInputJad.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
            chooser.setSelectedFile(currentFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignMidlet.ChooseInputJad.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DSignMidlet.InputJadChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfInputJad.setText(chosenFile.toString());
            this.jtfInputJad.setCaretPosition(0);
            this.populateOutputJadFileName(chosenFile);
        }
    }

    private void populateOutputJadFileName(File chosenFile) {
        String fileBaseName = FileNameUtil.removeExtension(chosenFile.getName());
        if (fileBaseName != null) {
            String outFileName = fileBaseName + "_signed.jad";
            File outFile = new File(chosenFile.getParentFile(), outFileName);
            this.jtfOutputJad.setText(outFile.getPath());
        }
    }

    private void outputJadBrowsePressed() {
        int rtnValue;
        JFileChooser chooser = FileChooserFactory.getJadFileChooser();
        File currentFile = new File(this.jtfOutputJad.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
            chooser.setSelectedFile(currentFile);
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignMidlet.ChooseOutputJad.Title"));
        chooser.setMultiSelectionEnabled(false);
        int n = rtnValue = JavaFXFileChooser.isFxAvailable() ? chooser.showSaveDialog(this) : chooser.showDialog(this, res.getString("DSignMidlet.OutputJadChooser.button"));
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfOutputJad.setText(chosenFile.toString());
            this.jtfOutputJad.setCaretPosition(0);
        }
    }

    private void jarBrowsePressed() {
        JFileChooser chooser = FileChooserFactory.getArchiveFileChooser();
        File currentFile = new File(this.jtfJar.getText());
        if (currentFile.getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
        } else {
            chooser.setCurrentDirectory(CurrentDirectory.get());
        }
        chooser.setDialogTitle(res.getString("DSignMidlet.ChooseJar.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DSignMidlet.JarChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(chosenFile);
            this.jtfJar.setText(chosenFile.toString());
            this.jtfJar.setCaretPosition(0);
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

