/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnchooser;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kse.gui.dnchooser.RdnPanelList;

public class RdnPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<?> comboBox;
    private JLabel label;
    private JTextField textField;
    private JButton plus;
    private JButton minus;
    private RdnPanelList parent;

    public RdnPanel(JComboBox<?> comboBox, String selectedItem, String textFieldText, RdnPanelList list, boolean editable) {
        this.comboBox = comboBox;
        if (editable) {
            this.comboBox.setSelectedItem(selectedItem);
            this.comboBox.setEditable(false);
            this.add(this.comboBox);
        } else {
            this.label = new JLabel(selectedItem);
            this.add(this.label);
        }
        this.parent = list;
        this.textField = new JTextField(30);
        this.textField.setText(textFieldText);
        this.textField.setEditable(editable);
        this.add(this.textField);
        if (editable) {
            this.plus = new JButton(new AddEntryAction());
            this.add(this.plus);
            this.minus = new JButton(new RemoveEntryAction());
            this.add(this.minus);
        }
    }

    public JComboBox<?> getComboBox() {
        return this.comboBox;
    }

    public void enableAdd(boolean enabled) {
        if (this.plus != null) {
            this.plus.setEnabled(enabled);
        }
    }

    public void enableMinus(boolean enabled) {
        if (this.minus != null) {
            this.minus.setEnabled(enabled);
        }
    }

    public String getAttributeName() {
        return this.comboBox.getSelectedItem().toString();
    }

    public String getAttributeValue() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public class RemoveEntryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RemoveEntryAction() {
            super("-");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RdnPanel.this.parent.removeItem(RdnPanel.this);
        }
    }

    public class AddEntryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddEntryAction() {
            super("+");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RdnPanel.this.parent.cloneEntry(RdnPanel.this);
        }
    }
}

