/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.kse.gui.dnd.DragEntry;

public class KeyStoreEntryTransferable
implements Transferable {
    private DragEntry dragEntry;

    public KeyStoreEntryTransferable(DragEntry dragEntry) {
        this.dragEntry = dragEntry;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor == DataFlavor.javaFileListFlavor || dataFlavor == DataFlavor.stringFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor == DataFlavor.javaFileListFlavor) {
            String tempDir = System.getProperty("java.io.tmpdir");
            File tmpFile = new File(tempDir, this.dragEntry.getFileName());
            tmpFile.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                fos.write(this.dragEntry.getContent());
                fos.flush();
            }
            ArrayList<File> list = new ArrayList<File>();
            list.add(tmpFile);
            return list;
        }
        return this.dragEntry.getContentString();
    }
}

