/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.ErrorTreeCellRend;

public class DErrorDetail
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/error/resources");
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpError;
    private JTree jtrError;
    private JScrollPane jspError;
    private Throwable error;

    public DErrorDetail(JFrame parent, Dialog.ModalityType modality, Throwable error) {
        super((Window)parent, modality);
        this.error = error;
        this.initComponents();
    }

    public DErrorDetail(JDialog parent, Throwable error) {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.error = error;
        this.initComponents();
    }

    private void initComponents() {
        this.jbCopy = new JButton(res.getString("DErrorDetail.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DErrorDetail.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DErrorDetail.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DErrorDetail.this);
                    DErrorDetail.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DErrorDetail.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DErrorDetail.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DErrorDetail.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpError = new JPanel(new BorderLayout());
        this.jpError.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.jtrError = new JTree(this.createErrorNodes());
        this.jtrError.setRowHeight(Math.max(18, this.jtrError.getRowHeight()));
        this.jtrError.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.jtrError);
        this.jtrError.setCellRenderer(new ErrorTreeCellRend());
        TreeNode topNode = (TreeNode)this.jtrError.getModel().getRoot();
        this.expandTree(this.jtrError, new TreePath(topNode));
        this.jspError = PlatformUtil.createScrollPane(this.jtrError, 22, 32);
        this.jspError.setPreferredSize(new Dimension(500, 250));
        this.jpError.add((Component)this.jspError, "Center");
        this.getContentPane().add((Component)this.jpError, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setTitle(res.getString("DErrorDetail.Title"));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DErrorDetail.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DErrorDetail.this.jbOK.requestFocus();
            }
        });
    }

    private DefaultMutableTreeNode createErrorNodes() {
        DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(res.getString("DErrorDetail.RootNode.text"));
        for (Throwable createError = this.error; createError != null; createError = createError.getCause()) {
            DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(createError);
            topNode.add(errorNode);
            for (StackTraceElement stackTrace : createError.getStackTrace()) {
                errorNode.add(new DefaultMutableTreeNode(stackTrace));
            }
        }
        return topNode;
    }

    private void expandTree(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                TreeNode subNode = children.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                this.expandTree(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    private void copyPressed() {
        StringBuffer strBuff = new StringBuffer();
        Throwable copyError = this.error;
        while (copyError != null) {
            strBuff.append(copyError);
            strBuff.append('\n');
            for (StackTraceElement stackTrace : copyError.getStackTrace()) {
                strBuff.append("\tat ");
                strBuff.append(stackTrace);
                strBuff.append('\n');
            }
            if ((copyError = copyError.getCause()) == null) continue;
            strBuff.append('\n');
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(strBuff.toString());
        clipboard.setContents(copy, copy);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

