/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.password;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class JPasswordQualityField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/password/resources");
    private JPasswordField jpfPassword;
    private JPasswordQualityMeter jpqmQuality;
    private int minPasswordQuality = -1;
    private int passwordQuality = 0;

    public JPasswordQualityField(int columns) {
        this.initComponents(columns);
    }

    public JPasswordQualityField(int columns, int minPasswordQuality) throws IllegalArgumentException {
        if (minPasswordQuality < 0 || minPasswordQuality > 100) {
            throw new IllegalArgumentException(res.getString("MinimumPasswordQualityInvalid.message"));
        }
        this.minPasswordQuality = minPasswordQuality;
        this.initComponents(columns);
    }

    private void initComponents(int columns) {
        this.jpfPassword = new JPasswordField(columns);
        GridBagConstraints gbc_jpfPassword = new GridBagConstraints();
        gbc_jpfPassword.gridwidth = 1;
        gbc_jpfPassword.gridheight = 1;
        gbc_jpfPassword.gridx = 0;
        gbc_jpfPassword.gridy = 0;
        gbc_jpfPassword.insets = new Insets(0, 0, 1, 0);
        gbc_jpfPassword.fill = 2;
        this.jpqmQuality = this.getMinPasswordQuality() >= 0 ? new JPasswordQualityMeter(this.getMinPasswordQuality()) : new JPasswordQualityMeter();
        this.jpqmQuality.setPreferredSize(new Dimension(0, 6));
        this.initQualityBar();
        GridBagConstraints gbc_jpbQuality = new GridBagConstraints();
        gbc_jpbQuality.gridwidth = 1;
        gbc_jpbQuality.gridheight = 1;
        gbc_jpbQuality.gridx = 0;
        gbc_jpbQuality.gridy = 1;
        gbc_jpbQuality.insets = new Insets(0, 0, 0, 0);
        gbc_jpbQuality.fill = 2;
        this.jpfPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JPasswordQualityField.this.passwordChanged();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jpfPassword, gbc_jpfPassword);
        this.add((Component)this.jpqmQuality, gbc_jpbQuality);
    }

    public char[] getPassword() {
        if (this.getMinPasswordQuality() >= 0 && this.calculatePasswordQuality() < this.getMinPasswordQuality()) {
            return null;
        }
        return this.jpfPassword.getPassword();
    }

    public int getMinPasswordQuality() {
        return this.minPasswordQuality;
    }

    public int getPasswordQuality() {
        return this.passwordQuality;
    }

    public void setEchoChar(char c) {
        this.jpfPassword.setEchoChar(c);
    }

    public char getEchoChar() {
        return this.jpfPassword.getEchoChar();
    }

    public boolean echoCharIsSet() {
        return this.jpfPassword.echoCharIsSet();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jpfPassword.setEnabled(enabled);
        this.jpqmQuality.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.jpfPassword.isEnabled();
    }

    public void setText(String text) {
        this.jpfPassword.setText(text);
        this.passwordChanged();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.jpfPassword.setToolTipText(toolTipText);
    }

    @Override
    public void requestFocus() {
        this.jpfPassword.requestFocus();
    }

    private void passwordChanged() {
        this.passwordQuality = this.calculatePasswordQuality();
        this.jpqmQuality.setPasswordQuality(this.passwordQuality);
    }

    private void initQualityBar() {
        this.passwordChanged();
    }

    private int calculatePasswordQuality() {
        int quality;
        char[] password = this.jpfPassword.getPassword();
        int length = password.length;
        if (length > 6) {
            length = 6;
        }
        int digits = 0;
        int symbols = 0;
        boolean lower = false;
        boolean upper = false;
        for (char c : password) {
            if (Character.isDigit(c)) {
                ++digits;
            }
            if (!Character.isLetterOrDigit(c)) {
                ++symbols;
            }
            if (Character.isLowerCase(c)) {
                lower = true;
            }
            if (!Character.isUpperCase(c)) continue;
            upper = true;
        }
        if (digits > 0 && symbols == 0 && !lower && !upper) {
            return 0;
        }
        if (digits == 0 && symbols == 0 && lower && !upper) {
            return 0;
        }
        if (digits == 0 && symbols == 0 && !lower && upper) {
            return 0;
        }
        if (digits > 3) {
            digits = 3;
        }
        if (symbols > 3) {
            symbols = 3;
        }
        int lowerUpper = 0;
        if (lower && upper) {
            lowerUpper = 3;
        }
        if ((quality = length * 10 - 30 + digits * 10 + symbols * 15 + lowerUpper * 10) < 0) {
            quality = 0;
        } else if (quality > 100) {
            quality = 100;
        }
        return quality;
    }

    private class JPasswordQualityMeter
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Color BACKGROUND_COLOUR = Color.WHITE;
        private Color BORDER_COLOUR = Color.LIGHT_GRAY;
        private Color QUALITY_SATISIFIED_COLOUR = new Color(129, 180, 88);
        private Color QUALITY_NOT_SATISFIED_COLOUR = new Color(192, 72, 56);
        private int passwordQuality;
        private int minPasswordQuality;
        private Color barColour;

        public JPasswordQualityMeter() {
            this.minPasswordQuality = -1;
            this.passwordQuality = 0;
        }

        public JPasswordQualityMeter(int minPasswordQuality) {
            this.minPasswordQuality = minPasswordQuality;
            this.passwordQuality = 0;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle bounds = new Rectangle(this.getSize());
            bounds.x = 0;
            bounds.y = 0;
            g.setColor(this.BORDER_COLOUR);
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            g.setColor(this.BACKGROUND_COLOUR);
            g.fillRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            if (this.passwordQuality > 0) {
                float filled = (float)this.passwordQuality / 100.0f;
                g.setColor(this.barColour);
                g.fillRect(bounds.x + 1, bounds.y + 1, (int)((float)(bounds.width - 2) * filled), bounds.height - 2);
            }
        }

        public void setPasswordQuality(int passwordQuality) {
            this.passwordQuality = passwordQuality;
            if (this.minPasswordQuality >= 0) {
                this.barColour = passwordQuality < this.minPasswordQuality ? this.QUALITY_NOT_SATISFIED_COLOUR : this.QUALITY_SATISIFIED_COLOUR;
                JPasswordQualityField.this.jpqmQuality.setToolTipText(MessageFormat.format(res.getString("JPasswordQualityField.jpbQuality.Min.tooltip"), passwordQuality, this.minPasswordQuality));
            } else {
                this.barColour = this.QUALITY_SATISIFIED_COLOUR;
                JPasswordQualityField.this.jpqmQuality.setToolTipText(MessageFormat.format(res.getString("JPasswordQualityField.jpbQuality.NoMin.tooltip"), passwordQuality));
            }
            this.repaint();
        }
    }
}

