/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.ticker;

import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.kse.gui.ticker.JTicker;
import org.kse.gui.ticker.TickerRenderer;

public class ClickableLinkTickerRenderer
extends JLabel
implements TickerRenderer {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN_LINK = Pattern.compile("<a href=['\"]([^']*?)['\"][^>]*?>.*?</a>");
    private static final Pattern PATTERN_TAG = Pattern.compile("<[^>]*?>");
    private List<LinkDescriptor> listLinks;

    @Override
    public JComponent getTickerRendererComponent(JTicker ticker, Object value) {
        String text = value.toString();
        this.setText("<html>" + text + "</html>");
        this.determineLinks(this.getText());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String link = ClickableLinkTickerRenderer.this.getLink(e.getPoint());
                if (link == null) {
                    return;
                }
                try {
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Could not open link", "Error", 0);
                }
            }
        });
        return this;
    }

    protected String getLink(Point p) {
        AccessibleContext aC = this.getAccessibleContext();
        if (aC instanceof JLabel.AccessibleJLabel) {
            JLabel.AccessibleJLabel aL = (JLabel.AccessibleJLabel)aC;
            AccessibleText aT = aL.getAccessibleText();
            if (aT == null) {
                return null;
            }
            int index = aL.getIndexAtPoint(p);
            for (LinkDescriptor entry : this.listLinks) {
                if (index < entry.getStart() || index > entry.getEnd()) continue;
                return entry.getUrl();
            }
        }
        return null;
    }

    public void determineLinks(String text) {
        if (this.listLinks == null) {
            this.listLinks = new ArrayList<LinkDescriptor>();
        } else {
            this.listLinks.clear();
        }
        Matcher mLink = PATTERN_LINK.matcher(text);
        ArrayList<LinkDescriptor> lLinks = new ArrayList<LinkDescriptor>();
        while (mLink.find()) {
            lLinks.add(new LinkDescriptor(mLink.start(), mLink.end(), mLink.group(1)));
        }
        if (lLinks.isEmpty()) {
            return;
        }
        Matcher mTag = PATTERN_TAG.matcher(text);
        ArrayList<Integer[]> lTags = new ArrayList<Integer[]>();
        while (mTag.find()) {
            lTags.add(new Integer[]{mTag.start(), mTag.end(), 0});
        }
        StringBuilder rawText = new StringBuilder(text.substring(0, ((Integer[])lTags.get(0))[0]));
        ((Integer[])lTags.get((int)0))[2] = rawText.length();
        for (int i = 1; i < lTags.size(); ++i) {
            rawText.append(text.substring(((Integer[])lTags.get(i - 1))[1], ((Integer[])lTags.get(i))[0]));
            ((Integer[])lTags.get((int)i))[2] = rawText.length();
        }
        LinkDescriptor entry = new LinkDescriptor();
        for (LinkDescriptor link : lLinks) {
            for (Integer[] tag : lTags) {
                if (tag[0].equals(link.getStart())) {
                    entry.setStart(tag[2]);
                    continue;
                }
                if (!tag[1].equals(link.getEnd())) continue;
                entry.setEnd(tag[2]);
                entry.setUrl(link.getUrl());
                this.listLinks.add(entry);
                entry = new LinkDescriptor();
            }
        }
    }

    private final class LinkDescriptor {
        private int start;
        private int end;
        private String url;

        public LinkDescriptor() {
        }

        public LinkDescriptor(int start, int stop, String url) {
            this.start = start;
            this.end = stop;
            this.url = url;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int stop) {
            this.end = stop;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String toString() {
            return "LinkDescriptor [start=" + this.start + ", end=" + this.end + ", url=" + this.url + "]";
        }
    }
}

