/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.util.encoders.Hex;

public class HexUtil {
    private static final String NEWLINE = "\n";

    private HexUtil() {
    }

    public static String getHexString(BigInteger bigInt) {
        int i;
        String hex = bigInt.toString(16).toUpperCase();
        int padding = 4 - hex.length() % 4;
        if (padding > 0 && padding < 4) {
            StringBuilder sb = new StringBuilder(hex);
            for (i = 0; i < padding; ++i) {
                sb.insert(0, '0');
            }
            hex = sb.toString();
        }
        StringBuilder strBuff = new StringBuilder();
        strBuff.append("0x");
        for (i = 0; i < hex.length(); ++i) {
            strBuff.append(hex.charAt(i));
            if ((i + 1) % 4 != 0 || i + 1 == hex.length()) continue;
            strBuff.append(' ');
        }
        return strBuff.toString();
    }

    public static String getHexStringWithSep(byte[] data, char separator) {
        StringBuilder strBuff = new StringBuilder(Hex.toHexString((byte[])data).toUpperCase());
        if (strBuff.length() % 2 == 1) {
            strBuff.insert(0, '0');
        }
        if (strBuff.length() > 2) {
            for (int i = 2; i < strBuff.length(); i += 3) {
                strBuff.insert(i, separator);
            }
        }
        return strBuff.toString();
    }

    public static String getHexString(byte[] bytes) {
        return HexUtil.getHexString(new BigInteger(1, bytes));
    }

    public static String getHexClearDump(byte[] bytes) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            StringBuilder sb = new StringBuilder();
            byte[] line = new byte[8];
            int read = -1;
            boolean firstLine = true;
            while ((read = bais.read(line)) != -1) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append(NEWLINE);
                }
                sb.append(HexUtil.getHexClearLineDump(line, read));
            }
            String string = sb.toString();
            return string;
        }
    }

    private static String getHexClearLineDump(byte[] bytes, int len) {
        StringBuilder sbHex = new StringBuilder();
        StringBuilder sbClr = new StringBuilder();
        for (int cnt = 0; cnt < len; ++cnt) {
            byte b = bytes[cnt];
            int i = b & 0xFF;
            int i1 = (int)Math.floor((double)i / 16.0);
            int i2 = i % 16;
            sbHex.append(Character.toUpperCase(Character.forDigit(i1, 16)));
            sbHex.append(Character.toUpperCase(Character.forDigit(i2, 16)));
            if (cnt + 1 < len) {
                sbHex.append(' ');
            }
            char c = '.';
            if (!Character.isISOControl((char)i) && Character.isDefined((char)i)) {
                Character clr = Character.valueOf((char)i);
                c = clr.charValue();
            }
            sbClr.append(c);
        }
        StringBuilder strBuff = new StringBuilder();
        strBuff.append(sbHex.toString());
        int i = bytes.length - len;
        for (int cnt = 0; cnt < i; ++cnt) {
            strBuff.append("   ");
        }
        strBuff.append("   ");
        strBuff.append(sbClr.toString());
        return strBuff.toString();
    }
}

