/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.pem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.bouncycastle.util.encoders.Base64;
import org.kse.utilities.pem.PemAttribute;
import org.kse.utilities.pem.PemAttributes;
import org.kse.utilities.pem.PemInfo;

public class PemUtil {
    private static final int MAX_PRINTABLE_ENCODING_LINE_LENGTH = 64;
    private static final String OPENSSL_EC_PARAMS_PEM_TYPE = "EC PARAMETERS";

    private PemUtil() {
    }

    public static String encode(PemInfo pemInfo) {
        StringBuilder sbPem = new StringBuilder();
        sbPem.append("-----BEGIN ");
        sbPem.append(pemInfo.getType());
        sbPem.append("-----");
        sbPem.append("\n");
        PemAttributes attributes = pemInfo.getAttributes();
        if (attributes != null && attributes.size() > 0) {
            for (PemAttribute attribute : attributes.values()) {
                sbPem.append(attribute);
                sbPem.append('\n');
            }
            sbPem.append('\n');
        }
        String base64 = new String(Base64.encode((byte[])pemInfo.getContent()));
        for (int i = 0; i < base64.length(); i += 64) {
            int lineLength = i + 64 > base64.length() ? base64.length() - i : 64;
            sbPem.append(base64.substring(i, i + lineLength));
            sbPem.append("\n");
        }
        sbPem.append("-----END ");
        sbPem.append(pemInfo.getType());
        sbPem.append("-----");
        sbPem.append("\n");
        return sbPem.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PemInfo decode(byte[] pemData) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pemData);
             InputStreamReader inputStreamReader = new InputStreamReader(byteArrayInputStream);
             LineNumberReader lnr = new LineNumberReader(inputStreamReader);){
            String footerType;
            String attributeName;
            PemAttributes attributes;
            String headerType;
            StringBuilder sbBase64;
            block70: {
                String line = PemUtil.skipOverEcParams(lnr);
                sbBase64 = new StringBuilder();
                if (line == null) return null;
                headerType = PemUtil.getTypeFromHeader(line = line.trim());
                if (headerType == null) return null;
                line = lnr.readLine();
                attributes = null;
                if (line != null && line.contains(": ")) {
                    line = line.trim();
                    attributes = new PemAttributes();
                    while (line != null) {
                        if ((line = line.trim()).equals("")) {
                            line = lnr.readLine();
                            break;
                        }
                        if (!line.contains(": ")) {
                            PemInfo pemInfo = null;
                            return pemInfo;
                        }
                        int separator = line.indexOf(58);
                        attributeName = line.substring(0, separator);
                        String attributeValue = line.substring(separator + 2);
                        attributes.add(new PemAttribute(attributeName, attributeValue));
                        line = lnr.readLine();
                    }
                }
                while (line != null) {
                    footerType = PemUtil.getTypeFromFooter(line = line.trim());
                    if (footerType == null) {
                        sbBase64.append(line);
                        line = lnr.readLine();
                        continue;
                    }
                    break block70;
                }
                return null;
            }
            if (!headerType.equals(footerType)) {
                attributeName = null;
                return attributeName;
            }
            byte[] content = Base64.decode((String)sbBase64.toString());
            PemInfo pemInfo = new PemInfo(headerType, attributes, content);
            return pemInfo;
        }
    }

    private static String skipOverEcParams(LineNumberReader lnr) throws IOException {
        String line = lnr.readLine();
        if (line != null && OPENSSL_EC_PARAMS_PEM_TYPE.equals(PemUtil.getTypeFromHeader(line.trim()))) {
            while ((line = lnr.readLine()) != null) {
                if (!OPENSSL_EC_PARAMS_PEM_TYPE.equals(PemUtil.getTypeFromFooter(line = line.trim()))) continue;
                line = lnr.readLine();
                break;
            }
        }
        return line;
    }

    private static String getTypeFromHeader(String header) {
        String type = null;
        if (header.startsWith("-----BEGIN ") && header.endsWith("-----")) {
            type = header.substring(11, header.length() - 5);
        }
        return type;
    }

    private static String getTypeFromFooter(String footer) {
        String type = null;
        if (footer.startsWith("-----END ") && footer.endsWith("-----")) {
            type = footer.substring(9, footer.length() - 5);
        }
        return type;
    }
}

