/*
 * Decompiled with CFR 0.152.
 */
package org.kse.utilities.ssl;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.kse.crypto.CryptoException;
import org.kse.utilities.ssl.CustomSslSocketFactory;
import org.kse.utilities.ssl.RetrieveSslInfosHandshakeListener;
import org.kse.utilities.ssl.SslConnectionInfos;

public class SslUtils {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/utilities/ssl/resources");

    private SslUtils() {
    }

    public static SslConnectionInfos readSSLConnectionInfos(String host, int port, KeyStore keyStore, char[] password) throws CryptoException, IOException {
        URL url = new URL(MessageFormat.format("https://{0}:{1}/", host, "" + port));
        HttpsURLConnection connection = null;
        System.setProperty("javax.net.debug", "ssl");
        try {
            connection = (HttpsURLConnection)url.openConnection();
            X509KeyManager km = null;
            if (keyStore != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
                keyManagerFactory.init(keyStore, password);
                for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
                    if (!(keyManager instanceof X509KeyManager)) continue;
                    km = (X509KeyManager)keyManager;
                    break;
                }
            }
            SSLContext context = SSLContext.getInstance("TLS");
            X509TrustingManager tm = new X509TrustingManager();
            context.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
            connection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return true;
                }
            });
            SSLSocketFactory factory = context.getSocketFactory();
            RetrieveSslInfosHandshakeListener handshakeListener = new RetrieveSslInfosHandshakeListener();
            boolean sniEnabled = true;
            connection.setSSLSocketFactory(new CustomSslSocketFactory(factory, handshakeListener, sniEnabled));
            try {
                connection.connect();
            }
            catch (SSLProtocolException e) {
                if (e.getMessage().contains("unrecognized_name")) {
                    sniEnabled = false;
                    connection.setSSLSocketFactory(new CustomSslSocketFactory(factory, handshakeListener, sniEnabled));
                    connection.connect();
                }
                throw e;
            }
            if (keyStore != null) {
                connection.getResponseMessage();
            }
            SslConnectionInfos sslConnectionInfos = handshakeListener.getSslConnectionInfos();
            sslConnectionInfos.setSniEnabled(sniEnabled);
            SslConnectionInfos sslConnectionInfos2 = sslConnectionInfos;
            return sslConnectionInfos2;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoLoadCertificate.exception.message"), ex);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static class X509TrustingManager
    implements X509TrustManager {
        private X509TrustingManager() {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

