/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.jrs.JRSUIState;
import org.violetlib.vappearances.VAppearance;

public class JRSPixelsKey
implements ImageCache.PixelsKey {
    private final int pixelCount;
    private final int hash;
    private final int scaleFactor;
    private final int w;
    private final int h;
    @NotNull
    private final JRSUIState state;
    @NotNull
    private final VAppearance appearance;

    public JRSPixelsKey(int n, int n2, int n3, @NotNull JRSUIState jRSUIState, @NotNull VAppearance vAppearance) {
        this.pixelCount = n2 * n3;
        this.scaleFactor = n;
        this.w = n2;
        this.h = n3;
        this.state = jRSUIState;
        this.appearance = vAppearance;
        this.hash = this.hash();
    }

    @Override
    public int getPixelCount() {
        return this.pixelCount;
    }

    private int hash() {
        int n = this.scaleFactor;
        n = 31 * n + this.w;
        n = 31 * n + this.h;
        n = 31 * n + this.state.hashCode();
        n = 31 * n + this.appearance.hashCode();
        return n;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof JRSPixelsKey) {
            JRSPixelsKey jRSPixelsKey = (JRSPixelsKey)object;
            return this.scaleFactor == jRSPixelsKey.scaleFactor && this.w == jRSPixelsKey.w && this.h == jRSPixelsKey.h && this.state.equals(jRSPixelsKey.state) && this.appearance.equals(jRSPixelsKey.appearance);
        }
        return false;
    }
}

