/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.vappearances.VAppearance;

public class Colors {
    @NotNull
    private static final Colors lightColors;
    @NotNull
    private static final Colors darkColors;
    @NotNull
    private static final Colors highContrastLightColors;
    @NotNull
    private static final Colors highContrastDarkColors;
    @NotNull
    private final Map<String, Color> colors;
    private final Color DARK_THUMB = new Color(0, 0, 0, 128);
    private final Color DARK_TRACK = new Color(250, 250, 250, 191);
    private final Color DARK_TRACK_BORDER = new Color(220, 220, 220, 200);

    @NotNull
    public static Colors getColors(@Nullable VAppearance vAppearance) {
        if (vAppearance != null) {
            if (vAppearance.isDark()) {
                if (vAppearance.isHighContrast()) {
                    return highContrastDarkColors;
                }
                return darkColors;
            }
            if (vAppearance.isHighContrast()) {
                return highContrastLightColors;
            }
            return lightColors;
        }
        return lightColors;
    }

    @NotNull
    public static Colors getColors(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? highContrastDarkColors : darkColors;
        }
        return bl2 ? highContrastLightColors : lightColors;
    }

    Colors(@NotNull Map<String, Color> map) {
        this.colors = Collections.unmodifiableMap(map);
    }

    @NotNull
    public Color get(@NotNull String string) {
        Color color = this.colors.get(string);
        if (color == null) {
            throw new UnsupportedOperationException("Missing color: " + string);
        }
        return color;
    }

    @Nullable
    public Color getOptional(@NotNull String string) {
        return this.colors.get(string);
    }

    @NotNull
    public Map<String, Color> getColors() {
        return this.colors;
    }

    static {
        Builder builder = new Builder();
        builder.add("overlayScrollTrack", 249, 185);
        builder.add("overlayScrollTrackBorder", 194, 85);
        builder.add("overlayThumb", 20, 140);
        builder.add("overlayThumb_rollover", 62, 170);
        builder.add("legacyScrollBarThumb", 0, 58);
        builder.add("legacyScrollBarThumb_rollover", 0, 128);
        builder.add("legacyScrollBarTrack", 250);
        builder.add("legacyScrollBarInnerBorder", 231);
        builder.add("legacyScrollBarOuterBorder", 237);
        builder.add("comboBoxArrow", 0, 176);
        builder.add("titleBarCloseButton", 255, 95, 87);
        builder.add("titleBarMinimizeButton", 255, 192, 47);
        builder.add("titleBarResizeButton", 41, 204, 66);
        builder.add("searchFieldIcon", 0, 155);
        builder.add("searchFieldIcon_inactive", 0, 72);
        builder.add("linearSliderTick", 10, 110);
        builder.add("circularSliderInterior", 255);
        builder.add("circularSliderBorder", 32, 48);
        builder.add("circularSliderDimple", 75);
        builder.add("circularSliderDimpleTop", 105);
        builder.add("circularSliderTick", 10, 110);
        builder.add("thickDividerDimple", 220);
        builder.add("thickDividerDimpleBorder", 191);
        builder.add("tableHeaderDivider", 0, 24);
        builder.add("tableHeaderArrow", 0, 92);
        lightColors = builder.getColors();
        builder = new Builder();
        builder.addAll(lightColors);
        builder.add("overlayScrollTrack", 249);
        builder.add("overlayScrollTrackBorder", 202);
        builder.add("overlayThumb", 0, 184);
        builder.add("overlayThumb_rollover", 87);
        builder.add("legacyScrollBarThumb", 0, 108);
        builder.add("legacyScrollBarThumb_rollover", 0, 164);
        builder.add("legacyScrollBarInnerBorder", 195);
        builder.add("legacyScrollBarOuterBorder", 200);
        builder.add("titleBarCloseButton", 255, 45, 64);
        builder.add("titleBarMinimizeButton", 246, 177, 1);
        builder.add("titleBarResizeButton", 5, 161, 27);
        builder.add("searchFieldIcon", 0, 177);
        builder.add("searchFieldIcon_inactive", 0, 100);
        builder.add("circularSliderBorder", 12, 180);
        builder.add("tableHeaderDivider", 0, 48);
        builder.add("tableHeaderArrow", 0, 140);
        highContrastLightColors = builder.getColors();
        builder = new Builder();
        builder.add("overlayScrollTrack", 255, 32);
        builder.add("overlayScrollTrackBorder", 149, 28);
        builder.add("overlayThumb", 255, 128);
        builder.add("overlayThumb_rollover", 237, 140);
        builder.add("overlayThumbBorder", 0, 26);
        builder.add("overlayThumbBorder_rollover", 59, 217);
        builder.add("legacyScrollBarThumb", 255, 78);
        builder.add("legacyScrollBarThumb_rollover", 255, 128);
        builder.add("legacyScrollBarTrack", 255, 16);
        builder.add("legacyScrollBarInnerBorder", 255, 24);
        builder.add("comboBoxArrow", 255, 164);
        builder.add("titleBarCloseButton", 255, 90, 82);
        builder.add("titleBarMinimizeButton", 230, 192, 41);
        builder.add("titleBarResizeButton", 84, 194, 43);
        builder.add("searchFieldIcon", 255, 213);
        builder.add("searchFieldIcon_inactive", 255, 58);
        builder.add("linearSliderTick", 255, 64);
        builder.add("circularSliderInterior", 255, 64);
        builder.add("circularSliderBorder", 32, 48);
        builder.add("circularSliderDimple", 255, 218);
        builder.add("circularSliderTick", 255, 64);
        builder.add("thickDividerDimple", 255, 32);
        builder.add("thickDividerDimpleBorder", 0, 48);
        builder.add("tableHeaderDivider", 255, 24);
        builder.add("tableHeaderArrow", 255, 102);
        darkColors = builder.getColors();
        builder = new Builder();
        builder.addAll(darkColors);
        builder.add("overlayScrollTrack", 255, 16);
        builder.add("overlayScrollTrackBorder", 114);
        builder.add("overlayThumb", 255, 180);
        builder.add("overlayThumb_rollover", 199);
        builder.add("legacyScrollBarThumb", 255, 180);
        builder.add("legacyScrollBarThumb_rollover", 255, 255);
        builder.add("legacyScrollBarTrack", 255, 44);
        builder.add("legacyScrollBarInnerBorder", 255, 22);
        builder.add("legacyScrollBarOuterBorder", 255, 12);
        builder.add("searchFieldIcon", 255, 237);
        builder.add("searchFieldIcon_inactive", 255, 143);
        builder.add("circularSliderBorder", 255, 160);
        builder.add("circularSliderDimple", 255);
        builder.add("tableHeaderDivider", 255, 76);
        builder.add("tableHeaderArrow", 255, 128);
        highContrastDarkColors = builder.getColors();
    }

    static class Builder {
        @NotNull
        private final Map<String, Color> colors = new HashMap<String, Color>();

        Builder() {
        }

        public void add(@NotNull String string, int n) {
            Color color = new Color(n, n, n);
            this.internalAdd(string, color);
        }

        public void add(@NotNull String string, int n, int n2, int n3) {
            Color color = new Color(n, n2, n3);
            this.internalAdd(string, color);
        }

        public void add(@NotNull String string, int n, int n2, int n3, int n4) {
            Color color = new Color(n, n2, n3, n4);
            this.internalAdd(string, color);
        }

        public void add(@NotNull String string, int n, int n2) {
            Color color = new Color(n, n, n, n2);
            this.internalAdd(string, color);
        }

        public void add(@NotNull String string, @NotNull Color color) {
            this.internalAdd(string, color);
        }

        public void add(@NotNull String string, @NotNull String string2) {
            Color color = this.colors.get(string2);
            if (color == null) {
                throw new UnsupportedOperationException("Missing color: " + string2);
            }
            this.internalAdd(string, color);
        }

        public void addAll(@NotNull Colors colors) {
            Map<String, Color> map = colors.getColors();
            for (String string : map.keySet()) {
                Color color = map.get(string);
                this.internalAdd(string, color);
            }
        }

        private void internalAdd(@NotNull String string, @NotNull Color color) {
            this.colors.put(string, color);
        }

        @NotNull
        public Colors getColors() {
            return new Colors(this.colors);
        }
    }
}

