/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.AbstractButton;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.treetable.AbstractTreeModel;
import org.violetlib.treetable.DefaultTreeColumnModel;
import org.violetlib.treetable.DefaultTreeTableNode;
import org.violetlib.treetable.DefaultTreeTableSorter;
import org.violetlib.treetable.IconMap;
import org.violetlib.treetable.ToolTipMap;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.TreeTableCellEditor;
import org.violetlib.treetable.TreeTableCellRenderer;
import org.violetlib.treetable.TreeTableModel;
import org.violetlib.treetable.TreeTableNode;
import org.violetlib.treetable.TreeTableSorter;
import org.violetlib.treetable.event.TreeColumnModelEvent;
import org.violetlib.treetable.event.TreeColumnModelListener;
import org.violetlib.treetable.event.TreeTableMouseEvent;
import org.violetlib.treetable.event.TreeTableMouseListener;
import org.violetlib.treetable.event.TreeTableMouseMotionListener;
import org.violetlib.treetable.event.TreeTableSorterEvent;
import org.violetlib.treetable.event.TreeTableSorterListener;
import org.violetlib.treetable.ui.BasicTreeTableUI;
import org.violetlib.treetable.ui.TableInterface;
import org.violetlib.treetable.ui.TreeInterface;
import org.violetlib.treetable.ui.TreeTableUI;

public class TreeTable
extends JComponent
implements Scrollable {
    protected Adapter adapter;
    private TreeInterface tree;
    private TableInterface table;
    private TableColumnModel columnModel;
    private JTable rowHeader;
    private TreeTableCellRenderer focusRenderer;
    private Color alternateRowColor;
    private IconMap iconMap;
    private ToolTipMap<TreeTable> toolTipMap;
    private Icon openIcon;
    private Icon closedIcon;
    private Icon leafIcon;
    private Icon ascendingSortIcon;
    private Icon descendingSortIcon;
    private HashMap<Class<?>, TreeTableCellRenderer> defaultRenderers;
    private HashMap<Class<?>, TreeTableCellEditor> defaultEditors;
    private HashMap<TreePath, RowSorter.SortKey> sortedPaths = new HashMap();
    private int rowMargin = 0;
    private boolean expandsSortedNodes = true;
    private boolean nodeSortingEnabled = true;
    private boolean columnFocusEnabled = true;
    private boolean autoCreateColumnHeader = true;
    private boolean autoCreateRowHeader = false;
    private boolean autoCreateRowSorter = false;
    private static final String uiClassID = "TreeTableUI";
    private boolean hasTreeTableMouseListener = false;
    private boolean hasTreeTableMouseMotionListener = false;
    private boolean dragEnabled;
    private boolean dropModeSet = false;
    private transient DropLocation dropLocation;
    private transient DTDE dtde;

    public TreeTable() {
        this(new DefaultTreeTableNode());
    }

    public TreeTable(TreeTableNode treeTableNode) {
        this(new DefaultTreeModel(treeTableNode), new DefaultTreeColumnModel(treeTableNode));
    }

    public TreeTable(TreeModel treeModel, TreeColumnModel treeColumnModel) {
        this(treeModel, treeColumnModel, null);
    }

    public TreeTable(TreeModel treeModel, TreeColumnModel treeColumnModel, TableColumnModel tableColumnModel) {
        if (treeModel == null || treeColumnModel == null) {
            throw new NullPointerException();
        }
        this.adapter = this.createAdapter(treeModel, treeColumnModel);
        this.columnModel = tableColumnModel;
        this.toolTipMap = this.getDefaultToolTipMap();
        this.setFocusable(true);
        this.setOpaque(true);
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setUI(TreeTableUI treeTableUI) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.table != null) {
            this.table.removePropertyChangeListener(this.adapter);
            this.tree.removePropertyChangeListener(this.adapter);
            int n = this.listenerList.getListenerCount(TreeExpansionListener.class);
            if (n > 0) {
                this.tree.removeTreeExpansionListener(this.adapter);
                bl = true;
            }
            if ((n = this.listenerList.getListenerCount(TreeWillExpandListener.class)) > 0) {
                this.tree.removeTreeWillExpandListener(this.adapter);
                bl2 = true;
            }
            this.getSelectionModel().removeTreeSelectionListener(this.adapter);
            if (this.getAutoCreateColumnsFromModel()) {
                this.columnModel = null;
            }
            this.updateUIProperties();
        }
        super.setUI(treeTableUI);
        this.tree = this.getUI().getTreeInterface(this);
        this.table = this.getUI().getTableInterface(this);
        this.getSelectionModel().addTreeSelectionListener(this.adapter);
        this.table.addPropertyChangeListener(this.adapter);
        this.tree.addPropertyChangeListener(this.adapter);
        if (bl) {
            this.tree.addTreeExpansionListener(this.adapter);
        }
        if (bl2) {
            this.tree.addTreeWillExpandListener(this.adapter);
        }
        if (this.getAutoCreateColumnHeader() && this.isDisplayable()) {
            this.configureEnclosingScrollPane();
        }
    }

    @Override
    public TreeTableUI getUI() {
        return (TreeTableUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else if (this.ui != null && this.ui.getClass() == BasicTreeTableUI.class) {
            this.updateUIProperties();
            ((BasicTreeTableUI)this.ui).updateUI();
        } else {
            this.setUI(new BasicTreeTableUI());
        }
    }

    protected void updateUIProperties() {
        if (this.leafIcon instanceof UIResource) {
            this.leafIcon = null;
        }
        if (this.openIcon instanceof UIResource) {
            this.openIcon = null;
        }
        if (this.closedIcon instanceof UIResource) {
            this.closedIcon = null;
        }
        if (this.ascendingSortIcon instanceof UIResource) {
            this.ascendingSortIcon = null;
        }
        if (this.descendingSortIcon instanceof UIResource) {
            this.descendingSortIcon = null;
        }
        this.updateUIRenderers();
        this.updateUIEditors();
    }

    private void updateUIRenderers() {
        if (this.defaultRenderers == null && this.columnModel == null) {
            return;
        }
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (this.defaultRenderers != null) {
            for (Map.Entry<Class<Object>, TreeTableCellRenderer> object : this.defaultRenderers.entrySet()) {
                if (object.getValue() instanceof JComponent) {
                    identityHashMap.put(object.getValue(), null);
                    continue;
                }
                if (object.getValue() instanceof Component) continue;
                Class<Object> clazz = object.getKey();
                TreeColumnModel treeColumnModel = this.adapter.treeColumnModel;
                int n = treeColumnModel.getColumnCount();
                while (--n >= 0) {
                    if (!clazz.isAssignableFrom(treeColumnModel.getColumnClass(n))) continue;
                    this.addComponents(identityHashMap, object.getValue(), this.convertColumnIndexToView(n));
                }
            }
        }
        if (this.columnModel != null) {
            int n = this.columnModel.getColumnCount();
            while (--n >= 0) {
                TableCellRenderer tableCellRenderer = this.columnModel.getColumn(n).getCellRenderer();
                if (tableCellRenderer instanceof JComponent) {
                    identityHashMap.put(tableCellRenderer, null);
                    continue;
                }
                if (tableCellRenderer instanceof Component || !(tableCellRenderer instanceof TreeTableCellRenderer)) continue;
                this.addComponents(identityHashMap, (TreeTableCellRenderer)((Object)tableCellRenderer), n);
            }
        }
        for (JComponent jComponent : identityHashMap.keySet()) {
            jComponent.updateUI();
        }
    }

    private void addComponents(IdentityHashMap identityHashMap, TreeTableCellRenderer treeTableCellRenderer, int n) {
        try {
            Object object;
            int n2;
            if (this.getRowCount() == 0) {
                n2 = -1;
                object = null;
            } else {
                n2 = 0;
                object = this.adapter.getValueAt(0, n);
            }
            if (n == this.adapter.treeColumnModel.getHierarchicalColumn()) {
                Component component;
                if (n2 < 0) {
                    component = treeTableCellRenderer.getTreeTableCellRendererComponent(this, object, false, false, n2, n, false, true);
                } else {
                    TreePath treePath = this.getPathForRow(0);
                    component = treeTableCellRenderer.getTreeTableCellRendererComponent(this, object, false, false, n2, n, this.isExpanded(treePath), this.isLeaf(treePath));
                }
                if (component instanceof JComponent) {
                    identityHashMap.put(component, component);
                }
            } else {
                Component component = treeTableCellRenderer.getTreeTableCellRendererComponent(this, object, false, false, n2, n);
                if (component instanceof JComponent) {
                    identityHashMap.put(component, component);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateUIEditors() {
    }

    public void processTreeExpansion(TreePath treePath, int n) {
        int n2 = this.getRowForPath(treePath);
        this.adapter.fireTableRowsInserted(n2 + 1, n2 + n);
        this.adapter.updateSorter(treePath, true);
        if (this.getRowHeight() <= 0) {
            this.updateTableRowHeights(n2 + 1, n2 + n + 1);
        }
    }

    public void processTreeCollapse(TreePath treePath, int n) {
        int n2 = this.getRowForPath(treePath);
        this.adapter.fireTableRowsDeleted(n2 + 1, n2 + n);
        this.adapter.updateSorter(treePath, false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private JScrollPane getScrollPaneAncestor() {
        return AquaUtils.getScrollPaneAncestor(this);
    }

    protected void configureEnclosingScrollPane() {
        if (!this.getAutoCreateColumnHeader() && !this.getAutoCreateRowHeader()) {
            return;
        }
        JScrollPane jScrollPane = this.getScrollPaneAncestor();
        if (jScrollPane == null) {
            return;
        }
        if (this.getAutoCreateColumnHeader()) {
            Border border;
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            Border border2 = jScrollPane.getBorder();
            if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                jScrollPane.setBorder(border);
            }
        }
        if (this.getAutoCreateRowHeader()) {
            this.createRowHeader();
            jScrollPane.setRowHeaderView(this.rowHeader);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        if (!this.getAutoCreateColumnHeader() && !this.getAutoCreateRowHeader()) {
            return;
        }
        JScrollPane jScrollPane = this.getScrollPaneAncestor();
        if (jScrollPane == null) {
            return;
        }
        if (this.getAutoCreateColumnHeader()) {
            jScrollPane.setColumnHeaderView(null);
        }
        if (this.getAutoCreateRowHeader()) {
            jScrollPane.setRowHeaderView(null);
            this.rowHeader = null;
        }
    }

    private void createRowHeader() {
        RowHeaderAdapter rowHeaderAdapter = new RowHeaderAdapter(this.getTableModel());
        this.rowHeader = new JTable(rowHeaderAdapter, null, this.getRowSelectionModel());
        this.rowHeader.addPropertyChangeListener("UI", rowHeaderAdapter);
        this.rowHeader.setAutoCreateColumnsFromModel(false);
        this.rowHeader.setRowMargin(0);
        this.rowHeader.getColumnModel().setColumnMargin(0);
        this.rowHeader.setFocusable(false);
        TreeTable.updateRowHeaderRenderer(this.rowHeader);
        int n = this.getRowHeight();
        if (n > 0) {
            this.rowHeader.setRowHeight(n);
        } else {
            this.updateRowHeaderHeights(0, this.getRowCount());
        }
    }

    private static void updateRowHeaderRenderer(JTable jTable) {
        Serializable serializable;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof JLabel) {
            serializable = (JLabel)((Object)tableCellRenderer);
            serializable.setHorizontalAlignment(0);
        }
        jTable.getColumnModel().getColumn(0).setCellRenderer(tableCellRenderer);
        serializable = tableCellRenderer.getTableCellRendererComponent(jTable, "9999", false, false, -1, -1).getPreferredSize();
        jTable.setPreferredScrollableViewportSize((Dimension)serializable);
    }

    private void updateRowHeaderHeights(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.rowHeader.setRowHeight(i, this.getRowHeight(i));
        }
    }

    private <T extends EventListener> void addListener(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        int n = this.listenerList.getListenerCount(clazz);
        this.listenerList.add(clazz, t);
        if (n == 0) {
            if (clazz == TreeExpansionListener.class) {
                this.tree.addTreeExpansionListener(this.adapter);
            } else if (clazz == TreeWillExpandListener.class) {
                this.tree.addTreeWillExpandListener(this.adapter);
            } else if (clazz == TreeTableMouseListener.class) {
                this.hasTreeTableMouseListener = true;
            } else if (clazz == TreeTableMouseMotionListener.class) {
                this.hasTreeTableMouseMotionListener = true;
            }
        }
    }

    private <T extends EventListener> void removeListener(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        this.listenerList.remove(clazz, t);
        int n = this.listenerList.getListenerCount(clazz);
        if (n == 0) {
            if (clazz == TreeExpansionListener.class) {
                this.tree.removeTreeExpansionListener(this.adapter);
            } else if (clazz == TreeWillExpandListener.class) {
                this.tree.removeTreeWillExpandListener(this.adapter);
            } else if (clazz == TreeTableMouseListener.class) {
                this.hasTreeTableMouseListener = false;
            } else if (clazz == TreeTableMouseMotionListener.class) {
                this.hasTreeTableMouseMotionListener = false;
            }
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.addListener(TreeExpansionListener.class, treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.removeListener(TreeExpansionListener.class, treeExpansionListener);
    }

    private void fireTreeExpansionEvent(TreePath treePath, boolean bl) {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeExpansionListener.class) continue;
            TreeExpansionListener treeExpansionListener = (TreeExpansionListener)objectArray[i + 1];
            if (bl) {
                treeExpansionListener.treeExpanded(treeExpansionEvent);
                continue;
            }
            treeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.addListener(TreeWillExpandListener.class, treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.removeListener(TreeWillExpandListener.class, treeWillExpandListener);
    }

    private void fireTreeWillExpandEvent(TreePath treePath, boolean bl) throws ExpandVetoException {
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this, treePath);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeWillExpandListener.class) continue;
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)objectArray[i + 1];
            if (bl) {
                treeWillExpandListener.treeWillExpand(treeExpansionEvent);
                continue;
            }
            treeWillExpandListener.treeWillCollapse(treeExpansionEvent);
        }
    }

    public void addTreeTableMouseListener(TreeTableMouseListener treeTableMouseListener) {
        this.addListener(TreeTableMouseListener.class, treeTableMouseListener);
    }

    public void removeTreeTableMouseListener(TreeTableMouseListener treeTableMouseListener) {
        this.removeListener(TreeTableMouseListener.class, treeTableMouseListener);
    }

    public void addTreeTableMouseMotionListener(TreeTableMouseMotionListener treeTableMouseMotionListener) {
        this.addListener(TreeTableMouseMotionListener.class, treeTableMouseMotionListener);
    }

    public void removeTreeTableMouseMotionListener(TreeTableMouseMotionListener treeTableMouseMotionListener) {
        this.removeListener(TreeTableMouseMotionListener.class, treeTableMouseMotionListener);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.hasTreeTableMouseListener) {
            this.fireTreeTableMouseEvent(mouseEvent);
        }
        super.processMouseEvent(mouseEvent);
    }

    private void fireTreeTableMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        TreeTableMouseEvent treeTableMouseEvent = new TreeTableMouseEvent(this, mouseEvent);
        Object[] objectArray = this.listenerList.getListenerList();
        block8: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeTableMouseListener.class) continue;
            TreeTableMouseListener treeTableMouseListener = (TreeTableMouseListener)objectArray[i + 1];
            switch (mouseEvent.getID()) {
                case 501: {
                    treeTableMouseListener.mousePressed(treeTableMouseEvent);
                    continue block8;
                }
                case 502: {
                    treeTableMouseListener.mouseReleased(treeTableMouseEvent);
                    continue block8;
                }
                case 500: {
                    treeTableMouseListener.mouseClicked(treeTableMouseEvent);
                }
            }
        }
        if (treeTableMouseEvent.isConsumed()) {
            mouseEvent.consume();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.hasTreeTableMouseMotionListener) {
            this.fireTreeTableMouseMotionEvent(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private void fireTreeTableMouseMotionEvent(MouseEvent mouseEvent) {
        TreeTableMouseEvent treeTableMouseEvent = new TreeTableMouseEvent(this, mouseEvent);
        Object[] objectArray = this.listenerList.getListenerList();
        block4: for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeTableMouseMotionListener.class) continue;
            TreeTableMouseMotionListener treeTableMouseMotionListener = (TreeTableMouseMotionListener)objectArray[i + 1];
            switch (mouseEvent.getID()) {
                case 503: {
                    treeTableMouseMotionListener.mouseMoved(treeTableMouseEvent);
                    continue block4;
                }
                case 506: {
                    treeTableMouseMotionListener.mouseDragged(treeTableMouseEvent);
                }
            }
        }
        if (treeTableMouseEvent.isConsumed()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void doLayout() {
        this.table.doLayout();
        this.tree.doLayout();
        super.doLayout();
    }

    public void invalidateAllRows() {
        Enumeration<TreePath> enumeration;
        Adapter adapter = this.adapter;
        TreePath treePath = new TreePath(adapter.getRoot());
        if (this.tree.isRootVisible()) {
            this.adapter.invalidatePaths(treePath, null, null);
        }
        if ((enumeration = this.tree.getExpandedDescendants(treePath)) == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = enumeration.nextElement();
            Object object = treePath2.getLastPathComponent();
            int n = adapter.getChildCount(object);
            if (n <= 0) continue;
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            int n2 = n;
            while (--n2 >= 0) {
                nArray[n2] = n2;
                objectArray[n2] = adapter.getChild(object, n2);
            }
            this.adapter.invalidatePaths(treePath2, nArray, objectArray);
        }
    }

    public void invalidatePath(TreePath treePath) {
        this.adapter.invalidatePath(treePath);
        if (this.getRowHeight() <= 0) {
            int n = this.getRowForPath(treePath);
            this.updateTableRowHeights(n, n + 1);
        }
    }

    protected void updateTableRowHeights() {
        this.updateTableRowHeights(0, this.tree.getRowCount());
    }

    protected void updateTableRowHeights(int n, int n2) {
        assert (this.tree.getRowHeight() <= 0);
        int n3 = n2;
        while (--n3 >= n) {
            this.table.setRowHeight(n3, this.getRowBounds((int)n3).height);
        }
        if (this.rowHeader != null) {
            this.updateRowHeaderHeights(n, n2);
        }
    }

    public boolean getAutoCreateColumnHeader() {
        return this.autoCreateColumnHeader;
    }

    public void setAutoCreateColumnHeader(boolean bl) {
        boolean bl2 = this.getAutoCreateColumnHeader();
        this.autoCreateColumnHeader = bl;
        this.firePropertyChange("autoCreateColumnHeader", bl2, this.getAutoCreateColumnHeader());
    }

    public boolean getAutoCreateRowHeader() {
        return this.autoCreateRowHeader;
    }

    public void setAutoCreateRowHeader(boolean bl) {
        boolean bl2 = this.getAutoCreateRowHeader();
        this.autoCreateRowHeader = bl;
        this.firePropertyChange("autoCreateRowHeader", bl2, this.getAutoCreateRowHeader());
    }

    public TreeTableCellRenderer getFocusRenderer() {
        return this.focusRenderer;
    }

    public void setFocusRenderer(TreeTableCellRenderer treeTableCellRenderer) {
        TreeTableCellRenderer treeTableCellRenderer2 = this.getFocusRenderer();
        this.focusRenderer = treeTableCellRenderer;
        this.firePropertyChange("focusRenderer", treeTableCellRenderer2, this.getFocusRenderer());
        if (this.isValid()) {
            this.repaint(this.getLeadSelectionPath());
        }
    }

    public ToolTipMap<TreeTable> getDefaultToolTipMap() {
        return this.adapter;
    }

    public ToolTipMap<TreeTable> getToolTipMap() {
        return this.toolTipMap;
    }

    public void setToolTipMap(ToolTipMap<TreeTable> toolTipMap) {
        ToolTipMap<TreeTable> toolTipMap2 = this.getToolTipMap();
        this.toolTipMap = toolTipMap;
        this.firePropertyChange("toolTipMap", toolTipMap2, this.getToolTipMap());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipMap() == null ? this.getToolTipText() : this.getToolTipMap().getToolTipText(this, mouseEvent);
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        TableColumnModel tableColumnModel2 = this.getColumnModel();
        this.columnModel = tableColumnModel;
        this.firePropertyChange("columnModel", tableColumnModel2, this.getColumnModel());
    }

    public TreeModel getTreeModel() {
        return this.adapter.treeModel;
    }

    public void setTreeModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.getTreeModel();
        this.adapter.setTreeModel(treeModel);
        this.firePropertyChange("treeModel", treeModel2, this.getTreeModel());
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
    }

    public TreeColumnModel getTreeColumnModel() {
        return this.adapter.treeColumnModel;
    }

    public void setTreeColumnModel(TreeColumnModel treeColumnModel) {
        TreeColumnModel treeColumnModel2 = this.getTreeColumnModel();
        this.adapter.treeColumnModel = treeColumnModel;
        this.adapter.fireTableStructureChanged();
        this.firePropertyChange("treeColumnModel", treeColumnModel2, this.getTreeColumnModel());
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
    }

    public TableModel getTableModel() {
        return this.adapter;
    }

    public TreeTableModel getTreeTableModel() {
        return this.adapter;
    }

    public TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> getRowSorter() {
        return this.adapter.rowSorter;
    }

    public void setRowSorter(TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> treeTableSorter) {
        TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> treeTableSorter2 = this.getRowSorter();
        this.adapter.setRowSorter(treeTableSorter);
        this.firePropertyChange("rowSorter", treeTableSorter2, this.getRowSorter());
    }

    public boolean isNodeSortingEnabled() {
        return this.nodeSortingEnabled;
    }

    public void setNodeSortingEnabled(boolean bl) {
        boolean bl2 = this.isNodeSortingEnabled();
        this.nodeSortingEnabled = bl;
        this.firePropertyChange("nodeSortingEnabled", bl2, this.isNodeSortingEnabled());
        if (!this.sortedPaths.isEmpty()) {
            this.repaint();
        }
    }

    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    public void setAutoCreateRowSorter(boolean bl) {
        boolean bl2 = this.getAutoCreateRowSorter();
        this.autoCreateRowSorter = bl;
        if (this.getAutoCreateRowSorter()) {
            this.autoCreateRowSorter();
        }
        this.firePropertyChange("autoCreateRowSorter", bl2, this.getAutoCreateRowSorter());
    }

    private void autoCreateRowSorter() {
        this.setRowSorter(new DefaultTreeTableSorter(this.getTreeModel(), this.getTreeColumnModel()));
    }

    public RowSorter<?> getSorterForPath(TreePath treePath) {
        return this.adapter.getSorter(treePath);
    }

    public boolean isColumnFocusEnabled() {
        return this.columnFocusEnabled;
    }

    public void setColumnFocusEnabled(boolean bl) {
        boolean bl2 = this.isColumnFocusEnabled();
        this.columnFocusEnabled = bl;
        this.firePropertyChange("columnFocusEnabled", bl2, this.isColumnFocusEnabled());
        this.repaint(this.getLeadSelectionPath());
    }

    public TableColumn getColumn(Object object) {
        return this.columnModel.getColumn(this.columnModel.getColumnIndex(object));
    }

    public Color getAlternateRowColor() {
        return this.alternateRowColor;
    }

    public void setAlternateRowColor(Color color) {
        Color color2 = this.getAlternateRowColor();
        this.alternateRowColor = color;
        this.firePropertyChange("alternateRowColor", color2, this.getAlternateRowColor());
    }

    public void setDefaultRenderer(Class<?> clazz, TreeTableCellRenderer treeTableCellRenderer) {
        this.defaultRenderers = TreeTable.putDefault(clazz, treeTableCellRenderer, this.defaultRenderers);
    }

    public TreeTableCellRenderer getDefaultRenderer(Class<?> clazz) {
        TreeTableCellRenderer treeTableCellRenderer;
        TreeTableCellRenderer treeTableCellRenderer2 = treeTableCellRenderer = this.defaultRenderers == null ? null : TreeTable.getDefault(clazz, this.defaultRenderers);
        return treeTableCellRenderer != null ? treeTableCellRenderer : (this.ui == null ? null : this.getUI().getDefaultRenderer(this, clazz));
    }

    public void setDefaultEditor(Class<?> clazz, TreeTableCellEditor treeTableCellEditor) {
        this.defaultEditors = TreeTable.putDefault(clazz, treeTableCellEditor, this.defaultEditors);
    }

    public TreeTableCellEditor getDefaultEditor(Class<?> clazz, int n) {
        TreeTableCellEditor treeTableCellEditor;
        TreeTableCellEditor treeTableCellEditor2 = treeTableCellEditor = this.defaultEditors == null ? null : TreeTable.getDefault(clazz, this.defaultEditors);
        return treeTableCellEditor != null ? treeTableCellEditor : (this.ui == null ? null : this.getUI().getDefaultEditor(this, clazz, n));
    }

    private static <T> HashMap<Class<?>, T> putDefault(Class<?> clazz, T t, HashMap<Class<?>, T> hashMap) {
        if (hashMap == null) {
            if (t == null) {
                return null;
            }
            hashMap = new HashMap(8);
        }
        if (t != null) {
            hashMap.put(clazz, t);
        } else {
            hashMap.remove(clazz);
        }
        return hashMap;
    }

    private static <T> T getDefault(Class<?> clazz, HashMap<Class<?>, T> hashMap) {
        if (clazz == null) {
            return null;
        }
        T t = hashMap.get(clazz);
        return t != null ? t : TreeTable.getDefault(clazz.getSuperclass(), hashMap);
    }

    public TreeTableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 >= 0 && n2 < this.getColumnModel().getColumnCount()) {
            TableCellRenderer tableCellRenderer = this.getColumnModel().getColumn(n2).getCellRenderer();
            if (tableCellRenderer instanceof TreeTableCellRenderer) {
                return (TreeTableCellRenderer)((Object)tableCellRenderer);
            }
            return this.getDefaultRenderer(this.getTreeColumnModel().getColumnClass(this.convertColumnIndexToModel(n2)));
        }
        return this.getDefaultRenderer(Object.class);
    }

    public TreeTableCellEditor getCellEditor(int n, int n2) {
        if (n2 >= 0 && n2 < this.getColumnModel().getColumnCount()) {
            TableCellEditor tableCellEditor = this.getColumnModel().getColumn(n2).getCellEditor();
            if (tableCellEditor instanceof TreeTableCellEditor) {
                return (TreeTableCellEditor)((Object)tableCellEditor);
            }
            return this.getDefaultEditor(this.getTreeColumnModel().getColumnClass(this.convertColumnIndexToModel(n2)), n2);
        }
        return this.getDefaultEditor(Object.class, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.adapter.isCellEditable(n, this.convertColumnIndexToModel(n2));
    }

    public boolean startEditingAtPath(TreePath treePath) {
        return this.editCellAt(this.getRowForPath(treePath), this.getHierarchicalColumn());
    }

    public boolean startEditingAtRow(int n) {
        return this.editCellAt(n, this.getHierarchicalColumn());
    }

    public boolean editCellAt(int n, int n2) {
        return this.table.editCellAt(n, n2);
    }

    public boolean isEditing() {
        return this.table.isEditing();
    }

    public Component getEditorComponent() {
        return this.table.getEditorComponent();
    }

    public int getEditingColumn() {
        return this.table.getEditingColumn();
    }

    public int getEditingRow() {
        return this.table.getEditingRow();
    }

    public TreeTableCellEditor getCellEditor() {
        return (TreeTableCellEditor)((Object)this.table.getCellEditor());
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(this.getTreeColumnModel().getHierarchicalColumn());
    }

    public int convertColumnIndexToView(int n) {
        return this.table.convertColumnIndexToView(n);
    }

    public int convertColumnIndexToModel(int n) {
        return this.table.convertColumnIndexToModel(n);
    }

    public int convertNodeIndexToView(Object object, int n) {
        return this.adapter.convertIndexToView(object, n);
    }

    public int convertNodeIndexToModel(Object object, int n) {
        return this.adapter.convertIndexToModel(object, n);
    }

    public Object getValueAt(int n, int n2) {
        return this.adapter.getValueAt(n, this.convertColumnIndexToModel(n2));
    }

    public Object getNode(int n) {
        return this.adapter.getNode(n);
    }

    public Icon getLeafIcon() {
        if (this.leafIcon == null) {
            this.leafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        return this.leafIcon;
    }

    public void setLeafIcon(Icon icon) {
        Icon icon2 = this.leafIcon;
        this.leafIcon = icon;
        this.firePropertyChange("leafIcon", icon2, this.getLeafIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    public Icon getOpenIcon() {
        if (this.openIcon == null) {
            this.openIcon = UIManager.getIcon("Tree.openIcon");
        }
        return this.openIcon;
    }

    public void setOpenIcon(Icon icon) {
        Icon icon2 = this.openIcon;
        this.openIcon = icon;
        this.firePropertyChange("openIcon", icon2, this.getOpenIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    public Icon getClosedIcon() {
        if (this.closedIcon == null) {
            this.closedIcon = UIManager.getIcon("Tree.closedIcon");
        }
        return this.closedIcon;
    }

    public void setClosedIcon(Icon icon) {
        Icon icon2 = this.closedIcon;
        this.closedIcon = icon;
        this.firePropertyChange("closedIcon", icon2, this.getClosedIcon());
        this.repaintColumn(this.getHierarchicalColumn());
    }

    private void repaintColumn(int n) {
        if (n < 0 || this.getRowCount() == 0) {
            return;
        }
        Rectangle rectangle = this.getCellRect(0, n, true);
        rectangle.height = this.getHeight();
        this.repaint(rectangle);
    }

    public IconMap getIconMap() {
        return this.iconMap;
    }

    public void setIconMap(IconMap iconMap) {
        IconMap iconMap2 = this.getIconMap();
        this.iconMap = iconMap;
        this.firePropertyChange("iconMap", iconMap2, this.getIconMap());
        if (this.isValid()) {
            this.repaintColumn(this.getHierarchicalColumn());
        }
    }

    public Icon getAscendingSortIcon() {
        if (this.ascendingSortIcon == null) {
            this.ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        }
        return this.ascendingSortIcon;
    }

    public void setAscendingSortIcon(Icon icon) {
        Icon icon2 = this.getAscendingSortIcon();
        this.ascendingSortIcon = icon;
        this.firePropertyChange("ascendingSortIcon", icon2, this.getAscendingSortIcon());
    }

    public Icon getDescendingSortIcon() {
        if (this.descendingSortIcon == null) {
            this.descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");
        }
        return this.descendingSortIcon;
    }

    public void setDescendingSortIcon(Icon icon) {
        Icon icon2 = this.getDescendingSortIcon();
        this.descendingSortIcon = icon;
        this.firePropertyChange("descendingSortIcon", icon2, this.getDescendingSortIcon());
    }

    public Icon getIconForPath(TreePath treePath) {
        return this.getIcon(treePath.getLastPathComponent(), this.isExpanded(treePath), this.isLeaf(treePath));
    }

    public Icon getIconForRow(int n) {
        return this.getIconForPath(this.getPathForRow(n));
    }

    public Icon getIcon(Object object, boolean bl, boolean bl2) {
        Icon icon;
        Icon icon2 = icon = this.iconMap == null ? null : this.iconMap.getIcon(this, object, bl, bl2);
        if (icon == null) {
            icon = bl2 ? this.getLeafIcon() : (bl ? this.getOpenIcon() : this.getClosedIcon());
        }
        return icon;
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.table.getAutoCreateColumnsFromModel();
    }

    public void setAutoCreateColumnsFromModel(boolean bl) {
        this.table.setAutoCreateColumnsFromModel(bl);
    }

    public int getAutoResizeMode() {
        return this.table.getAutoResizeMode();
    }

    public void setAutoResizeMode(int n) {
        this.table.setAutoResizeMode(n);
    }

    public boolean getCellSelectionEnabled() {
        return this.table.getCellSelectionEnabled();
    }

    public void setCellSelectionEnabled(boolean bl) {
        this.table.setCellSelectionEnabled(bl);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public boolean getColumnSelectionAllowed() {
        return this.table.getColumnSelectionAllowed();
    }

    public void setColumnSelectionAllowed(boolean bl) {
        this.table.setColumnSelectionAllowed(bl);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public Color getGridColor() {
        return this.table.getGridColor();
    }

    public void setGridColor(Color color) {
        this.table.setGridColor(color);
    }

    public Dimension getIntercellSpacing() {
        return this.table.getIntercellSpacing();
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.table.setIntercellSpacing(dimension);
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public void setRowMargin(int n) {
        int n2 = this.getRowMargin();
        this.rowMargin = n;
        this.firePropertyChange("rowMargin", n2, this.getRowMargin());
        if (this.isValid()) {
            this.repaint();
        }
    }

    public boolean getRowSelectionAllowed() {
        return this.table.getRowSelectionAllowed();
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.table.setRowSelectionAllowed(bl);
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public boolean getShowHorizontalLines() {
        return this.table.getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean bl) {
        this.table.setShowHorizontalLines(bl);
    }

    public boolean getShowVerticalLines() {
        return this.table.getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean bl) {
        this.table.setShowVerticalLines(bl);
    }

    public void setShowGrid(boolean bl) {
        this.table.setShowGrid(bl);
    }

    public JTableHeader getTableHeader() {
        return this.table.getTableHeader();
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        this.table.setTableHeader(jTableHeader);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath treePath) {
        return this.tree.getExpandedDescendants(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.tree.collapsePath(treePath);
    }

    public void collapseRow(int n) {
        this.collapsePath(this.getPathForRow(n));
    }

    public void expandPath(TreePath treePath) {
        this.tree.expandPath(treePath);
    }

    public void expandRow(int n) {
        this.expandPath(this.getPathForRow(n));
    }

    public void makeVisible(TreePath treePath) {
        this.tree.makeVisible(treePath);
    }

    public void scrollPathToVisible(TreePath treePath) {
        this.tree.scrollPathToVisible(treePath);
    }

    public void scrollRowToVisible(int n) {
        this.scrollPathToVisible(this.getPathForRow(n));
    }

    public Rectangle getPathBounds(TreePath treePath) {
        return this.ui == null ? null : this.getUI().getPathBounds(this, treePath);
    }

    public TreePath getPathForLocation(int n, int n2) {
        return this.ui == null ? null : this.getUI().getPathForLocation(this, n, n2);
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        return this.ui == null ? null : this.getUI().getClosestPathForLocation(this, n, n2);
    }

    public TreePath getPathForRow(int n) {
        return this.tree.getPathForRow(n);
    }

    public Rectangle getRowBounds(int n) {
        return this.getPathBounds(this.getPathForRow(n));
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public int getRowForLocation(int n, int n2) {
        TreePath treePath = this.getPathForLocation(n, n2);
        return treePath == null ? -1 : this.getRowForPath(treePath);
    }

    public int getClosestRowForLocation(int n, int n2) {
        return this.tree.getClosestRowForLocation(n, n2);
    }

    public int getRowForPath(TreePath treePath) {
        return this.tree.getRowForPath(treePath);
    }

    public boolean isCollapsed(int n) {
        return this.isCollapsed(this.getPathForRow(n));
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.tree.isCollapsed(treePath);
    }

    public boolean isExpanded(int n) {
        return this.isExpanded(this.getPathForRow(n));
    }

    public boolean isExpanded(TreePath treePath) {
        return this.tree.isExpanded(treePath);
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return this.tree.hasBeenExpanded(treePath);
    }

    public boolean isFixedRowHeight() {
        return this.tree.isFixedRowHeight();
    }

    public boolean isLargeModel() {
        return this.tree.isLargeModel();
    }

    public void setLargeModel(boolean bl) {
        this.tree.setLargeModel(bl);
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean bl) {
        this.tree.setScrollsOnExpand(bl);
    }

    public boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    public void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }

    public void setToggleClickCount(int n) {
        this.tree.setToggleClickCount(n);
    }

    public int getToggleClickCount() {
        return this.tree.getToggleClickCount();
    }

    public int getVisibleRowCount() {
        return this.tree.getVisibleRowCount();
    }

    public void setVisibleRowCount(int n) {
        this.tree.setVisibleRowCount(n);
    }

    public int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public void setRowHeight(int n) {
        int n2 = this.getRowHeight();
        if (n > 0) {
            this.table.setRowHeight(n);
            if (this.rowHeader != null) {
                this.rowHeader.setRowHeight(n);
            }
        }
        this.tree.setRowHeight(n);
        if (n <= 0 && n2 > 0) {
            this.updateTableRowHeights();
        }
    }

    public int getRowHeight(int n) {
        return this.table.getRowHeight(n);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree == null ? null : this.tree.getSelectionModel();
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.tree != null) {
            this.tree.setSelectionModel(treeSelectionModel);
        }
    }

    public ListSelectionModel getRowSelectionModel() {
        return this.adapter;
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.tree.isSelectionEmpty();
    }

    public int getSelectionCount() {
        return this.tree.getSelectionCount();
    }

    public int getMaxSelectionRow() {
        return this.tree.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.tree.getMinSelectionRow();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.tree.isPathSelected(treePath);
    }

    public boolean isRowSelected(int n) {
        return this.isPathSelected(this.getPathForRow(n));
    }

    public boolean isColumnSelected(int n) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isCellSelected(int n, int n2) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(n) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n2));
    }

    public TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    public void setAnchorSelectionPath(TreePath treePath) {
        this.tree.setAnchorSelectionPath(treePath);
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void setLeadSelectionPath(TreePath treePath) {
        this.tree.setLeadSelectionPath(treePath);
    }

    public int getLeadSelectionRow() {
        return this.tree.getLeadSelectionRow();
    }

    public int getLeadSelectionColumn() {
        return this.columnModel.getSelectionModel().getLeadSelectionIndex();
    }

    public boolean getExpandsSelectedPaths() {
        return this.tree.getExpandsSelectedPaths();
    }

    public void setExpandsSelectedPaths(boolean bl) {
        this.tree.setExpandsSelectedPaths(bl);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void setSelectionPath(TreePath treePath) {
        this.tree.setSelectionPath(treePath);
    }

    public int getSelectedRow() {
        return this.getRowForPath(this.getSelectionPath());
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.tree.setSelectionPaths(treePathArray);
    }

    public int[] getSelectionRows() {
        return this.tree.getSelectionRows();
    }

    public int[] getSelectedRows() {
        return this.getSelectionRows();
    }

    public void addSelectionInterval(int n, int n2) {
        this.tree.addSelectionInterval(n, n2);
    }

    public void addSelectionPath(TreePath treePath) {
        this.tree.addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.tree.addSelectionPaths(treePathArray);
    }

    public void addSelectionRow(int n) {
        this.addSelectionPath(this.getPathForRow(n));
    }

    public void addSelectionRows(int[] nArray) {
        this.tree.addSelectionRows(nArray);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.tree.removeSelectionInterval(n, n2);
    }

    public void removeSelectionPath(TreePath treePath) {
        this.tree.removeSelectionPath(treePath);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.tree.removeSelectionPaths(treePathArray);
    }

    public void removeSelectionRow(int n) {
        this.removeSelectionPath(this.getPathForRow(n));
    }

    public void removeSelectionRows(int[] nArray) {
        this.tree.removeSelectionRows(nArray);
    }

    public void setSelectionRows(int[] nArray) {
        this.tree.setSelectionRows(nArray);
    }

    public void setSelectionRow(int n) {
        this.setSelectionPath(this.getPathForRow(n));
    }

    public void setSelectionInterval(int n, int n2) {
        this.tree.setSelectionInterval(n, n2);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.table.changeSelection(n, n2, bl, bl2);
    }

    public Color getSelectionForeground() {
        return this.table.getSelectionForeground();
    }

    public void setSelectionForeground(Color color) {
        this.table.setSelectionForeground(color);
    }

    public Color getSelectionBackground() {
        return this.table.getSelectionBackground();
    }

    public void setSelectionBackground(Color color) {
        this.table.setSelectionBackground(color);
    }

    public int getSelectedRowCount() {
        return this.getSelectionCount();
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        return this.table.getCellBounds(n, n2, bl);
    }

    public int columnAtPoint(Point point) {
        return this.table.columnAtPoint(point);
    }

    public int rowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension;
        if (this.adapter.treeColumnModel.getHierarchicalColumn() < 0) {
            int n = this.getRowHeight();
            if (n <= 0) {
                n = 20;
            }
            dimension = new Dimension(this.tree.getVisibleRowCount() * n, 0);
        } else {
            dimension = this.tree.getPreferredScrollableViewportSize();
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = 0;
        int n2 = tableColumnModel.getColumnCount();
        while (--n2 >= 0) {
            n += tableColumnModel.getColumn(n2).getPreferredWidth();
        }
        dimension.width = n + tableColumnModel.getColumnMargin() * tableColumnModel.getColumnCount();
        return dimension;
    }

    private Scrollable getScrollable(int n) {
        return n == 1 ? this.tree : this.table;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.getScrollable(n).getScrollableBlockIncrement(rectangle, n, n2);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.table.getScrollableTracksViewportHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.table.getScrollableTracksViewportWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.getScrollable(n).getScrollableUnitIncrement(rectangle, n, n2);
    }

    void repaint(TreePath treePath, int n) {
        if (n < 0) {
            this.repaint(treePath);
        } else if (treePath != null) {
            this.repaint(this.getCellRect(this.getRowForPath(treePath), n, true));
        }
    }

    void repaint(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle == null) {
            return;
        }
        rectangle.x = 0;
        rectangle.width = this.getWidth();
        this.repaint(rectangle);
    }

    protected Adapter createAdapter(TreeModel treeModel, TreeColumnModel treeColumnModel) {
        return new Adapter(treeModel, treeColumnModel);
    }

    public Map<TreePath, RowSorter.SortKey> getSortedPaths() {
        return Collections.unmodifiableMap(this.sortedPaths);
    }

    public boolean getExpandsSortedNodes() {
        return this.expandsSortedNodes;
    }

    public void setExpandesSortedNodes(boolean bl) {
        boolean bl2 = this.getExpandsSortedNodes();
        this.expandsSortedNodes = bl;
        this.firePropertyChange("expandsSortedNodes", bl2, this.getExpandsSortedNodes());
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        boolean bl2 = this.getDragEnabled();
        this.dragEnabled = bl;
        this.firePropertyChange("dragEnabled", bl2, this.getDragEnabled());
        if (this.getDragEnabled()) {
            this.updateDropMode();
        }
    }

    public DropMode getDropMode() {
        return this.table.getDropMode();
    }

    public void setDropMode(DropMode dropMode) {
        if (dropMode == null) {
            this.dropModeSet = false;
            this.updateDropMode();
        } else {
            switch (dropMode) {
                default: {
                    throw new IllegalArgumentException("Unsupported DropMode: " + (Object)((Object)dropMode));
                }
                case ON: 
                case INSERT: 
                case INSERT_ROWS: 
                case INSERT_COLS: 
                case ON_OR_INSERT: 
                case ON_OR_INSERT_ROWS: 
                case ON_OR_INSERT_COLS: 
            }
            this.dropModeSet = true;
            this.table.setDropMode(dropMode);
        }
    }

    private void updateDropMode() {
        if (this.dropModeSet) {
            return;
        }
        if (this.getRowSelectionAllowed()) {
            if (this.getColumnSelectionAllowed()) {
                this.table.setDropMode(DropMode.ON);
            } else {
                this.table.setDropMode(DropMode.INSERT_ROWS);
            }
        } else if (this.getColumnSelectionAllowed()) {
            this.table.setDropMode(DropMode.INSERT_COLS);
        } else {
            this.table.setDropMode(DropMode.ON);
        }
    }

    public DropLocation getDropLocation() {
        if (this.dtde != null) {
            return this.createDropLocation(this.dtde.getLocation());
        }
        return this.dropLocation;
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        super.setTransferHandler(transferHandler);
        if (transferHandler != null) {
            this.setDropTarget(new DT(this.getDropTarget()));
        }
    }

    private void setDropLocation(Point point) {
        DropLocation dropLocation = this.dropLocation;
        DropLocation dropLocation2 = this.dropLocation = point == null ? null : this.createDropLocation(point);
        if (dropLocation == null || this.dropLocation == null) {
            if (dropLocation != this.dropLocation) {
                this.repaint(dropLocation, this.dropLocation);
            }
        } else if (dropLocation.equals(this.dropLocation)) {
            this.maybeTogglePath(dropLocation, point);
        } else {
            if (point.equals(dropLocation.getDropPoint())) {
                this.dropLocation.when = dropLocation.when;
            }
            this.repaint(dropLocation, this.dropLocation);
        }
    }

    private void repaint(DropLocation dropLocation, DropLocation dropLocation2) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        if (dropLocation != null) {
            n = Math.min(n, dropLocation.getRow() - 1);
            n2 = Math.max(n2, dropLocation.getRow());
        }
        if (dropLocation2 != null) {
            n = Math.min(n, dropLocation2.getRow() - 1);
            n2 = Math.max(n2, dropLocation2.getRow());
        }
        Rectangle rectangle = this.getCellRect(Math.max(0, n), 0, true);
        if (n2 >= this.getRowCount()) {
            rectangle.height = this.getHeight() - rectangle.y;
        } else {
            rectangle.add(this.getCellRect(n2, 0, true));
        }
        rectangle.x = 0;
        rectangle.width = this.getWidth();
        this.repaint(rectangle);
    }

    private void maybeTogglePath(DropLocation dropLocation, Point point) {
        if (!point.equals(dropLocation.getDropPoint())) {
            this.dropLocation.when = 0L;
            return;
        }
        long l = dropLocation.when;
        if (l == 0L) {
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            this.dropLocation.when = treePath == null ? (this.isOverTreeHandle(point) ? System.currentTimeMillis() : -1L) : (this.isLeaf(treePath) || this.isExpanded(treePath) ? -1L : System.currentTimeMillis());
        } else if (l > 0L && System.currentTimeMillis() - l > 900L) {
            TreePath treePath = this.getClosestPathForLocation(point.x, point.y);
            if (this.isExpanded(treePath)) {
                this.collapsePath(treePath);
            } else {
                this.expandPath(treePath);
            }
            this.dropLocation.when = -1L;
        } else {
            this.dropLocation.when = l;
        }
    }

    private boolean isOverTreeHandle(Point point) {
        int n;
        int n2 = this.columnAtPoint(point);
        if (n2 >= 0 && n2 == this.getHierarchicalColumn() && (n = this.rowAtPoint(point)) >= 0) {
            return this.getDistanceToTreeHandle(this.getPathForRow(n), point.x) == 0;
        }
        return false;
    }

    private DropLocation createDropLocation(Point point) {
        Serializable serializable;
        Serializable serializable2 = null;
        int n = -1;
        int n2 = this.rowAtPoint(point);
        int n3 = this.columnAtPoint(point);
        boolean bl = false;
        boolean bl2 = false;
        DropMode dropMode = this.getDropMode();
        switch (dropMode) {
            case INSERT: {
                if (n2 < 0) {
                    dropMode = DropMode.INSERT_ROWS;
                    break;
                }
                if (n3 < 0) {
                    dropMode = DropMode.INSERT_COLS;
                    break;
                }
                serializable = this.getCellRect(n2, n3, true);
                int n4 = Math.min(point.x - ((Rectangle)serializable).x, ((Rectangle)serializable).x + ((Rectangle)serializable).width - point.x);
                int n5 = Math.min(point.y - ((Rectangle)serializable).y, ((Rectangle)serializable).y + ((Rectangle)serializable).height - point.y);
                dropMode = n5 < n4 ? DropMode.INSERT_ROWS : DropMode.INSERT_COLS;
                break;
            }
            case ON_OR_INSERT: {
                if (n2 < 0) {
                    dropMode = DropMode.INSERT_ROWS;
                    break;
                }
                if (n3 < 0) {
                    dropMode = DropMode.INSERT_COLS;
                    break;
                }
                serializable = this.getCellRect(n2, n3, true);
                int n4 = Math.min(point.x - ((Rectangle)serializable).x, ((Rectangle)serializable).x + ((Rectangle)serializable).width - point.x);
                int n6 = Math.min(point.y - ((Rectangle)serializable).y, ((Rectangle)serializable).y + ((Rectangle)serializable).height - point.y);
                if (n6 < n4) {
                    dropMode = n6 < ((Rectangle)serializable).height / 4 ? DropMode.INSERT_ROWS : DropMode.ON;
                    break;
                }
                dropMode = n4 < ((Rectangle)serializable).width / 4 ? DropMode.INSERT_COLS : DropMode.ON;
                break;
            }
            case ON_OR_INSERT_ROWS: {
                if (n2 < 0) {
                    dropMode = DropMode.INSERT_ROWS;
                    break;
                }
                serializable = this.getCellRect(n2, n3, true);
                int n4 = Math.min(point.y - ((Rectangle)serializable).y, ((Rectangle)serializable).y + ((Rectangle)serializable).height - point.y);
                dropMode = n4 < ((Rectangle)serializable).height / 4 ? DropMode.INSERT_ROWS : DropMode.ON;
                break;
            }
            case ON_OR_INSERT_COLS: {
                if (n3 < 0) {
                    dropMode = DropMode.INSERT_COLS;
                    break;
                }
                serializable = this.getCellRect(n2, n3, true);
                int n4 = Math.min(point.x - ((Rectangle)serializable).x, ((Rectangle)serializable).x + ((Rectangle)serializable).width - point.x);
                dropMode = n4 < ((Rectangle)serializable).width / 4 ? DropMode.INSERT_COLS : DropMode.ON;
            }
        }
        switch (dropMode) {
            case ON: {
                if (n2 < 0) {
                    n3 = -1;
                    break;
                }
                if (n3 < 0) {
                    n2 = -1;
                    break;
                }
                serializable2 = this.getPathForRow(n2);
                break;
            }
            case INSERT_ROWS: {
                bl = true;
                if (n2 < 0) {
                    n2 = this.getRowCount();
                    serializable2 = n2 == 0 ? new TreePath(this.adapter.treeRoot) : ((serializable2 = this.getPathForRow(n2 - 1)).getPathCount() < 3 ? new TreePath(this.adapter.treeRoot) : serializable2.getParentPath().getParentPath());
                    n = this.getChildCount((TreePath)serializable2);
                    break;
                }
                serializable = this.getPathForRow(n2);
                serializable2 = ((TreePath)serializable).getParentPath();
                int n7 = n = serializable2 == null ? 0 : this.adapter.getIndexOfChild(serializable2.getLastPathComponent(), ((TreePath)serializable).getLastPathComponent());
                if (serializable2 == null) {
                    serializable2 = serializable;
                    if (!this.isRootVisible()) break;
                    n2 = 1;
                    break;
                }
                Rectangle rectangle = this.getCellRect(n2, n3, true);
                if (point.y <= rectangle.y + rectangle.height / 2) break;
                if (this.isExpanded((TreePath)serializable)) {
                    serializable2 = serializable;
                    n = 0;
                } else {
                    ++n;
                }
                ++n2;
                break;
            }
            case INSERT_COLS: {
                bl2 = true;
                if (n2 < 0) {
                    n3 = -1;
                    break;
                }
                serializable2 = this.getPathForRow(n2);
                if (n3 < 0) {
                    n3 = this.columnModel.getColumnCount();
                    break;
                }
                serializable = this.getCellRect(n2, n3, true);
                if (point.x <= ((Rectangle)serializable).x + ((Rectangle)serializable).width / 2) break;
                ++n3;
            }
        }
        return new DropLocation(point, (TreePath)serializable2, n, n2, n3, bl, bl2);
    }

    public int getNextMatch(String string, int n, int n2, Position.Bias bias) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        TableModel tableModel = this.getTableModel();
        int n3 = this.getRowCount();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException();
        }
        int n4 = this.convertColumnIndexToModel(n2);
        int n5 = bias == Position.Bias.Forward ? 1 : -1;
        string = string.toUpperCase();
        int n6 = n;
        do {
            String string2;
            if ((string2 = this.convertValueToText(tableModel.getValueAt(n6, n4), n2)).isEmpty() || !(string2 = string2.toUpperCase()).startsWith(string)) continue;
            return n6;
        } while ((n6 = (n6 + n5 + n3) % n3) != n);
        return -1;
    }

    public String convertValueToText(Object object, int n) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        return string == null ? "" : string;
    }

    public boolean isLeaf(TreePath treePath) {
        return this.getTreeModel().isLeaf(treePath.getLastPathComponent());
    }

    public int getChildCount(TreePath treePath) {
        return this.adapter.getChildCount(treePath.getLastPathComponent());
    }

    public int getDistanceToTreeHandle(TreePath treePath, int n) {
        return this.getUI().getDistanceToTreeHandle(this, treePath, n);
    }

    public int getAlignment(Component component, int n, int n2) {
        if (component instanceof JLabel) {
            return this.getAlignment(((JLabel)component).getHorizontalAlignment());
        }
        if (component instanceof AbstractButton) {
            return this.getAlignment(((AbstractButton)component).getHorizontalAlignment());
        }
        return 0;
    }

    private int getAlignment(int n) {
        switch (n) {
            case 10: {
                return this.getComponentOrientation().isLeftToRight() ? 2 : 4;
            }
            case 11: {
                return this.getComponentOrientation().isLeftToRight() ? 4 : 2;
            }
        }
        return n;
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final TreePath path;
        private final int index;
        private final int row;
        private final int column;
        private final boolean isInsertRow;
        private final boolean isInsertColumn;
        long when = 0L;

        DropLocation(Point point, TreePath treePath, int n, int n2, int n3, boolean bl, boolean bl2) {
            super(point);
            this.path = treePath;
            this.index = n;
            this.row = n2;
            this.column = n3;
            this.isInsertRow = bl;
            this.isInsertColumn = bl2;
        }

        public TreePath getPath() {
            return this.path;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isInsertRow() {
            return this.isInsertRow;
        }

        public boolean isInsertColumn() {
            return this.isInsertColumn;
        }

        public boolean equals(DropLocation dropLocation) {
            return dropLocation != null && this.row == dropLocation.row && this.column == dropLocation.column && this.isInsertRow == dropLocation.isInsertRow && this.isInsertColumn == dropLocation.isInsertColumn && this.index == dropLocation.index && (this.path == null ? dropLocation.path == null : this.path.equals(dropLocation.path));
        }
    }

    private class DT
    extends DropTarget {
        private DropTarget delegate;

        DT(DropTarget dropTarget) {
            super(dropTarget.getComponent(), dropTarget.getDefaultActions(), null);
            this.delegate = dropTarget;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            TreeTable.this.dtde = new DTDE(dropTargetDragEvent);
            try {
                this.delegate.dragEnter(TreeTable.this.dtde);
            }
            finally {
                TreeTable.this.dtde = null;
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.delegate.dragExit(dropTargetEvent);
            TreeTable.this.setDropLocation(null);
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            TreeTable.this.dtde = new DTDE(dropTargetDragEvent);
            try {
                this.delegate.dragOver(TreeTable.this.dtde);
            }
            finally {
                TreeTable.this.dtde = null;
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.delegate.drop(dropTargetDropEvent);
            TreeTable.this.setDropLocation(null);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.delegate.dropActionChanged(dropTargetDragEvent);
        }

        @Override
        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            this.delegate.addDropTargetListener(dropTargetListener);
        }

        @Override
        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            this.delegate.removeDropTargetListener(dropTargetListener);
        }
    }

    private class DTDE
    extends DropTargetDragEvent {
        private DropTargetDragEvent dtde;

        DTDE(DropTargetDragEvent dropTargetDragEvent) {
            super(dropTargetDragEvent.getDropTargetContext(), dropTargetDragEvent.getLocation(), dropTargetDragEvent.getDropAction(), dropTargetDragEvent.getSourceActions());
            this.dtde = dropTargetDragEvent;
        }

        @Override
        public void acceptDrag(int n) {
            TreeTable.this.setDropLocation(this.dtde.getLocation());
            this.dtde.acceptDrag(n);
        }

        @Override
        public void rejectDrag() {
            TreeTable.this.setDropLocation(null);
            this.dtde.rejectDrag();
        }
    }

    private static class RowHeaderAdapter
    extends AbstractTableModel
    implements TableModelListener,
    PropertyChangeListener {
        private TableModel model;

        RowHeaderAdapter(TableModel tableModel) {
            this.model = tableModel;
            tableModel.addTableModelListener(this);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), 0, tableModelEvent.getType()));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TreeTable.updateRowHeaderRenderer((JTable)propertyChangeEvent.getSource());
        }
    }

    private static class SorterHelper
    implements Comparator<AbstractMap.SimpleEntry<Integer, Object>> {
        private final RowSorter<?> sorter;
        private final int[] childIndices;
        private final Object[] childNodes;
        int[] viewIndices;
        Object[] viewNodes;
        int firstRow;
        int lastRow;

        SorterHelper(RowSorter<?> rowSorter, int[] nArray, Object[] objectArray) {
            this.sorter = rowSorter;
            this.childIndices = nArray;
            this.childNodes = objectArray;
        }

        @Override
        public int compare(AbstractMap.SimpleEntry<Integer, Object> simpleEntry, AbstractMap.SimpleEntry<Integer, Object> simpleEntry2) {
            return simpleEntry.getKey() - simpleEntry2.getKey();
        }

        boolean useAllChanged() {
            int[] nArray = this.childIndices;
            int n = -1;
            int n2 = -1;
            int n3 = nArray.length;
            while (--n3 >= 0) {
                int n4 = nArray[n3];
                if (n < 0) {
                    n = n2 = n4;
                    continue;
                }
                if (n4 == n - 1) {
                    n = n4;
                    continue;
                }
                return true;
            }
            this.firstRow = n;
            this.lastRow = n2;
            return false;
        }

        boolean computeView() {
            int n;
            int[] nArray = new int[this.childIndices.length];
            Object[] objectArray = new Object[this.childIndices.length];
            int n2 = 0;
            for (int i = 0; i < this.childIndices.length; ++i) {
                n = this.childIndices[i];
                int n3 = this.sorter.convertRowIndexToView(n);
                if (n3 < 0) continue;
                nArray[n2] = n3;
                objectArray[n2++] = this.childNodes[i];
            }
            if (n2 == 0) {
                return false;
            }
            if (n2 != nArray.length) {
                nArray = Arrays.copyOf(nArray, n2);
                objectArray = Arrays.copyOf(objectArray, n2);
            }
            AbstractMap.SimpleEntry[] simpleEntryArray = new AbstractMap.SimpleEntry[n2];
            n = n2;
            while (--n >= 0) {
                simpleEntryArray[n] = new AbstractMap.SimpleEntry<Integer, Object>(nArray[n], objectArray[n]);
            }
            Arrays.sort(simpleEntryArray, this);
            n = n2;
            while (--n >= 0) {
                nArray[n] = (Integer)simpleEntryArray[n].getKey();
                objectArray[n] = simpleEntryArray[n].getValue();
            }
            this.viewIndices = nArray;
            this.viewNodes = objectArray;
            return true;
        }
    }

    protected class Adapter
    extends AbstractTableModel
    implements TreeTableModel,
    TreeModelListener,
    TreeColumnModelListener,
    ListSelectionModel,
    PropertyChangeListener,
    TreeTableSorterListener,
    TreeExpansionListener,
    TreeSelectionListener,
    TreeWillExpandListener,
    ToolTipMap<TreeTable> {
        protected TreeModel treeModel;
        protected TreeColumnModel treeColumnModel;
        protected Object treeRoot;
        private TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> rowSorter;
        private boolean ignoreSortedChange = false;

        Adapter() {
        }

        public Adapter(TreeModel treeModel, TreeColumnModel treeColumnModel) {
            this.treeModel = treeModel;
            this.treeColumnModel = treeColumnModel;
            this.treeRoot = treeModel.getRoot();
            treeModel.addTreeModelListener(this);
            treeColumnModel.addTreeColumnModelListener(this);
        }

        public void setTreeModel(TreeModel treeModel) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener(this);
            }
            this.treeModel = treeModel;
            if (this.treeModel != null) {
                this.treeModel.addTreeModelListener(this);
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this.treeModel, new TreePath(this.treeModel.getRoot()));
                this.treeStructureChanged(treeModelEvent);
            }
        }

        public void setRowSorter(TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> treeTableSorter) {
            if (this.rowSorter != null) {
                this.rowSorter.removeTreeTableSorterListener(this);
            }
            this.rowSorter = treeTableSorter;
            if (treeTableSorter != null) {
                treeTableSorter.addTreeTableSorterListener(this);
            }
        }

        @Override
        public int getColumnCount() {
            return this.treeColumnModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.treeColumnModel.getColumnName(n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.treeColumnModel.getColumnClass(n);
        }

        @Override
        public int getRowCount() {
            return TreeTable.this.tree.getRowCount();
        }

        public Object getNode(int n) {
            return TreeTable.this.getPathForRow(n).getLastPathComponent();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.treeColumnModel.getValueAt(this.getNode(n), n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.treeColumnModel.setValueAt(object, this.getNode(n), n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.treeColumnModel.isCellEditable(this.getNode(n), n2);
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            if (TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights();
            }
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
            if (TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeColumnChanged(TreeColumnModelEvent treeColumnModelEvent) {
            int n;
            TreePath treePath = treeColumnModelEvent.getTreePath();
            if (this.rowSorter != null) {
                RowSorter<? extends TreeModel> rowSorter;
                RowSorter<? extends TreeModel> rowSorter2 = rowSorter = treePath.getParentPath() != null ? this.rowSorter.getRowSorter(treePath.getParentPath().getLastPathComponent()) : null;
                if (rowSorter != null && treePath.getParentPath() != null) {
                    boolean bl = this.ignoreSortedChange;
                    this.ignoreSortedChange = true;
                    try {
                        Object object = treePath.getParentPath().getLastPathComponent();
                        Object object2 = treePath.getLastPathComponent();
                        int n2 = this.treeModel.getIndexOfChild(object, object2);
                        int n3 = rowSorter.convertRowIndexToView(n2);
                        rowSorter.rowsUpdated(n2, n2);
                        if (rowSorter.convertRowIndexToView(n2) != n3) {
                            if (TreeTable.this.isExpanded(treePath)) {
                                this.updatePath(treePath, this.expandedDescendants(treePath));
                            } else {
                                this.fireTreeStructureChanged(treePath);
                            }
                            return;
                        }
                    }
                    finally {
                        this.ignoreSortedChange = bl;
                    }
                }
            }
            if ((n = TreeTable.this.getRowForPath(treePath)) < 0) {
                return;
            }
            if (treeColumnModelEvent.getColumn() == -1) {
                this.fireTableRowsUpdated(n, n);
            } else {
                this.fireTableCellUpdated(n, treeColumnModelEvent.getColumn());
            }
            if (TreeTable.this.getRowHeight() <= 0) {
                this.invalidatePath(treeColumnModelEvent.getTreePath());
                TreeTable.this.updateTableRowHeights(n, n + 1);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            int[] nArray = treeModelEvent.getChildIndices();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray == null) {
                this.fireTreeNodesChanged(treePath, nArray, objectArray);
                if (TreeTable.this.isRootVisible()) {
                    this.updateTable(0, 0, 0);
                }
            } else {
                this.processTreeNodesChanged(treePath, nArray, objectArray);
                this.updateTable(treePath, this.getRows(treePath, objectArray), 0);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            int[] nArray = treeModelEvent.getChildIndices();
            Object[] objectArray = treeModelEvent.getChildren();
            if (nArray == null || objectArray == null) {
                return;
            }
            this.processTreeNodesInserted(treePath, nArray, objectArray);
            this.updateTable(treePath, this.getRows(treePath, objectArray), 1);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            int[] nArray = treeModelEvent.getChildIndices();
            Object[] objectArray = treeModelEvent.getChildren();
            if (nArray == null || objectArray == null) {
                return;
            }
            int[] nArray2 = this.getRows(treePath, objectArray);
            this.processTreeNodesRemoved(treePath, nArray, objectArray);
            this.updateTable(treePath, nArray2, -1);
        }

        private int[] getRows(TreePath treePath, Object[] objectArray) {
            if (!TreeTable.this.isExpanded(treePath)) {
                return null;
            }
            if (treePath.getPathCount() > 1 && TreeTable.this.getRowForPath(treePath) < 0) {
                return null;
            }
            int[] nArray = new int[objectArray.length];
            int n = 0;
            for (Object object : objectArray) {
                TreePath treePath2 = treePath.pathByAddingChild(object);
                int n2 = TreeTable.this.getRowForPath(treePath2);
                if (n2 < 0) continue;
                nArray[n++] = n2;
            }
            if (n == 0) {
                return null;
            }
            if (n != nArray.length) {
                nArray = Arrays.copyOf(nArray, n);
            }
            return nArray;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            boolean bl = false;
            if (treePath.getPathCount() == 1 && treePath.getLastPathComponent() != this.treeRoot) {
                bl = true;
                this.treeRoot = treePath.getLastPathComponent();
            }
            if (this.rowSorter != null) {
                this.rowSorter.structureChanged(treePath, bl);
            }
            this.fireTreeStructureChanged(treePath);
            if (bl) {
                this.fireTableStructureChanged();
            } else if (TreeTable.this.isExpanded(treePath)) {
                this.fireTableDataChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(treePath.getLastPathComponent())) != null) {
                boolean bl = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (nArray.length == 1) {
                        int n = nArray[0];
                        int n2 = rowSorter.convertRowIndexToView(n);
                        rowSorter.rowsUpdated(n, n);
                        nArray[0] = rowSorter.convertRowIndexToView(n);
                        if (nArray[0] == n2) {
                            if (n2 >= 0) {
                                this.fireTreeNodesChanged(treePath, nArray, objectArray);
                            }
                            return;
                        }
                    } else {
                        SorterHelper sorterHelper = new SorterHelper(rowSorter, nArray, objectArray);
                        int[] nArray2 = null;
                        Object[] objectArray2 = null;
                        if (sorterHelper.computeView()) {
                            nArray2 = sorterHelper.viewIndices;
                            objectArray2 = sorterHelper.viewNodes;
                        }
                        rowSorter.rowsUpdated(nArray[0], nArray[nArray.length - 1]);
                        if (sorterHelper.computeView()) {
                            if (Arrays.equals(nArray2, sorterHelper.viewIndices) && Arrays.equals(objectArray2, sorterHelper.viewNodes)) {
                                this.fireTreeNodesChanged(treePath, nArray2, objectArray2);
                                return;
                            }
                        } else if (nArray2 == null) {
                            return;
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = bl;
                }
                this.updatePath(treePath, this.expandedDescendants(treePath));
                return;
            }
            this.fireTreeNodesChanged(treePath, nArray, objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesInserted(TreePath treePath, int[] nArray, Object[] objectArray) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(treePath.getLastPathComponent())) != null) {
                boolean bl = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (nArray.length == 1) {
                        int n = nArray[0];
                        rowSorter.rowsInserted(n, n);
                        nArray[0] = rowSorter.convertRowIndexToView(n);
                        if (nArray[0] >= 0) {
                            this.fireTreeNodesInserted(treePath, nArray, objectArray);
                        }
                    } else {
                        SorterHelper sorterHelper = new SorterHelper(rowSorter, nArray, objectArray);
                        if (sorterHelper.useAllChanged()) {
                            rowSorter.allRowsChanged();
                        } else {
                            rowSorter.rowsInserted(sorterHelper.firstRow, sorterHelper.lastRow);
                        }
                        if (sorterHelper.computeView()) {
                            this.fireTreeNodesInserted(treePath, sorterHelper.viewIndices, sorterHelper.viewNodes);
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = bl;
                }
                return;
            }
            this.fireTreeNodesInserted(treePath, nArray, objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTreeNodesRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(treePath.getLastPathComponent())) != null) {
                boolean bl = this.ignoreSortedChange;
                this.ignoreSortedChange = true;
                try {
                    if (nArray.length == 1) {
                        int n = nArray[0];
                        nArray[0] = rowSorter.convertRowIndexToView(n);
                        if (nArray[0] >= 0) {
                            this.fireTreeNodesRemoved(treePath, nArray, objectArray);
                        }
                        rowSorter.rowsDeleted(n, n);
                    } else {
                        SorterHelper sorterHelper = new SorterHelper(rowSorter, nArray, objectArray);
                        if (sorterHelper.computeView()) {
                            this.fireTreeNodesRemoved(treePath, sorterHelper.viewIndices, sorterHelper.viewNodes);
                        }
                        if (sorterHelper.useAllChanged()) {
                            rowSorter.allRowsChanged();
                        } else {
                            rowSorter.rowsDeleted(sorterHelper.firstRow, sorterHelper.lastRow);
                        }
                    }
                }
                finally {
                    this.ignoreSortedChange = bl;
                }
                this.rowSorter.nodesRemoved(treePath, objectArray);
                return;
            }
            this.fireTreeNodesRemoved(treePath, nArray, objectArray);
        }

        private void updateTable(TreePath treePath, int[] nArray, int n) {
            if (nArray == null) {
                return;
            }
            int n2 = nArray.length;
            if (n2 == 1) {
                this.updateTable(nArray[0], nArray[0], n);
            } else {
                int n3;
                int n4;
                Arrays.sort(nArray, 0, n2);
                if (n == -1) {
                    n4 = nArray[n2 - 1];
                    n3 = nArray[n2 - 1];
                    int n5 = n2 - 1;
                    while (--n5 >= 0) {
                        int n6 = nArray[n5];
                        if (n6 == n4 - 1) {
                            n4 = n6;
                            continue;
                        }
                        this.updateTable(n4, n3, n);
                        n4 = n3 = n6;
                    }
                } else {
                    n4 = nArray[0];
                    n3 = nArray[0];
                    for (int i = 1; i < n2; ++i) {
                        int n7 = nArray[i];
                        if (n7 == n3 + 1) {
                            n3 = n7;
                            continue;
                        }
                        this.updateTable(n4, n3, n);
                        n3 = n4 = n7;
                    }
                }
                this.updateTable(n4, n3, n);
            }
        }

        private void updateTable(int n, int n2, int n3) {
            this.fireTableChanged(new TableModelEvent(this, n, n2, -1, n3));
            if (n3 != -1 && TreeTable.this.getRowHeight() <= 0) {
                TreeTable.this.updateTableRowHeights(n, n2 + 1);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeTable.this.fireTreeExpansionEvent(treeExpansionEvent.getPath(), true);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreeTable.this.fireTreeExpansionEvent(treeExpansionEvent.getPath(), false);
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeTable.this.fireTreeWillExpandEvent(treeExpansionEvent.getPath(), true);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreeTable.this.fireTreeWillExpandEvent(treeExpansionEvent.getPath(), false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("leadSelectionPath") || string.equals("anchorSelectionPath")) {
                int n = !TreeTable.this.isColumnFocusEnabled() ? -1 : TreeTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                TreeTable.this.repaint((TreePath)propertyChangeEvent.getOldValue(), n);
                TreeTable.this.repaint((TreePath)propertyChangeEvent.getNewValue(), n);
            } else if (string.equals("rowHeight") ? propertyChangeEvent.getSource() != TreeTable.this.tree : string.equals("componentOrientation") || string.equals("enabled") || string.equals("rowSorter") || string.equals("model")) {
                return;
            }
            TreeTable.this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        @Override
        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.add(ListSelectionListener.class, listSelectionListener);
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
        }

        @Override
        public void addSelectionInterval(int n, int n2) {
            TreeTable.this.tree.addSelectionInterval(n, n2);
        }

        @Override
        public void clearSelection() {
            TreeTable.this.getSelectionModel().clearSelection();
        }

        @Override
        public int getAnchorSelectionIndex() {
            return TreeTable.this.getRowForPath(TreeTable.this.getAnchorSelectionPath());
        }

        @Override
        public int getLeadSelectionIndex() {
            return TreeTable.this.getRowForPath(TreeTable.this.getLeadSelectionPath());
        }

        @Override
        public int getMaxSelectionIndex() {
            return TreeTable.this.getSelectionModel().getMaxSelectionRow();
        }

        @Override
        public int getMinSelectionIndex() {
            return TreeTable.this.getSelectionModel().getMinSelectionRow();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void insertIndexInterval(int n, int n2, boolean bl) {
        }

        @Override
        public boolean isSelectedIndex(int n) {
            return TreeTable.this.getSelectionModel().isRowSelected(n);
        }

        @Override
        public boolean isSelectionEmpty() {
            return TreeTable.this.getSelectionModel().isSelectionEmpty();
        }

        @Override
        public void removeIndexInterval(int n, int n2) {
        }

        @Override
        public void removeSelectionInterval(int n, int n2) {
            TreePath treePath = TreeTable.this.getAnchorSelectionPath();
            TreeTable.this.tree.removeSelectionInterval(n, n2);
            TreeTable.this.setAnchorSelectionPath(treePath);
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(n2));
        }

        @Override
        public void setAnchorSelectionIndex(int n) {
            TreeTable.this.setAnchorSelectionPath(TreeTable.this.getPathForRow(n));
        }

        @Override
        public void setLeadSelectionIndex(int n) {
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(n));
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            TreeTable.this.setSelectionInterval(n, n2);
            TreeTable.this.setAnchorSelectionPath(TreeTable.this.getPathForRow(n));
            TreeTable.this.setLeadSelectionPath(TreeTable.this.getPathForRow(n2));
        }

        @Override
        public int getSelectionMode() {
            switch (TreeTable.this.getSelectionModel().getSelectionMode()) {
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 1: {
                    return 0;
                }
            }
            return 2;
        }

        @Override
        public void setSelectionMode(int n) {
            switch (n) {
                default: {
                    return;
                }
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 4;
                }
            }
            TreeTable.this.getSelectionModel().setSelectionMode(n);
        }

        @Override
        public void setValueIsAdjusting(boolean bl) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            int n = TreeTable.this.getRowForPath(treeSelectionEvent.getNewLeadSelectionPath());
            int n2 = TreeTable.this.getRowForPath(treeSelectionEvent.getOldLeadSelectionPath());
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            TreePath[] treePathArray = treeSelectionEvent.getPaths();
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    int n5 = TreeTable.this.getRowForPath(treePath);
                    n3 = Math.min(n3, n5);
                    n4 = Math.max(n4, n5);
                }
            }
            this.fireSelectionChanged(n3, n4);
        }

        private void fireSelectionChanged(int n, int n2) {
            ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n2, false);
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ListSelectionListener.class) continue;
                ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(TreeModelListener.class, treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(TreeModelListener.class, treeModelListener);
        }

        @Override
        public int getChildCount(Object object) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(object)) != null) {
                return rowSorter.getViewRowCount();
            }
            return this.treeModel.getChildCount(object);
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.treeModel.getChild(object, this.convertIndexToModel(object, n));
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            int n = this.treeModel.getIndexOfChild(object, object2);
            if (n < 0) {
                return n;
            }
            return this.convertIndexToView(object, n);
        }

        @Override
        public Object getRoot() {
            return this.treeRoot;
        }

        @Override
        public boolean isLeaf(Object object) {
            return this.treeModel.isLeaf(object);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
            this.treeModel.valueForPathChanged(treePath, object);
        }

        public int convertIndexToModel(Object object, int n) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(object)) != null) {
                return rowSorter.convertRowIndexToModel(n);
            }
            return n;
        }

        public int convertIndexToView(Object object, int n) {
            RowSorter<? extends TreeModel> rowSorter;
            if (this.rowSorter != null && (rowSorter = this.rowSorter.getRowSorter(object)) != null) {
                return rowSorter.convertRowIndexToView(n);
            }
            return n;
        }

        public void invalidateRows(int n, int n2) {
            if (n == n2) {
                this.invalidatePath(TreeTable.this.getPathForRow(n));
            } else {
                HashMap<TreePath, ArrayList<Object>> hashMap = new HashMap<TreePath, ArrayList<Object>>();
                int n3 = n;
                TreePath treePath = TreeTable.this.getPathForRow(n3);
                TreePath treePath2 = treePath.getParentPath();
                if (treePath2 == null) {
                    this.invalidatePaths(treePath, null, null);
                    treePath = TreeTable.this.getPathForRow(++n3);
                    treePath2 = treePath.getParentPath();
                }
                while (true) {
                    Object object;
                    if ((object = (ArrayList<Object>)hashMap.get(treePath2)) == null) {
                        object = new ArrayList<Object>();
                        hashMap.put(treePath2, (ArrayList<Object>)object);
                    }
                    ((ArrayList)object).add(treePath.getLastPathComponent());
                    if (++n3 > n2) break;
                    treePath = TreeTable.this.getPathForRow(n3);
                    treePath2 = treePath.getParentPath();
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    Object object = ((TreePath)entry.getKey()).getLastPathComponent();
                    Object[] objectArray = ((ArrayList)entry.getValue()).toArray();
                    int[] nArray = new int[objectArray.length];
                    int n4 = objectArray.length;
                    while (--n4 >= 0) {
                        nArray[n4] = this.getIndexOfChild(object, objectArray[n4]);
                    }
                    this.invalidatePaths((TreePath)entry.getKey(), nArray, objectArray);
                }
            }
        }

        void _invalidateRows(int n, int n2) {
            for (int i = n2; i >= n; --i) {
                this.invalidatePath(TreeTable.this.getPathForRow(i));
            }
        }

        public void invalidatePath(TreePath treePath) {
            Object[] objectArray;
            int[] nArray;
            if (treePath.getParentPath() == null) {
                nArray = null;
                objectArray = null;
            } else {
                Object object = treePath.getLastPathComponent();
                Object object2 = (treePath = treePath.getParentPath()).getLastPathComponent();
                int n = this.getIndexOfChild(object2, object);
                if (n < 0) {
                    return;
                }
                nArray = new int[]{n};
                objectArray = new Object[]{object};
            }
            this.invalidatePaths(treePath, nArray, objectArray);
        }

        public void invalidatePaths(TreePath treePath, int[] nArray, Object[] objectArray) {
            this.fireTreeNodesChanged(treePath, nArray, objectArray);
        }

        protected void fireTreeNodesChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
            AbstractTreeModel.fireNodesChanged(this.listenerList, this, treePath, nArray, objectArray);
        }

        protected void fireTreeNodesInserted(TreePath treePath, int[] nArray, Object[] objectArray) {
            AbstractTreeModel.fireNodesInserted(this.listenerList, this, treePath, nArray, objectArray);
        }

        protected void fireTreeNodesRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
            AbstractTreeModel.fireNodesRemoved(this.listenerList, this, treePath, nArray, objectArray);
        }

        protected void fireTreeStructureChanged(TreePath treePath) {
            AbstractTreeModel.fireTreeStructureChanged(this.listenerList, this, treePath);
        }

        @Override
        public void sorterChanged(TreeTableSorterEvent treeTableSorterEvent) {
            switch (treeTableSorterEvent.getType()) {
                case SORT_ORDER_CHANGED: {
                    JTableHeader jTableHeader = TreeTable.this.getTableHeader();
                    if (jTableHeader == null) break;
                    jTableHeader.repaint();
                    break;
                }
                case SORTED: {
                    TreePath treePath = new TreePath(this.treeRoot);
                    this.updatePath(treePath, this.expandedDescendants(treePath));
                    if (TreeTable.this.getRowHeight() > 0) break;
                    TreeTable.this.updateTableRowHeights();
                    break;
                }
                case NODE_SORTED: {
                    this.nodeSorted(treeTableSorterEvent.getTreePath());
                }
            }
        }

        private void nodeSorted(TreePath treePath) {
            if (!this.ignoreSortedChange) {
                RowSorter<? extends TreeModel> rowSorter = this.rowSorter.getRowSorter(treePath.getLastPathComponent());
                RowSorter.SortKey sortKey = rowSorter.getSortKeys().get(0);
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) {
                    TreeTable.this.sortedPaths.remove(treePath);
                } else {
                    TreeTable.this.sortedPaths.put(treePath, sortKey);
                }
                this.updatePath(treePath, this.expandedDescendants(treePath));
                if (TreeTable.this.getExpandsSortedNodes() && !TreeTable.this.isExpanded(treePath)) {
                    TreeTable.this.expandPath(treePath);
                }
            }
        }

        private List<TreePath> expandedDescendants(TreePath treePath) {
            Enumeration<TreePath> enumeration = TreeTable.this.getExpandedDescendants(treePath);
            return enumeration == null ? Collections.emptyList() : Collections.list(enumeration);
        }

        void updatePath(TreePath treePath, List<TreePath> list) {
            TreePath[] treePathArray;
            block3: {
                block2: {
                    treePathArray = TreeTable.this.getSelectionPaths();
                    int n = TreeTable.this.getRowForPath(treePath);
                    int n2 = this.getRowCount();
                    this.fireTreeStructureChanged(treePath);
                    int n3 = this.getRowCount();
                    if (n3 != n2) break block2;
                    int n4 = this.getChildCount(treePath.getLastPathComponent());
                    if (n4 <= 0) break block3;
                    this.fireTableRowsUpdated(n + 1, n + n4);
                    if (TreeTable.this.getRowHeight() > 0) break block3;
                    TreeTable.this.updateTableRowHeights(n + 1, n + n4 + 1);
                    break block3;
                }
                this.fireTableDataChanged();
                if (TreeTable.this.getRowHeight() <= 0) {
                    TreeTable.this.updateTableRowHeights();
                }
                for (TreePath treePath2 : list) {
                    TreeTable.this.expandPath(treePath2);
                }
            }
            TreeTable.this.setSelectionPaths(treePathArray);
        }

        void updateSorter(TreePath treePath, boolean bl) {
            if (this.rowSorter != null) {
                List<TreePath> list = bl ? this.expandedDescendants(treePath) : Collections.emptyList();
                this.rowSorter.setVisible(treePath, list, bl);
                if (bl) {
                    this.updatePath(treePath, list);
                }
            }
        }

        RowSorter<?> getSorter(TreePath treePath) {
            return this.rowSorter == null ? null : this.rowSorter.getRowSorter(treePath);
        }

        @Override
        public String getToolTipText(TreeTable treeTable, MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = treeTable.rowAtPoint(point);
            int n2 = treeTable.columnAtPoint(point);
            String string = null;
            if (n >= 0 && n2 >= 0) {
                TreeTableCellRenderer treeTableCellRenderer = treeTable.getCellRenderer(n, n2);
                boolean bl = treeTable.isCellSelected(n, n2);
                boolean bl2 = treeTable.isColumnFocusEnabled() && n2 == treeTable.getLeadSelectionColumn() && n == treeTable.getLeadSelectionRow() && treeTable.isFocusOwner();
                Component component = treeTableCellRenderer.getTreeTableCellRendererComponent(treeTable, treeTable.getValueAt(n, n2), bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    Rectangle rectangle = treeTable.getCellRect(n, n2, false);
                    point.translate(-rectangle.x, -rectangle.y);
                    MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                    string = ((JComponent)component).getToolTipText(mouseEvent2);
                }
            }
            if (string == null) {
                string = treeTable.getToolTipText();
            }
            return string;
        }
    }
}

