/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.csr.spkac;

import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.kse.crypto.x509.KseX500NameStyle;

public class SpkacSubject {
    public static final String CN_PROPERTY = "CN";
    public static final String OU_PROPERTY = "OU";
    public static final String O_PROPERTY = "O";
    public static final String L_PROPERTY = "L";
    public static final String ST_PROPERTY = "ST";
    public static final String C_PROPERTY = "C";
    private String cn;
    private String ou;
    private String o;
    private String l;
    private String st;
    private String c;

    public SpkacSubject(String cn, String ou, String o, String l, String st, String c) {
        this.cn = cn;
        this.ou = ou;
        this.o = o;
        this.l = l;
        this.st = st;
        this.c = c;
    }

    public SpkacSubject(X500Name name) {
        this.cn = this.getRdn(name, BCStyle.CN);
        this.ou = this.getRdn(name, BCStyle.OU);
        this.o = this.getRdn(name, BCStyle.O);
        this.l = this.getRdn(name, BCStyle.L);
        this.st = this.getRdn(name, BCStyle.ST);
        this.c = this.getRdn(name, BCStyle.C);
    }

    private String getRdn(X500Name name, ASN1ObjectIdentifier rdnOid) {
        RDN[] rdns = name.getRDNs(rdnOid);
        if (rdns.length > 0) {
            RDN rdn = rdns[0];
            String value = rdn.getFirst().getValue().toString();
            return value;
        }
        return null;
    }

    public String getCN() {
        return this.cn;
    }

    public String getOU() {
        return this.ou;
    }

    public String getO() {
        return this.o;
    }

    public String getL() {
        return this.l;
    }

    public String getST() {
        return this.st;
    }

    public String getC() {
        return this.c;
    }

    public X500Name getName() {
        X500NameBuilder x500NameBuilder = new X500NameBuilder((X500NameStyle)KseX500NameStyle.INSTANCE);
        if (this.c != null) {
            x500NameBuilder.addRDN(BCStyle.C, this.c);
        }
        if (this.st != null) {
            x500NameBuilder.addRDN(BCStyle.ST, this.st);
        }
        if (this.l != null) {
            x500NameBuilder.addRDN(BCStyle.L, this.l);
        }
        if (this.o != null) {
            x500NameBuilder.addRDN(BCStyle.O, this.o);
        }
        if (this.ou != null) {
            x500NameBuilder.addRDN(BCStyle.OU, this.ou);
        }
        if (this.cn != null) {
            x500NameBuilder.addRDN(BCStyle.CN, this.cn);
        }
        return x500NameBuilder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
        result = 31 * result + (this.cn == null ? 0 : this.cn.hashCode());
        result = 31 * result + (this.l == null ? 0 : this.l.hashCode());
        result = 31 * result + (this.o == null ? 0 : this.o.hashCode());
        result = 31 * result + (this.ou == null ? 0 : this.ou.hashCode());
        result = 31 * result + (this.st == null ? 0 : this.st.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpkacSubject other = (SpkacSubject)obj;
        if (this.c == null ? other.c != null : !this.c.equals(other.c)) {
            return false;
        }
        if (this.cn == null ? other.cn != null : !this.cn.equals(other.cn)) {
            return false;
        }
        if (this.l == null ? other.l != null : !this.l.equals(other.l)) {
            return false;
        }
        if (this.o == null ? other.o != null : !this.o.equals(other.o)) {
            return false;
        }
        if (this.ou == null ? other.ou != null : !this.ou.equals(other.ou)) {
            return false;
        }
        return !(this.st == null ? other.st != null : !this.st.equals(other.st));
    }

    private String formatNameValue(String name, String value) {
        return name + "=" + value;
    }

    public String toString() {
        ArrayList<String> properties = new ArrayList<String>();
        if (this.getCN() != null) {
            properties.add(this.formatNameValue(CN_PROPERTY, this.getCN()));
        }
        if (this.getOU() != null) {
            properties.add(this.formatNameValue(OU_PROPERTY, this.getOU()));
        }
        if (this.getO() != null) {
            properties.add(this.formatNameValue(O_PROPERTY, this.getO()));
        }
        if (this.getL() != null) {
            properties.add(this.formatNameValue(L_PROPERTY, this.getL()));
        }
        if (this.getST() != null) {
            properties.add(this.formatNameValue(ST_PROPERTY, this.getST()));
        }
        if (this.getC() != null) {
            properties.add(this.formatNameValue(C_PROPERTY, this.getC()));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < properties.size(); ++i) {
            sb.append((String)properties.get(i));
            if (i + 1 >= properties.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

