/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.ecc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.kse.crypto.ecc.EccUtil;
import org.kse.crypto.keystore.KeyStoreType;

public enum CurveSet {
    ANSI_X9_62("ANSI X9.62"),
    NIST("NIST"),
    SEC("SEC"),
    TELETRUST("Brainpool");

    private String visibleName;

    private CurveSet(String visibleName) {
        this.visibleName = visibleName;
    }

    public static String[] getAvailableSetNames(KeyStoreType keyStoreType) {
        ArrayList<String> sets = new ArrayList<String>();
        sets.add(CurveSet.ANSI_X9_62.visibleName);
        sets.add(CurveSet.NIST.visibleName);
        sets.add(CurveSet.SEC.visibleName);
        if (EccUtil.isBouncyCastleKeyStore(keyStoreType)) {
            sets.add(CurveSet.TELETRUST.visibleName);
        }
        return sets.toArray(new String[sets.size()]);
    }

    public static List<CurveSet> getAvailableSets(KeyStoreType keyStoreType) {
        ArrayList<CurveSet> sets = new ArrayList<CurveSet>();
        sets.add(ANSI_X9_62);
        sets.add(NIST);
        sets.add(SEC);
        if (EccUtil.isBouncyCastleKeyStore(keyStoreType)) {
            sets.add(TELETRUST);
        }
        return sets;
    }

    public List<String> getAvailableCurveNames(KeyStoreType keyStoreType) {
        List<String> curveNames = this.getAllCurveNames();
        Iterator<String> it = curveNames.iterator();
        while (it.hasNext()) {
            String curveName = it.next();
            if (EccUtil.isCurveAvailable(curveName, keyStoreType)) continue;
            it.remove();
        }
        return curveNames;
    }

    public List<String> getAllCurveNames() {
        Enumeration en = null;
        switch (this) {
            case ANSI_X9_62: {
                en = X962NamedCurves.getNames();
                break;
            }
            case TELETRUST: {
                en = TeleTrusTNamedCurves.getNames();
                break;
            }
            case NIST: {
                en = NISTNamedCurves.getNames();
                break;
            }
            case SEC: {
                en = SECNamedCurves.getNames();
            }
        }
        if (en == null) {
            return new ArrayList<String>();
        }
        return Collections.list(en);
    }

    public static CurveSet resolveName(String curveSetName) {
        if (curveSetName == null) {
            return null;
        }
        if (curveSetName.equals(CurveSet.SEC.visibleName)) {
            return SEC;
        }
        if (curveSetName.equals(CurveSet.NIST.visibleName)) {
            return NIST;
        }
        if (curveSetName.equals(CurveSet.ANSI_X9_62.visibleName)) {
            return ANSI_X9_62;
        }
        if (curveSetName.equals(CurveSet.TELETRUST.visibleName)) {
            return TELETRUST;
        }
        return null;
    }

    public String getVisibleName() {
        return this.visibleName;
    }
}

