/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.keypair;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.kse.crypto.CryptoException;
import org.kse.crypto.KeyInfo;
import org.kse.crypto.KeyType;
import org.kse.crypto.SecurityProvider;
import org.kse.crypto.keypair.KeyPairType;

public final class KeyPairUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/keypair/resources");

    private KeyPairUtil() {
    }

    public static KeyPair generateKeyPair(KeyPairType keyPairType, int keySize, Provider provider) throws CryptoException {
        try {
            KeyPairGenerator keyPairGen = null;
            keyPairGen = provider != null ? KeyPairGenerator.getInstance(keyPairType.jce(), provider) : (keyPairType == KeyPairType.RSA ? KeyPairGenerator.getInstance(keyPairType.jce(), SecurityProvider.BOUNCY_CASTLE.jce()) : KeyPairGenerator.getInstance(keyPairType.jce()));
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            keyPairGen.initialize(keySize, rand);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return keyPair;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoGenerateKeypair.exception.message"), new Object[]{keyPairType}), ex);
        }
    }

    public static KeyPair generateECKeyPair(String curveName, Provider provider) throws CryptoException {
        try {
            KeyPairGenerator keyPairGen = provider != null ? KeyPairGenerator.getInstance(KeyPairType.EC.jce(), provider) : KeyPairGenerator.getInstance(KeyPairType.EC.jce(), SecurityProvider.BOUNCY_CASTLE.jce());
            keyPairGen.initialize(new ECGenParameterSpec(curveName), SecureRandom.getInstance("SHA1PRNG"));
            KeyPair keyPair = keyPairGen.generateKeyPair();
            return keyPair;
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(MessageFormat.format(res.getString("NoGenerateKeypair.exception.message"), new Object[]{KeyPairType.EC}), ex);
        }
    }

    public static boolean isSunMSCAPI(Provider provider) {
        Class<?> sunMSCAPI = null;
        try {
            sunMSCAPI = Class.forName("sun.security.mscapi.SunMSCAPI");
        }
        catch (Exception e) {
            return false;
        }
        if (sunMSCAPI == null) {
            return false;
        }
        return sunMSCAPI.isInstance(provider);
    }

    public static boolean isSunJCE(Provider provider) {
        Class<?> sunJCE = null;
        try {
            sunJCE = Class.forName("com.sun.crypto.provider.SunJCE");
        }
        catch (Exception e) {
            return false;
        }
        if (sunJCE == null) {
            return false;
        }
        return sunJCE.isInstance(provider);
    }

    public static KeyInfo getKeyInfo(PublicKey publicKey) throws CryptoException {
        try {
            String algorithm = publicKey.getAlgorithm();
            if (algorithm.equals(KeyPairType.RSA.jce())) {
                KeyFactory keyFact = KeyFactory.getInstance(algorithm, SecurityProvider.BOUNCY_CASTLE.jce());
                RSAPublicKeySpec keySpec = keyFact.getKeySpec(publicKey, RSAPublicKeySpec.class);
                BigInteger modulus = keySpec.getModulus();
                BigInteger exponent = keySpec.getPublicExponent();
                if (exponent.intValue() < 65537) {
                    return new KeyInfo(KeyType.ASYMMETRIC, algorithm, modulus.toString(2).length(), algorithm.toUpperCase() + modulus.toString(2).length());
                }
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, modulus.toString(2).length(), algorithm.toLowerCase() + modulus.toString(2).length());
            }
            if (algorithm.equals(KeyPairType.DSA.jce())) {
                KeyFactory keyFact = KeyFactory.getInstance(algorithm);
                DSAPublicKeySpec keySpec = keyFact.getKeySpec(publicKey, DSAPublicKeySpec.class);
                BigInteger prime = keySpec.getP();
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, prime.toString(2).length(), algorithm.toUpperCase() + prime.toString(2).length());
            }
            if (algorithm.equals(KeyPairType.EC.jce())) {
                ECPublicKey pubk = (ECPublicKey)publicKey;
                ECParameterSpec spec = pubk.getParams();
                int size = spec.getOrder().bitLength();
                if (spec instanceof ECNamedCurveSpec) {
                    return new KeyInfo(KeyType.ASYMMETRIC, algorithm, size, ((ECNamedCurveSpec)spec).getName());
                }
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, size);
            }
            return new KeyInfo(KeyType.ASYMMETRIC, algorithm);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoPublicKeysize.exception.message"), ex);
        }
    }

    public static KeyInfo getKeyInfo(PrivateKey privateKey) throws CryptoException {
        try {
            String algorithm = privateKey.getAlgorithm();
            if (algorithm.equals(KeyPairType.RSA.jce())) {
                if (privateKey instanceof RSAPrivateKey) {
                    KeyFactory keyFact = KeyFactory.getInstance(algorithm, SecurityProvider.BOUNCY_CASTLE.jce());
                    RSAPrivateKeySpec keySpec = keyFact.getKeySpec(privateKey, RSAPrivateKeySpec.class);
                    BigInteger modulus = keySpec.getModulus();
                    return new KeyInfo(KeyType.ASYMMETRIC, algorithm, modulus.toString(2).length());
                }
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, 0);
            }
            if (algorithm.equals(KeyPairType.DSA.jce())) {
                KeyFactory keyFact = KeyFactory.getInstance(algorithm);
                DSAPrivateKeySpec keySpec = keyFact.getKeySpec(privateKey, DSAPrivateKeySpec.class);
                BigInteger prime = keySpec.getP();
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, prime.toString(2).length());
            }
            if (algorithm.equals(KeyPairType.EC.jce()) || algorithm.equals(KeyPairType.ECDSA.jce())) {
                ECPrivateKey pubk = (ECPrivateKey)privateKey;
                ECParameterSpec spec = pubk.getParams();
                int size = spec.getOrder().bitLength();
                if (spec instanceof ECNamedCurveSpec) {
                    return new KeyInfo(KeyType.ASYMMETRIC, algorithm, size, ((ECNamedCurveSpec)spec).getName());
                }
                return new KeyInfo(KeyType.ASYMMETRIC, algorithm, size);
            }
            return new KeyInfo(KeyType.ASYMMETRIC, algorithm);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoPrivateKeysize.exception.message"), ex);
        }
    }

    public static KeyPairType getKeyPairType(PrivateKey privateKey) {
        return KeyPairType.resolveJce(privateKey.getAlgorithm());
    }

    public static boolean validKeyPair(PrivateKey privateKey, PublicKey publicKey) throws CryptoException {
        try {
            String privateAlgorithm = privateKey.getAlgorithm();
            String publicAlgorithm = publicKey.getAlgorithm();
            if (!(privateAlgorithm.equals(publicAlgorithm) || privateAlgorithm.equals(KeyPairType.ECDSA.jce()) && publicAlgorithm.equals(KeyPairType.EC.jce()))) {
                return false;
            }
            if (privateAlgorithm.equals(KeyPairType.RSA.jce())) {
                byte[] toSign = "Rivest Shamir Adleman".getBytes();
                String signatureAlgorithm = "SHA256withRSA";
                byte[] signature = KeyPairUtil.sign(toSign, privateKey, signatureAlgorithm);
                return KeyPairUtil.verify(toSign, signature, publicKey, signatureAlgorithm);
            }
            if (privateAlgorithm.equals(KeyPairType.DSA.jce())) {
                byte[] toSign = "Digital Signature Algorithm".getBytes();
                String signatureAlgorithm = "SHA1withDSA";
                byte[] signature = KeyPairUtil.sign(toSign, privateKey, signatureAlgorithm);
                return KeyPairUtil.verify(toSign, signature, publicKey, signatureAlgorithm);
            }
            if (privateAlgorithm.equals(KeyPairType.EC.jce()) || privateAlgorithm.equals(KeyPairType.ECDSA.jce())) {
                byte[] toSign = "EC Digital Signature Algorithm".getBytes();
                String signatureAlgorithm = "SHA256withECDSA";
                byte[] signature = KeyPairUtil.sign(toSign, privateKey, signatureAlgorithm);
                return KeyPairUtil.verify(toSign, signature, publicKey, signatureAlgorithm);
            }
            throw new CryptoException(MessageFormat.format(res.getString("NoCheckCompriseValidKeypairAlg.exception.message"), privateAlgorithm));
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(res.getString("NoCheckCompriseValidKeypair.exception.message"), ex);
        }
    }

    private static byte[] sign(byte[] toSign, PrivateKey privateKey, String signatureAlgorithm) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(signatureAlgorithm, (Provider)new BouncyCastleProvider());
        signature.initSign(privateKey);
        signature.update(toSign);
        return signature.sign();
    }

    private static boolean verify(byte[] signed, byte[] signaureToVerify, PublicKey publicKey, String signatureAlgorithm) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(signatureAlgorithm, (Provider)new BouncyCastleProvider());
        signature.initVerify(publicKey);
        signature.update(signed);
        return signature.verify(signaureToVerify);
    }
}

