/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.publickey;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ResourceBundle;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.kse.crypto.CryptoException;
import org.kse.utilities.pem.PemInfo;
import org.kse.utilities.pem.PemUtil;

public class OpenSslPubUtil {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/publickey/resources");
    private static final String OPENSSL_PUB_PEM_TYPE = "PUBLIC KEY";

    private OpenSslPubUtil() {
    }

    public static byte[] get(PublicKey publicKey) {
        return publicKey.getEncoded();
    }

    public static String getPem(PublicKey publicKey) {
        byte[] openSsl = OpenSslPubUtil.get(publicKey);
        PemInfo pemInfo = new PemInfo(OPENSSL_PUB_PEM_TYPE, null, openSsl);
        String openSslPem = PemUtil.encode(pemInfo);
        return openSslPem;
    }

    public static PublicKey load(byte[] pkData) throws CryptoException, IOException {
        PemInfo pemInfo = PemUtil.decode(pkData);
        if (pemInfo != null) {
            pkData = pemInfo.getContent();
        }
        try {
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)pkData);
            return new JcaPEMKeyConverter().getPublicKey(publicKeyInfo);
        }
        catch (Exception ex) {
            throw new CryptoException(res.getString("NoLoadOpenSslPublicKey.exception.message"), ex);
        }
    }
}

