/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.signing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.bouncycastle.util.encoders.Base64;
import org.kse.crypto.CryptoException;
import org.kse.crypto.signing.SignatureType;
import org.kse.utilities.io.CopyUtil;

public class MidletSigner {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/crypto/signing/resources");
    private static final String CRLF = "\r\n";
    private static final String JAD_ATTR_TEMPLATE = "{0}: {1}";
    private static final String MIDLET_CERTIFICATE_ATTR = "MIDlet-Certificate-{0}-{1}";
    private static final String SUB_MIDLET_CERTIFICATE_ATTR = "MIDlet-Certificate-{0}-";
    private static final String MIDLET_JAR_RSA_SHA1_ATTR = "MIDlet-Jar-RSA-SHA1";

    private MidletSigner() {
    }

    public static void sign(File jadFile, File jarFile, RSAPrivateKey privateKey, X509Certificate[] certificateChain, int certificateNumber) throws IOException, CryptoException {
        File tmpFile = File.createTempFile("kse", "tmp");
        tmpFile.deleteOnExit();
        MidletSigner.sign(jadFile, tmpFile, jarFile, privateKey, certificateChain, certificateNumber);
        CopyUtil.copyClose(new FileInputStream(tmpFile), new FileOutputStream(jadFile));
        tmpFile.delete();
    }

    public static void sign(File jadFile, File outputJadFile, File jarFile, RSAPrivateKey privateKey, X509Certificate[] certificateChain, int certificateNumber) throws IOException, CryptoException {
        Properties jadProperties = MidletSigner.readJadFile(jadFile);
        Properties newJadProperties = new Properties();
        Enumeration<?> enumPropNames = jadProperties.propertyNames();
        while (enumPropNames.hasMoreElements()) {
            String propName = (String)enumPropNames.nextElement();
            if (propName.equals(MIDLET_JAR_RSA_SHA1_ATTR)) continue;
            if (propName.startsWith(MessageFormat.format(SUB_MIDLET_CERTIFICATE_ATTR, certificateNumber))) continue;
            newJadProperties.put(propName, jadProperties.getProperty(propName));
        }
        for (int i = 0; i < certificateChain.length; ++i) {
            X509Certificate certificate = certificateChain[i];
            String base64Cert = null;
            try {
                base64Cert = new String(Base64.encode((byte[])certificate.getEncoded()));
            }
            catch (CertificateEncodingException ex) {
                throw new CryptoException(res.getString("Base64CertificateFailed.exception.message"), ex);
            }
            String midletCertificateAttr = MessageFormat.format(MIDLET_CERTIFICATE_ATTR, certificateNumber, i + 1);
            newJadProperties.put(midletCertificateAttr, base64Cert);
        }
        byte[] signedJarDigest = MidletSigner.signJarDigest(jarFile, privateKey);
        String base64SignedJarDigest = new String(Base64.encode((byte[])signedJarDigest));
        newJadProperties.put(MIDLET_JAR_RSA_SHA1_ATTR, base64SignedJarDigest);
        TreeMap<String, String> sortedJadProperties = new TreeMap<String, String>();
        Enumeration<?> names = newJadProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = newJadProperties.getProperty(name);
            sortedJadProperties.put(name, value);
        }
        try (FileWriter fw = new FileWriter(outputJadFile);){
            for (Map.Entry property : sortedJadProperties.entrySet()) {
                fw.write(MessageFormat.format(JAD_ATTR_TEMPLATE, property.getKey(), property.getValue()));
                fw.write(CRLF);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] signJarDigest(File jarFile, RSAPrivateKey privateKey) throws CryptoException {
        try (FileInputStream fis = new FileInputStream(jarFile);){
            Signature signature = Signature.getInstance(SignatureType.SHA1_RSA.jce());
            signature.initSign(privateKey);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = fis.read(buffer)) != -1) {
                signature.update(buffer, 0, read);
            }
            byte[] byArray = signature.sign();
            return byArray;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new CryptoException(res.getString("JarDigestSignatureFailed.exception.message"), ex);
        }
    }

    /*
     * Exception decompiling
     */
    public static Properties readJadFile(File jadFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

