/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum ExtendedKeyUsageType {
    SERVER_AUTH("1.3.6.1.5.5.7.3.1", "ServerAuthExtKeyUsage"),
    CLIENT_AUTH("1.3.6.1.5.5.7.3.2", "ClientAuthExtKeyUsage"),
    CODE_SIGNING("1.3.6.1.5.5.7.3.3", "CodeSigningExtKeyUsage"),
    DOCUMENT_SIGNING("1.3.6.1.4.1.311.10.3.12", "DocumentSigningExtKeyUsage"),
    ADOBE_PDF_SIGNING("1.2.840.113583.1.1.5", "AdobePDFSigningExtKeyUsage"),
    ENCRYPTED_FILE_SYSTEM("1.3.6.1.4.1.311.10.3.4", "EncryptedFileSystemExtKeyUsage"),
    SMARTCARD_LOGON("1.3.6.1.4.1.311.20.2.2", "SmartcardLogonExtKeyUsage"),
    ANY_EXTENDED_KEY_USAGE("2.5.29.37.0", "AnyExtendedKeyUsageExtKeyUsage"),
    EMAIL_PROTECTION("1.3.6.1.5.5.7.3.4", "EmailProtectionExtKeyUsage"),
    IPSEC_END_SYSTEM("1.3.6.1.5.5.7.3.5", "IpsecEndSystemExtKeyUsage"),
    IPSEC_TUNNEL("1.3.6.1.5.5.7.3.6", "IpsecTunnelExtKeyUsage"),
    IPSEC_USER("1.3.6.1.5.5.7.3.7", "IpsecUserExtKeyUsage"),
    TIME_STAMPING("1.3.6.1.5.5.7.3.8", "TimeStampingExtKeyUsage"),
    OCSP_SIGNING("1.3.6.1.5.5.7.3.9", "OcspSigningExtKeyUsage"),
    MICROSOFT_SGC("1.3.6.1.4.1.311.10.3.3", "MicrosoftSGCExtKeyUsage"),
    NETSCAPE_SGC("2.16.840.1.113730.4.1", "NetscapeSGCExtKeyUsage"),
    VERISIGN_SGC("2.16.840.1.113733.1.8.1", "VeriSignSGCExtKeyUsage"),
    TSL_SIGNING("0.4.0.2231.3.0", "TSLSignExtKeyUsage");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private ExtendedKeyUsageType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String oid() {
        return this.oid;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static ExtendedKeyUsageType resolveOid(String oid) {
        for (ExtendedKeyUsageType extType : ExtendedKeyUsageType.values()) {
            if (!oid.equals(extType.oid())) continue;
            return extType;
        }
        return null;
    }

    public String toString() {
        return this.friendly();
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

