/*
 * Decompiled with CFR 0.152.
 */
package org.kse.crypto.x509;

import java.util.ResourceBundle;

public enum HoldInstructionCodeType {
    NONE("1.2.840.10040.2.1", "HoldInstructionCodeNone"),
    CALL_ISSUER("1.2.840.10040.2.2", "HoldInstructionCodeCallIssuer"),
    CODE_REJECT("1.2.840.10040.2.3", "HoldInstructionCodeReject");

    private static ResourceBundle res;
    private String oid;
    private String friendlyKey;

    private HoldInstructionCodeType(String oid, String friendlyKey) {
        this.oid = oid;
        this.friendlyKey = friendlyKey;
    }

    public String friendly() {
        return res.getString(this.friendlyKey);
    }

    public static HoldInstructionCodeType resolveOid(String oid) {
        for (HoldInstructionCodeType type : HoldInstructionCodeType.values()) {
            if (!oid.equals(type.oid())) continue;
            return type;
        }
        return null;
    }

    public String oid() {
        return this.oid;
    }

    static {
        res = ResourceBundle.getBundle("org/kse/crypto/x509/resources");
    }
}

