/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class CursorUtil {
    private CursorUtil() {
    }

    public static void setCursorBusy(JFrame frame) {
        CursorUtil.setCursorBusy(frame.getRootPane().getGlassPane());
    }

    public static void setCursorFree(JFrame frame) {
        CursorUtil.setCursorFree(frame.getRootPane().getGlassPane());
    }

    public static void setCursorBusy(JComponent component) {
        JDialog dialog = CursorUtil.findContainingDialog(component);
        if (dialog != null) {
            CursorUtil.setCursorBusy(dialog);
        } else {
            JFrame frame = CursorUtil.findContainingFrame(component);
            if (frame != null) {
                CursorUtil.setCursorBusy(frame);
            }
        }
    }

    public static void setCursorFree(JComponent component) {
        JDialog dialog = CursorUtil.findContainingDialog(component);
        if (dialog != null) {
            CursorUtil.setCursorFree(dialog);
        } else {
            JFrame frame = CursorUtil.findContainingFrame(component);
            if (frame != null) {
                CursorUtil.setCursorFree(frame);
            }
        }
    }

    private static JDialog findContainingDialog(JComponent component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JDialog)) continue;
            return (JDialog)container;
        }
        return null;
    }

    private static JFrame findContainingFrame(JComponent component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return null;
    }

    public static void setCursorBusy(JDialog dialog) {
        CursorUtil.setCursorBusy(dialog.getRootPane().getGlassPane());
    }

    public static void setCursorFree(JDialog dialog) {
        CursorUtil.setCursorFree(dialog.getRootPane().getGlassPane());
    }

    private static void setCursorBusy(Component glassPane) {
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.setVisible(true);
        glassPane.setCursor(Cursor.getPredefinedCursor(3));
    }

    private static void setCursorFree(Component glassPane) {
        glassPane.setVisible(false);
        glassPane.setCursor(Cursor.getPredefinedCursor(0));
    }
}

