/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.kse.gui.FileExtFilter;
import org.kse.utilities.os.OperatingSystem;

public class JavaFXFileChooser
extends JFileChooser {
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");
    private static final long serialVersionUID = 706991877631924379L;
    private static Class<?> platformClass;
    private static Class<?> fileChooserClass;
    private static Class<?> extensionFilterClass;
    private static Class<?> windowClass;
    private static boolean fxAvailable;
    private List<FileExtFilter> filters = new ArrayList<FileExtFilter>();
    private File selectedFile;
    private String dialogTitle;
    private File currentDirectory;

    public static boolean isFxAvailable() {
        return fxAvailable;
    }

    @Override
    public void addChoosableFileFilter(FileFilter filter) {
        if (filter instanceof FileExtFilter) {
            this.filters.add((FileExtFilter)filter);
        }
    }

    @Override
    public File getSelectedFile() {
        return this.selectedFile;
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    @Override
    public void setSelectedFile(File file) {
        this.selectedFile = file;
    }

    @Override
    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        return this.showFxDialog("showOpenDialog");
    }

    @Override
    public int showOpenDialog(Component parent) throws HeadlessException {
        return this.showFxDialog("showOpenDialog");
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        return this.showFxDialog("showSaveDialog");
    }

    public int showFxDialog(final String method) {
        try {
            final Object fileChooser = fileChooserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.selectedFile = this.runLater(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    Method getExtensionFiltersMethod = fileChooserClass.getMethod("getExtensionFilters", new Class[0]);
                    List observableList = (List)getExtensionFiltersMethod.invoke(fileChooser, new Object[0]);
                    observableList.add(extensionFilterClass.getConstructor(String.class, String[].class).newInstance(res.getString("JavaFXFileChooser.AllFiles"), new String[]{"*.*"}));
                    for (FileExtFilter fileFilter : JavaFXFileChooser.this.filters) {
                        String[] extensions = fileFilter.getExtensions();
                        for (int i = 0; i < extensions.length; ++i) {
                            if (extensions[i].startsWith("*.")) continue;
                            extensions[i] = "*." + extensions[i];
                        }
                        Object extFilter = extensionFilterClass.getConstructor(String.class, String[].class).newInstance(fileFilter.getDescription(), extensions);
                        observableList.add(extFilter);
                    }
                    Method setTitleMethod = fileChooserClass.getMethod("setTitle", String.class);
                    setTitleMethod.invoke(fileChooser, JavaFXFileChooser.this.dialogTitle);
                    Method setInitialDirectory = fileChooserClass.getMethod("setInitialDirectory", File.class);
                    setInitialDirectory.invoke(fileChooser, JavaFXFileChooser.this.currentDirectory);
                    Method showDialogMethod = fileChooserClass.getMethod(method, windowClass);
                    Object file = showDialogMethod.invoke(fileChooser, new Object[]{null});
                    return (File)file;
                }
            });
        }
        catch (Exception e) {
            return -1;
        }
        if (this.selectedFile == null) {
            return 1;
        }
        return 0;
    }

    public File runLater(Callable<File> callable) throws Exception {
        FutureTask<File> task = new FutureTask<File>(callable);
        Class<?> platformClass = Class.forName("javafx.application.Platform");
        Method runLaterMethod = platformClass.getMethod("runLater", Runnable.class);
        runLaterMethod.invoke(null, task);
        try {
            return task.get();
        }
        catch (ExecutionException ex) {
            throw new Exception(ex.getCause());
        }
    }

    public static void main(String[] args) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!fxAvailable) {
            System.out.println("JavaFX not available");
            System.exit(1);
        }
        JavaFXFileChooser chooser = new JavaFXFileChooser();
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{".jks"}, "Description1"));
        chooser.addChoosableFileFilter(new FileExtFilter(new String[]{".p12"}, "Description2"));
        chooser.setDialogTitle("Dialog Titel");
        chooser.setCurrentDirectory(new File("."));
        chooser.setSelectedFile(new File(""));
        chooser.setMultiSelectionEnabled(false);
        chooser.showDialog(null, "Button Text");
        System.out.println(chooser.getSelectedFile().getAbsolutePath());
        Method platformExitMethod = platformClass.getMethod("exit", new Class[0]);
        platformExitMethod.invoke(null, new Object[0]);
    }

    static {
        fxAvailable = false;
        try {
            if (!OperatingSystem.isMacOs()) {
                Class.forName("javafx.embed.swing.JFXPanel").getConstructor(new Class[0]).newInstance(new Object[0]);
                platformClass = Class.forName("javafx.application.Platform");
                fileChooserClass = Class.forName("javafx.stage.FileChooser");
                extensionFilterClass = Class.forName("javafx.stage.FileChooser$ExtensionFilter");
                windowClass = Class.forName("javafx.stage.Window");
                fxAvailable = true;
            }
        }
        catch (Exception e) {
            fxAvailable = false;
        }
    }
}

