/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui;

import java.awt.Component;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bouncycastle.util.encoders.Hex;
import org.kse.gui.KeyStoreTableModel;
import org.kse.utilities.StringUtils;

public class KeyStoreTableCellRend
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/resources");

    @Override
    public Component getTableCellRendererComponent(JTable jtKeyStore, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JLabel cell = (JLabel)super.getTableCellRendererComponent(jtKeyStore, value, isSelected, hasFocus, row, col);
        if (col == 0) {
            ImageIcon icon = null;
            if (KeyStoreTableModel.KEY_PAIR_ENTRY.equals(value)) {
                icon = new ImageIcon(this.getClass().getResource("images/table/keypair_entry.png"));
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.KeyPairEntry.tooltip"));
            } else if (KeyStoreTableModel.TRUST_CERT_ENTRY.equals(value)) {
                icon = new ImageIcon(this.getClass().getResource("images/table/trustcert_entry.png"));
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.TrustCertEntry.tooltip"));
            } else {
                icon = new ImageIcon(this.getClass().getResource("images/table/key_entry.png"));
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.KeyEntry.tooltip"));
            }
            cell.setIcon(icon);
            cell.setText("");
            cell.setVerticalAlignment(0);
            cell.setHorizontalAlignment(0);
        } else if (col == 1) {
            if (value == null) {
                cell.setIcon(null);
                cell.setText("-");
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.NoLockStatus.tooltip"));
                cell.setHorizontalAlignment(0);
            } else {
                ImageIcon icon = null;
                if (value.equals(Boolean.TRUE)) {
                    icon = new ImageIcon(this.getClass().getResource("images/table/locked_entry.png"));
                    cell.setToolTipText(res.getString("KeyStoreTableCellRend.LockedEntry.tooltip"));
                } else {
                    icon = new ImageIcon(this.getClass().getResource("images/table/unlocked_entry.png"));
                    cell.setToolTipText(res.getString("KeyStoreTableCellRend.UnlockedEntry.tooltip"));
                }
                cell.setIcon(icon);
                cell.setText("");
                cell.setVerticalAlignment(0);
                cell.setHorizontalAlignment(0);
            }
        } else if (col == 2) {
            if (value == null) {
                cell.setIcon(null);
                cell.setText("-");
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.NoCertExpiry.tooltip"));
                cell.setHorizontalAlignment(0);
            } else {
                ImageIcon icon = null;
                if (value.equals(2)) {
                    icon = new ImageIcon(this.getClass().getResource("images/table/cert_expired_entry.png"));
                    cell.setToolTipText(res.getString("KeyStoreTableCellRend.CertExpiredEntry.tooltip"));
                } else if (value.equals(1)) {
                    icon = new ImageIcon(this.getClass().getResource("images/table/cert_old_entry.png"));
                    cell.setToolTipText(res.getString("KeyStoreTableCellRend.CertAlmostExpiredEntry.tooltip"));
                } else {
                    icon = new ImageIcon(this.getClass().getResource("images/table/cert_unexpired_entry.png"));
                    cell.setToolTipText(res.getString("KeyStoreTableCellRend.CertUnexpiredEntry.tooltip"));
                }
                cell.setIcon(icon);
                cell.setText("");
                cell.setVerticalAlignment(0);
                cell.setHorizontalAlignment(0);
            }
        } else {
            return this.writeCell(cell, value);
        }
        return cell;
    }

    private JLabel writeCell(JLabel cell, Object value) {
        try {
            if (value == null) {
                cell.setText("-");
                cell.setToolTipText(res.getString("KeyStoreTableCellRend.Unavailable.tooltip"));
                cell.setHorizontalAlignment(0);
            } else if (value instanceof String) {
                String algorithm = (String)value;
                cell.setText(algorithm);
                cell.setToolTipText(this.getText());
                cell.setHorizontalAlignment(2);
            } else if (value instanceof Integer) {
                if ((Integer)value < 10000 && (Integer)value >= 0) {
                    cell.setText(String.valueOf(value));
                } else {
                    cell.setText("X" + String.format("%x", value));
                }
                cell.setToolTipText(this.getText());
                cell.setHorizontalAlignment(2);
            } else if (value instanceof Date) {
                cell.setText(StringUtils.formatDate((Date)value));
                cell.setToolTipText(this.getText());
                cell.setHorizontalAlignment(2);
            } else if (value instanceof byte[]) {
                cell.setText(Hex.toHexString((byte[])((byte[])value)));
                cell.setToolTipText(this.getText());
                cell.setHorizontalAlignment(2);
            }
        }
        catch (Exception e) {
            cell.setText("?");
            cell.setToolTipText(res.getString("KeyStoreTableCellRend.Format.tooltip"));
            cell.setHorizontalAlignment(0);
        }
        return cell;
    }
}

