/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.about.DEnvironmentVariables;
import org.kse.gui.about.DSystemProperties;

public class DSystemInformation
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/about/resources");
    private static final int TEXT_FIELD_WIDTH = 30;
    private JPanel jpSystemInformation;
    private JLabel jlHostname;
    private JTextField jtfHostname;
    private JLabel jlOperatingSystem;
    private JTextField jtfOperatingSystem;
    private JLabel jlLocale;
    private JTextField jtfLocale;
    private JLabel jlJavaVersion;
    private JTextField jtfJavaVersion;
    private JLabel jlJavaVendor;
    private JTextField jtfJavaVendor;
    private JLabel jlJavaHome;
    private JTextField jtfJavaHome;
    private JLabel jlJvmMaximumMemory;
    private JTextField jtfJvmMaximumMemory;
    private JLabel jlJvmTotalMemory;
    private JTextField jtfJvmTotalMemory;
    private JLabel jlJvmFreeMemory;
    private JTextField jtfJvmFreeMemory;
    private JLabel jlAvailableProcessors;
    private JTextField jtfAvailableProcessors;
    private JPanel jpButtons;
    private JButton jbEnvironmentVariables;
    private JButton jbSystemProperties;
    private JPanel jpOK;
    private JButton jbOK;
    private Thread memoryUpdater;

    public DSystemInformation(JFrame parent) {
        super((Window)parent, res.getString("DSystemInformation.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    public DSystemInformation(JDialog parent, String title, Dialog.ModalityType modality) {
        super((Window)parent, title, modality);
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        Properties sysProps = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.gridwidth = 3;
        gbcLabel.gridheight = 1;
        gbcLabel.insets = new Insets(5, 5, 5, 5);
        gbcLabel.anchor = 13;
        GridBagConstraints gbcTextField = new GridBagConstraints();
        gbcTextField.gridx = 3;
        gbcTextField.gridwidth = 3;
        gbcTextField.gridheight = 1;
        gbcTextField.insets = new Insets(5, 5, 5, 5);
        gbcTextField.anchor = 17;
        this.jpSystemInformation = new JPanel(new GridBagLayout());
        this.jpSystemInformation.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        String hostname = null;
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            String host = localAddr.getCanonicalHostName();
            String address = localAddr.getHostAddress();
            hostname = host.equals(address) ? address : MessageFormat.format(res.getString("DSystemInformation.jtfHostname.text"), host, address);
        }
        catch (UnknownHostException e) {
            hostname = res.getString("DSystemInformation.jtfHostname.unknown.text");
        }
        this.jlHostname = new JLabel(res.getString("DSystemInformation.jlHostname.text"), 4);
        GridBagConstraints gbc_jlHostname = (GridBagConstraints)gbcLabel.clone();
        gbc_jlHostname.gridy = 0;
        this.jpSystemInformation.add((Component)this.jlHostname, gbc_jlHostname);
        this.jtfHostname = new JTextField(hostname, 30);
        this.jtfHostname.setEditable(false);
        this.jtfHostname.setCaretPosition(0);
        GridBagConstraints gbc_jtfHostname = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfHostname.gridy = 0;
        this.jpSystemInformation.add((Component)this.jtfHostname, gbc_jtfHostname);
        this.jlOperatingSystem = new JLabel(res.getString("DSystemInformation.jlOperatingSystem.text"), 4);
        GridBagConstraints gbc_jlOperatingSystem = (GridBagConstraints)gbcLabel.clone();
        gbc_jlOperatingSystem.gridy = 1;
        this.jpSystemInformation.add((Component)this.jlOperatingSystem, gbc_jlOperatingSystem);
        this.jtfOperatingSystem = new JTextField(MessageFormat.format(res.getString("DSystemInformation.jtfOperatingSystem.text"), sysProps.getProperty("os.name", ""), sysProps.getProperty("os.version", ""), sysProps.getProperty("os.arch", "")), 30);
        this.jtfOperatingSystem.setEditable(false);
        this.jtfOperatingSystem.setCaretPosition(0);
        GridBagConstraints gbc_jtfOperatingSystem = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfOperatingSystem.gridy = 1;
        this.jpSystemInformation.add((Component)this.jtfOperatingSystem, gbc_jtfOperatingSystem);
        this.jlLocale = new JLabel(res.getString("DSystemInformation.jlLocale.text"), 4);
        GridBagConstraints gbc_jlLocale = (GridBagConstraints)gbcLabel.clone();
        gbc_jlLocale.gridy = 2;
        this.jpSystemInformation.add((Component)this.jlLocale, gbc_jlLocale);
        this.jtfLocale = new JTextField(Locale.getDefault().getDisplayName(), 30);
        this.jtfLocale.setEditable(false);
        this.jtfLocale.setCaretPosition(0);
        GridBagConstraints gbc_jtfLocale = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfLocale.gridy = 2;
        this.jpSystemInformation.add((Component)this.jtfLocale, gbc_jtfLocale);
        this.jlJavaVersion = new JLabel(res.getString("DSystemInformation.jlJavaVersion.text"), 4);
        GridBagConstraints gbc_jlJavaVersion = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJavaVersion.gridy = 3;
        this.jpSystemInformation.add((Component)this.jlJavaVersion, gbc_jlJavaVersion);
        this.jtfJavaVersion = new JTextField(sysProps.getProperty("java.version", ""), 30);
        this.jtfJavaVersion.setEditable(false);
        this.jtfJavaVersion.setCaretPosition(0);
        GridBagConstraints gbc_jtfJavaVersion = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJavaVersion.gridy = 3;
        this.jpSystemInformation.add((Component)this.jtfJavaVersion, gbc_jtfJavaVersion);
        this.jlJavaVendor = new JLabel(res.getString("DSystemInformation.jlJavaVendor.text"), 4);
        GridBagConstraints gbc_jlJavaVendor = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJavaVendor.gridy = 4;
        this.jpSystemInformation.add((Component)this.jlJavaVendor, gbc_jlJavaVendor);
        this.jtfJavaVendor = new JTextField(MessageFormat.format(res.getString("DSystemInformation.jtfJavaVendor.text"), sysProps.getProperty("java.vendor", ""), sysProps.getProperty("java.vendor.url", "")), 30);
        this.jtfJavaVendor.setEditable(false);
        this.jtfJavaVendor.setCaretPosition(0);
        GridBagConstraints gbc_jtfJavaVendor = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJavaVendor.gridy = 4;
        this.jpSystemInformation.add((Component)this.jtfJavaVendor, gbc_jtfJavaVendor);
        this.jlJavaHome = new JLabel(res.getString("DSystemInformation.jlJavaHome.text"), 4);
        GridBagConstraints gbc_jlJavaHome = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJavaHome.gridy = 5;
        this.jpSystemInformation.add((Component)this.jlJavaHome, gbc_jlJavaHome);
        this.jtfJavaHome = new JTextField(sysProps.getProperty("java.home", ""), 30);
        this.jtfJavaHome.setEditable(false);
        this.jtfJavaHome.setCaretPosition(0);
        GridBagConstraints gbc_jtfJavaHome = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJavaHome.gridy = 5;
        this.jpSystemInformation.add((Component)this.jtfJavaHome, gbc_jtfJavaHome);
        this.jlJvmMaximumMemory = new JLabel(res.getString("DSystemInformation.jlJvmMaximumMemory.text"), 4);
        GridBagConstraints gbc_jlJvmMaximumMemory = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJvmMaximumMemory.gridy = 6;
        this.jpSystemInformation.add((Component)this.jlJvmMaximumMemory, gbc_jlJvmMaximumMemory);
        this.jtfJvmMaximumMemory = new JTextField(30);
        this.jtfJvmMaximumMemory.setEditable(false);
        GridBagConstraints gbc_jtfJvmMaximumMemory = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJvmMaximumMemory.gridy = 6;
        this.jpSystemInformation.add((Component)this.jtfJvmMaximumMemory, gbc_jtfJvmMaximumMemory);
        this.jlJvmTotalMemory = new JLabel(res.getString("DSystemInformation.jlJvmTotalMemory.text"), 4);
        GridBagConstraints gbc_jlJvmTotalMemory = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJvmTotalMemory.gridy = 7;
        this.jpSystemInformation.add((Component)this.jlJvmTotalMemory, gbc_jlJvmTotalMemory);
        this.jtfJvmTotalMemory = new JTextField(30);
        this.jtfJvmTotalMemory.setEditable(false);
        GridBagConstraints gbc_jtfJvmTotalMemory = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJvmTotalMemory.gridy = 7;
        this.jpSystemInformation.add((Component)this.jtfJvmTotalMemory, gbc_jtfJvmTotalMemory);
        this.jlJvmFreeMemory = new JLabel(res.getString("DSystemInformation.jlJvmFreeMemory.text"), 4);
        GridBagConstraints gbc_jlJvmFreeMemory = (GridBagConstraints)gbcLabel.clone();
        gbc_jlJvmFreeMemory.gridy = 8;
        this.jpSystemInformation.add((Component)this.jlJvmFreeMemory, gbc_jlJvmFreeMemory);
        this.jtfJvmFreeMemory = new JTextField(30);
        this.jtfJvmFreeMemory.setEditable(false);
        GridBagConstraints gbc_jtfJvmFreeMemory = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfJvmFreeMemory.gridy = 8;
        this.jpSystemInformation.add((Component)this.jtfJvmFreeMemory, gbc_jtfJvmFreeMemory);
        this.jlAvailableProcessors = new JLabel(res.getString("DSystemInformation.jlAvailableProcessors.text"), 4);
        GridBagConstraints gbc_jlAvailableProcessors = (GridBagConstraints)gbcLabel.clone();
        gbc_jlAvailableProcessors.gridy = 9;
        this.jpSystemInformation.add((Component)this.jlAvailableProcessors, gbc_jlAvailableProcessors);
        this.jtfAvailableProcessors = new JTextField("" + runtime.availableProcessors(), 30);
        this.jtfAvailableProcessors.setEditable(false);
        this.jtfAvailableProcessors.setCaretPosition(0);
        GridBagConstraints gbc_jtfAvailableProcessors = (GridBagConstraints)gbcTextField.clone();
        gbc_jtfAvailableProcessors.gridy = 9;
        this.jpSystemInformation.add((Component)this.jtfAvailableProcessors, gbc_jtfAvailableProcessors);
        this.jbEnvironmentVariables = new JButton(res.getString("DSystemInformation.jbEnvironmentVariables.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbEnvironmentVariables, res.getString("DSystemInformation.jbEnvironmentVariables.mnemonic").charAt(0));
        this.jbEnvironmentVariables.setToolTipText(res.getString("DSystemInformation.jbEnvironmentVariables.tooltip"));
        this.jbEnvironmentVariables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSystemInformation.this);
                    DSystemInformation.this.environmentVariablesPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSystemInformation.this);
                }
            }
        });
        this.jbSystemProperties = new JButton(res.getString("DSystemInformation.jbSystemProperties.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbSystemProperties, res.getString("DSystemInformation.jbSystemProperties.mnemonic").charAt(0));
        this.jbSystemProperties.setToolTipText(res.getString("DSystemInformation.jbSystemProperties.tooltip"));
        this.jbSystemProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DSystemInformation.this);
                    DSystemInformation.this.systemPropertiesPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DSystemInformation.this);
                }
            }
        });
        this.jpButtons = new JPanel(new FlowLayout(1));
        this.jpButtons.add(this.jbEnvironmentVariables);
        this.jpButtons.add(this.jbSystemProperties);
        GridBagConstraints gbc_jpButtons = new GridBagConstraints();
        gbc_jpButtons.gridx = 0;
        gbc_jpButtons.gridy = 10;
        gbc_jpButtons.gridwidth = 6;
        gbc_jpButtons.gridheight = 1;
        gbc_jpButtons.anchor = 13;
        this.jpSystemInformation.add((Component)this.jpButtons, gbc_jpButtons);
        this.jbOK = new JButton(res.getString("DSystemInformation.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSystemInformation.this.okPressed();
            }
        });
        this.jpOK = PlatformUtil.createDialogButtonPanel(this.jbOK);
        this.getContentPane().add((Component)this.jpSystemInformation, "Center");
        this.getContentPane().add((Component)this.jpOK, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DSystemInformation.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        this.startMemoryUpdater();
    }

    private void startMemoryUpdater() {
        this.memoryUpdater = new Thread(new UpdateMemoryFields());
        this.memoryUpdater.setPriority(1);
        this.memoryUpdater.start();
    }

    private void stopMemoryUpdater() {
        if (this.memoryUpdater != null && this.memoryUpdater.isAlive()) {
            this.memoryUpdater.interrupt();
        }
    }

    private void systemPropertiesPressed() {
        DSystemProperties dSystemProperties = new DSystemProperties(this);
        dSystemProperties.setResizable(true);
        dSystemProperties.setLocationRelativeTo(this);
        dSystemProperties.setVisible(true);
    }

    private void environmentVariablesPressed() {
        DEnvironmentVariables dEnvironmentVariables = new DEnvironmentVariables(this);
        dEnvironmentVariables.setResizable(true);
        dEnvironmentVariables.setLocationRelativeTo(this);
        dEnvironmentVariables.setVisible(true);
    }

    private void updateMemoryFields(Runtime runtime) {
        this.jtfJvmMaximumMemory.setText(MessageFormat.format(res.getString("DSystemInformation.jtfJvmMaximumMemory.text"), runtime.maxMemory() / 1024L));
        this.jtfJvmMaximumMemory.setCaretPosition(0);
        this.jtfJvmTotalMemory.setText(MessageFormat.format(res.getString("DSystemInformation.jtfJvmTotalMemory.text"), runtime.totalMemory() / 1024L));
        this.jtfJvmTotalMemory.setCaretPosition(0);
        this.jtfJvmFreeMemory.setText(MessageFormat.format(res.getString("DSystemInformation.jtfJvmFreeMemory.text"), runtime.freeMemory() / 1024L));
        this.jtfJvmFreeMemory.setCaretPosition(0);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.stopMemoryUpdater();
        this.setVisible(false);
        this.dispose();
    }

    private class UpdateMemoryFields
    implements Runnable {
        private UpdateMemoryFields() {
        }

        @Override
        public void run() {
            while (true) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Runtime runtime = Runtime.getRuntime();
                        DSystemInformation.this.updateMemoryFields(runtime);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

