/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.KSE;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DCheckUpdate;
import org.kse.gui.error.DError;
import org.kse.version.Version;
import org.kse.version.VersionException;

public class CheckUpdateAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public CheckUpdateAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("CheckUpdateAction.statusbar"));
        this.putValue("Name", res.getString("CheckUpdateAction.text"));
        this.putValue("ShortDescription", res.getString("CheckUpdateAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/update.png"))));
    }

    @Override
    protected void doAction() {
        DCheckUpdate dCheckUpdate = new DCheckUpdate(this.frame);
        dCheckUpdate.setLocationRelativeTo(this.frame);
        dCheckUpdate.startCheck();
        dCheckUpdate.setVisible(true);
        Version latestVersion = dCheckUpdate.getLatestVersion();
        if (latestVersion == null) {
            return;
        }
        this.compareVersions(latestVersion, false);
    }

    public void compareVersions(Version latestVersion, boolean autoUpdateCheck) {
        if (autoUpdateCheck) {
            if (!this.applicationSettings.isAutoUpdateCheckEnabled()) {
                return;
            }
            Date lastCheck = this.applicationSettings.getAutoUpdateCheckLastCheck();
            Date now = new Date();
            int checkInterval = this.applicationSettings.getAutoUpdateCheckInterval();
            if (TimeUnit.MILLISECONDS.toDays(now.getTime() - lastCheck.getTime()) < (long)checkInterval) {
                return;
            }
            this.applicationSettings.setAutoUpdateCheckLastCheck(new Date());
        }
        try {
            Version currentVersion = KSE.getApplicationVersion();
            if (currentVersion.compareTo(latestVersion) >= 0) {
                if (!autoUpdateCheck) {
                    JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("CheckUpdateAction.HaveLatestVersion.message"), currentVersion), KSE.getApplicationName(), 1);
                }
            } else {
                int selected = JOptionPane.showConfirmDialog(this.frame, MessageFormat.format(res.getString("CheckUpdateAction.NewerVersionAvailable.message"), latestVersion), KSE.getApplicationName(), 0);
                if (selected == 0) {
                    this.openDownloadWebSite();
                }
            }
        }
        catch (VersionException ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void openDownloadWebSite() {
        try {
            Desktop.getDesktop().browse(URI.create("https://keystore-explorer.org/downloads.html"));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("CheckUpdateAction.NoLaunchBrowser.message"), "https://keystore-explorer.org/downloads.html"), KSE.getApplicationName(), 1);
        }
    }
}

