/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.filetype.CryptoFileType;
import org.kse.crypto.filetype.CryptoFileUtil;
import org.kse.crypto.privatekey.MsPvkUtil;
import org.kse.crypto.privatekey.OpenSslPvkUtil;
import org.kse.crypto.privatekey.Pkcs8Util;
import org.kse.crypto.publickey.OpenSslPubUtil;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.dialogs.DViewCrl;
import org.kse.gui.dialogs.DViewCsr;
import org.kse.gui.dialogs.DViewPrivateKey;
import org.kse.gui.dialogs.DViewPublicKey;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.gui.password.DGetPassword;

public class ExamineClipboardAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = -4374420674229658652L;

    public ExamineClipboardAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("ExamineClipboardAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("LongDescription", res.getString("ExamineClipboardAction.statusbar"));
        this.putValue("Name", res.getString("ExamineClipboardAction.text"));
        this.putValue("ShortDescription", res.getString("ExamineClipboardAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/examineclipboard.png"))));
    }

    @Override
    protected void doAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(null);
        try {
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.show(data);
            }
        }
        catch (UnsupportedFlavorException data) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show(String data) {
        if (data == null) {
            return;
        }
        try {
            CryptoFileType fileType = CryptoFileUtil.detectFileType(data.getBytes());
            switch (fileType) {
                case CERT: {
                    this.showCert(data.getBytes());
                    break;
                }
                case CRL: {
                    this.showCrl(data.getBytes());
                    break;
                }
                case PKCS10_CSR: 
                case SPKAC_CSR: {
                    this.showCsr(data.getBytes(), fileType);
                    break;
                }
                case ENC_PKCS8_PVK: 
                case UNENC_PKCS8_PVK: 
                case ENC_OPENSSL_PVK: 
                case UNENC_OPENSSL_PVK: 
                case ENC_MS_PVK: 
                case UNENC_MS_PVK: {
                    this.showPrivateKey(data.getBytes(), fileType);
                    break;
                }
                case OPENSSL_PUB: {
                    this.showPublicKey(data.getBytes());
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(this.frame, res.getString("ExamineClipboardAction.UnknownType.message"), res.getString("ExamineClipboardAction.ExamineClipboard.Title"), 2);
                    break;
                }
            }
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private void showPrivateKey(byte[] data, CryptoFileType fileType) throws IOException, CryptoException {
        PrivateKey privKey = null;
        Password password = null;
        switch (fileType) {
            case ENC_PKCS8_PVK: {
                password = this.getPassword();
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = Pkcs8Util.loadEncrypted(data, password);
                break;
            }
            case UNENC_PKCS8_PVK: {
                privKey = Pkcs8Util.load(data);
                break;
            }
            case ENC_OPENSSL_PVK: {
                password = this.getPassword();
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = OpenSslPvkUtil.loadEncrypted(data, password);
                break;
            }
            case UNENC_OPENSSL_PVK: {
                privKey = OpenSslPvkUtil.load(data);
                break;
            }
            case ENC_MS_PVK: {
                password = this.getPassword();
                if (password == null || password.isNulled()) {
                    return;
                }
                privKey = MsPvkUtil.loadEncrypted(data, password);
                break;
            }
            case UNENC_MS_PVK: {
                privKey = MsPvkUtil.load(data);
                break;
            }
        }
        DViewPrivateKey dViewPrivateKey = new DViewPrivateKey(this.frame, res.getString("ExamineClipboardAction.PrivateKeyDetails.Title"), privKey);
        dViewPrivateKey.setLocationRelativeTo(this.frame);
        dViewPrivateKey.setVisible(true);
    }

    private Password getPassword() {
        DGetPassword dGetPassword = new DGetPassword(this.frame, res.getString("ExamineClipboardAction.EnterPassword.Title"));
        dGetPassword.setLocationRelativeTo(this.frame);
        dGetPassword.setVisible(true);
        return dGetPassword.getPassword();
    }

    private void showPublicKey(byte[] data) throws IOException, CryptoException {
        PublicKey publicKey = OpenSslPubUtil.load(data);
        DViewPublicKey dViewPublicKey = new DViewPublicKey(this.frame, res.getString("ExamineClipboardAction.PublicKeyDetails.Title"), publicKey);
        dViewPublicKey.setLocationRelativeTo(this.frame);
        dViewPublicKey.setVisible(true);
    }

    private void showCert(byte[] data) throws CryptoException {
        X509Certificate[] certs = null;
        try {
            certs = X509CertUtil.loadCertificates(data);
            if (certs.length == 0) {
                JOptionPane.showMessageDialog(this.frame, res.getString("ExamineClipboardAction.NoCertsFound.message"), res.getString("ExamineClipboardAction.OpenCertificate.Title"), 2);
            }
        }
        catch (Exception ex) {
            String problemStr = res.getString("ExamineClipboardAction.NoOpenCert.Problem");
            String[] causes = new String[]{res.getString("ExamineClipboardAction.NotCert.Cause"), res.getString("ExamineClipboardAction.CorruptedCert.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ExamineClipboardAction.ProblemOpeningCert.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
        }
        if (certs != null && certs.length > 0) {
            DViewCertificate dViewCertificate = new DViewCertificate(this.frame, res.getString("ExamineClipboardAction.CertDetails.Title"), certs, this.kseFrame, DViewCertificate.IMPORT_EXPORT);
            dViewCertificate.setLocationRelativeTo(this.frame);
            dViewCertificate.setVisible(true);
        }
    }

    private void showCrl(byte[] data) {
        if (data == null) {
            return;
        }
        X509CRL crl = null;
        try {
            crl = X509CertUtil.loadCRL(data);
        }
        catch (Exception ex) {
            String problemStr = res.getString("ExamineClipboardAction.NoOpenCrl.Problem");
            String[] causes = new String[]{res.getString("ExamineClipboardAction.NotCrl.Cause"), res.getString("ExamineClipboardAction.CorruptedCrl.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ExamineClipboardAction.ProblemOpeningCrl.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
        }
        if (crl != null) {
            DViewCrl dViewCrl = new DViewCrl(this.frame, res.getString("ExamineClipboardAction.CrlDetails.Title"), crl);
            dViewCrl.setLocationRelativeTo(this.frame);
            dViewCrl.setVisible(true);
        }
    }

    private void showCsr(byte[] data, CryptoFileType fileType) {
        if (data == null) {
            return;
        }
        try {
            PKCS10CertificationRequest pkcs10Csr = null;
            Spkac spkacCsr = null;
            try {
                if (fileType == CryptoFileType.PKCS10_CSR) {
                    pkcs10Csr = Pkcs10Util.loadCsr(data);
                } else if (fileType == CryptoFileType.SPKAC_CSR) {
                    spkacCsr = new Spkac(data);
                }
            }
            catch (Exception ex) {
                String problemStr = res.getString("ExamineClipboardAction.NoOpenCsr.Problem");
                String[] causes = new String[]{res.getString("ExamineClipboardAction.NotCsr.Cause"), res.getString("ExamineClipboardAction.CorruptedCsr.Cause")};
                Problem problem = new Problem(problemStr, causes, ex);
                DProblem dProblem = new DProblem(this.frame, res.getString("ExamineClipboardAction.ProblemOpeningCsr.Title"), problem);
                dProblem.setLocationRelativeTo(this.frame);
                dProblem.setVisible(true);
                return;
            }
            if (pkcs10Csr != null) {
                DViewCsr dViewCsr = new DViewCsr(this.frame, res.getString("ExamineClipboardAction.CsrDetails.Title"), pkcs10Csr);
                dViewCsr.setLocationRelativeTo(this.frame);
                dViewCsr.setVisible(true);
            } else {
                DViewCsr dViewCsr = new DViewCsr(this.frame, res.getString("ExamineClipboardAction.CsrDetails.Title"), spkacCsr);
                dViewCsr.setLocationRelativeTo(this.frame);
                dViewCsr.setVisible(true);
            }
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

