/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DExamineSsl;
import org.kse.gui.dialogs.DExaminingSsl;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.ssl.SslConnectionInfos;

public class ExamineSslAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public ExamineSslAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)res.getString("ExamineSslAction.accelerator").charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        this.putValue("LongDescription", res.getString("ExamineSslAction.statusbar"));
        this.putValue("Name", res.getString("ExamineSslAction.text"));
        this.putValue("ShortDescription", res.getString("ExamineSslAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/examinessl.png"))));
    }

    @Override
    protected void doAction() {
        try {
            DExamineSsl dExamineSsl = new DExamineSsl(this.frame, this.kseFrame);
            dExamineSsl.setLocationRelativeTo(this.frame);
            dExamineSsl.setVisible(true);
            String sslHost = dExamineSsl.getSslHost();
            int sslPort = dExamineSsl.getSslPort();
            boolean useClientAuth = dExamineSsl.useClientAuth();
            KeyStoreHistory ksh = dExamineSsl.getKeyStore();
            if (dExamineSsl.wasCancelled()) {
                return;
            }
            DExaminingSsl dExaminingSsl = new DExaminingSsl(this.frame, sslHost, sslPort, useClientAuth, ksh);
            dExaminingSsl.setLocationRelativeTo(this.frame);
            dExaminingSsl.startExamination();
            dExaminingSsl.setVisible(true);
            SslConnectionInfos sslInfos = dExaminingSsl.getSSLConnectionInfos();
            if (sslInfos == null || sslInfos.getServerCertificates() == null) {
                return;
            }
            DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("ExamineSslAction.CertDetailsSsl.Title"), sslHost, Integer.toString(sslPort)), sslInfos.getServerCertificates(), this.kseFrame, DViewCertificate.IMPORT_EXPORT);
            dViewCertificate.setLocationRelativeTo(this.frame);
            dViewCertificate.setVisible(true);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }
}

