/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.security.auth.x500.X500Principal;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.kse.crypto.CryptoException;
import org.kse.crypto.Password;
import org.kse.crypto.csr.CsrType;
import org.kse.crypto.csr.pkcs10.Pkcs10Util;
import org.kse.crypto.csr.spkac.Spkac;
import org.kse.crypto.csr.spkac.SpkacSubject;
import org.kse.crypto.keypair.KeyPairType;
import org.kse.crypto.keypair.KeyPairUtil;
import org.kse.crypto.signing.SignatureType;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.KeyStoreExplorerAction;
import org.kse.gui.dialogs.DGenerateCsr;
import org.kse.gui.error.DError;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;
import org.kse.utilities.io.IOUtils;

public class GenerateCsrAction
extends KeyStoreExplorerAction {
    private static final long serialVersionUID = 1L;

    public GenerateCsrAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("GenerateCsrAction.statusbar"));
        this.putValue("Name", res.getString("GenerateCsrAction.text"));
        this.putValue("ShortDescription", res.getString("GenerateCsrAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/gencsr.png"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() {
        File csrFile = null;
        FileOutputStream fos = null;
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            Provider provider = history.getExplicitProvider();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStore keyStore = currentState.getKeyStore();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
            String keyPairAlg = privateKey.getAlgorithm();
            KeyPairType keyPairType = KeyPairUtil.getKeyPairType(privateKey);
            if (keyPairType == null) {
                throw new CryptoException(MessageFormat.format(res.getString("GenerateCsrAction.NoCsrForKeyPairAlg.message"), keyPairAlg));
            }
            String path = CurrentDirectory.get().getAbsolutePath();
            File keyStoreFile = history.getFile();
            if (keyStoreFile != null) {
                path = keyStoreFile.getAbsoluteFile().getParent();
            }
            X509Certificate firstCertInChain = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)))[0];
            X500Principal subjectDN = firstCertInChain.getSubjectX500Principal();
            DGenerateCsr dGenerateCsr = new DGenerateCsr(this.frame, alias, subjectDN, privateKey, keyPairType, path);
            dGenerateCsr.setLocationRelativeTo(this.frame);
            dGenerateCsr.setVisible(true);
            if (!dGenerateCsr.generateSelected()) {
                return;
            }
            csrFile = dGenerateCsr.getCsrFile();
            subjectDN = dGenerateCsr.getSubjectDN();
            CsrType format = dGenerateCsr.getFormat();
            SignatureType signatureType = dGenerateCsr.getSignatureType();
            String challenge = dGenerateCsr.getChallenge();
            String unstructuredName = dGenerateCsr.getUnstructuredName();
            boolean useCertificateExtensions = dGenerateCsr.isAddExtensionsWanted();
            PublicKey publicKey = firstCertInChain.getPublicKey();
            Extensions extensions = null;
            if (useCertificateExtensions) {
                Certificate certificate = Certificate.getInstance((Object)firstCertInChain.getEncoded());
                extensions = certificate.getTBSCertificate().getExtensions();
            }
            fos = new FileOutputStream(csrFile);
            if (format == CsrType.PKCS10) {
                String csr = Pkcs10Util.getCsrEncodedDerPem(Pkcs10Util.generateCsr(subjectDN, publicKey, privateKey, signatureType, challenge, unstructuredName, extensions, provider));
                fos.write(csr.getBytes());
            } else {
                SpkacSubject subject = new SpkacSubject(X500NameUtils.x500PrincipalToX500Name(firstCertInChain.getSubjectX500Principal()));
                Spkac spkac = new Spkac(challenge, signatureType, subject, publicKey, privateKey);
                spkac.output(fos);
            }
            JOptionPane.showMessageDialog(this.frame, res.getString("GenerateCsrAction.CsrGenerationSuccessful.message"), res.getString("GenerateCsrAction.GenerateCsr.Title"), 1);
            IOUtils.closeQuietly(fos);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("GenerateCsrAction.NoWriteFile.message"), csrFile), res.getString("GenerateCsrAction.GenerateCsr.Title"), 2);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }
}

