/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.AuthorityCertificatesAction;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ImportCaReplyFromClipboardAction
extends AuthorityCertificatesAction
implements HistoryAction {
    private static final long serialVersionUID = 3536795359314369745L;

    public ImportCaReplyFromClipboardAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ImportCaReplyFromClipboardAction.statusbar"));
        this.putValue("Name", res.getString("ImportCaReplyFromClipboardAction.text"));
        this.putValue("ShortDescription", res.getString("ImportCaReplyFromClipboardAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/importcareplyclipboard.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            KeyStoreType keyStoreType = KeyStoreType.resolveJce(keyStore.getType());
            Key privateKey = keyStore.getKey(alias, password.toCharArray());
            Certificate[] certs = this.openCaReply();
            if (certs == null || certs.length == 0) {
                return;
            }
            certs = X509CertUtil.orderX509CertChain((X509Certificate[])certs);
            X509Certificate[] exitingEntryCerts = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            if (!exitingEntryCerts[0].getPublicKey().equals(certs[0].getPublicKey())) {
                JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromClipboardAction.NoMatchPubKeyCaReply.message"), res.getString("ImportCaReplyFromClipboardAction.ImportCaReply.Title"), 2);
                return;
            }
            Certificate[] newCertChain = null;
            if (!this.applicationSettings.getEnableImportCaReplyTrustCheck()) {
                newCertChain = certs;
            } else {
                KeyStore caCertificates = this.getCaCertificates();
                KeyStore windowsTrustedRootCertificates = this.getWindowsTrustedRootCertificates();
                if (certs.length > 1) {
                    Certificate rootCert = certs[certs.length - 1];
                    String matchAlias = null;
                    if (caCertificates != null) {
                        matchAlias = X509CertUtil.matchCertificate(caCertificates, (X509Certificate)rootCert);
                    }
                    if (windowsTrustedRootCertificates != null && matchAlias == null) {
                        matchAlias = X509CertUtil.matchCertificate(windowsTrustedRootCertificates, (X509Certificate)rootCert);
                    }
                    if (matchAlias == null) {
                        matchAlias = X509CertUtil.matchCertificate(keyStore, (X509Certificate)rootCert);
                    }
                    if (matchAlias == null) {
                        JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromClipboardAction.NoMatchRootCertCaReplyConfirm.message"), res.getString("ImportCaReplyFromClipboardAction.ImportCaReply.Title"), 1);
                        DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("ImportCaReplyFromClipboardAction.CertDetailsFile.Title"), "Clipboard"), new X509Certificate[]{rootCert}, null, DViewCertificate.NONE);
                        dViewCertificate.setLocationRelativeTo(this.frame);
                        dViewCertificate.setVisible(true);
                        int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("ImportCaReplyFromClipboardAction.AcceptCaReply.message"), res.getString("ImportCaReplyFromClipboardAction.ImportCaReply.Title"), 0);
                        if (selected != 0) {
                            return;
                        }
                        newCertChain = certs;
                    } else {
                        newCertChain = certs;
                    }
                } else {
                    X509Certificate[] trustChain;
                    ArrayList<KeyStore> compKeyStores = new ArrayList<KeyStore>();
                    compKeyStores.add(keyStore);
                    if (caCertificates != null) {
                        compKeyStores.add(caCertificates);
                    }
                    if (windowsTrustedRootCertificates != null) {
                        compKeyStores.add(windowsTrustedRootCertificates);
                    }
                    if ((trustChain = X509CertUtil.establishTrust((X509Certificate)certs[0], compKeyStores.toArray(new KeyStore[compKeyStores.size()]))) != null) {
                        newCertChain = trustChain;
                    } else {
                        JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromClipboardAction.NoTrustCaReply.message"), res.getString("ImportCaReplyFromClipboardAction.ImportCaReply.Title"), 2);
                        return;
                    }
                }
            }
            if (keyStoreType.isFileBased()) {
                keyStore.deleteEntry(alias);
                keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), newCertChain);
            } else {
                keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), newCertChain);
            }
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromClipboardAction.ImportCaReplySuccessful.message"), res.getString("ImportCaReplyFromClipboardAction.ImportCaReply.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private X509Certificate[] openCaReply() {
        X509Certificate[] certs = null;
        try {
            String data;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = clipboard.getContents(null);
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor) && (certs = X509CertUtil.loadCertificates((data = (String)t.getTransferData(DataFlavor.stringFlavor)).getBytes())).length == 0) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("ImportCaReplyFromClipboardAction.NoCertsFound.message"), "Clipboard"), res.getString("ImportCaReplyFromClipboardAction.OpenCaReply.Title"), 2);
            }
            return certs;
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("ImportCaReplyFromClipboardAction.NoOpenCaReply.Problem"), "Clipboard");
            String[] causes = new String[]{res.getString("ImportCaReplyFromClipboardAction.NotCaReply.Cause"), res.getString("ImportCaReplyFromClipboardAction.CorruptedCaReply.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ImportCaReplyFromClipboardAction.ProblemOpeningCaReply.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return null;
        }
    }
}

