/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.kse.crypto.Password;
import org.kse.crypto.keystore.KeyStoreType;
import org.kse.crypto.x509.X509CertUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.KseFrame;
import org.kse.gui.actions.AuthorityCertificatesAction;
import org.kse.gui.dialogs.DViewCertificate;
import org.kse.gui.error.DError;
import org.kse.gui.error.DProblem;
import org.kse.gui.error.Problem;
import org.kse.utilities.history.HistoryAction;
import org.kse.utilities.history.KeyStoreHistory;
import org.kse.utilities.history.KeyStoreState;

public class ImportCaReplyFromFileAction
extends AuthorityCertificatesAction
implements HistoryAction {
    private static final long serialVersionUID = 8516357420696038325L;

    public ImportCaReplyFromFileAction(KseFrame kseFrame) {
        super(kseFrame);
        this.putValue("LongDescription", res.getString("ImportCaReplyFromFileAction.statusbar"));
        this.putValue("Name", res.getString("ImportCaReplyFromFileAction.text"));
        this.putValue("ShortDescription", res.getString("ImportCaReplyFromFileAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/importcareplyfile.png"))));
    }

    @Override
    public String getHistoryDescription() {
        return (String)this.getValue("Name");
    }

    @Override
    protected void doAction() {
        try {
            KeyStoreHistory history = this.kseFrame.getActiveKeyStoreHistory();
            KeyStoreState currentState = history.getCurrentState();
            String alias = this.kseFrame.getSelectedEntryAlias();
            Password password = this.getEntryPassword(alias, currentState);
            if (password == null) {
                return;
            }
            KeyStoreState newState = currentState.createBasisForNextState(this);
            KeyStore keyStore = newState.getKeyStore();
            KeyStoreType keyStoreType = KeyStoreType.resolveJce(keyStore.getType());
            Key privateKey = keyStore.getKey(alias, password.toCharArray());
            File caReplyFile = this.chooseCaFile();
            if (caReplyFile == null) {
                return;
            }
            Certificate[] certs = this.openCaReply(caReplyFile);
            if (certs == null || certs.length == 0) {
                return;
            }
            certs = X509CertUtil.orderX509CertChain((X509Certificate[])certs);
            X509Certificate[] exitingEntryCerts = X509CertUtil.orderX509CertChain(X509CertUtil.convertCertificates(keyStore.getCertificateChain(alias)));
            if (!exitingEntryCerts[0].getPublicKey().equals(certs[0].getPublicKey())) {
                JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromFileAction.NoMatchPubKeyCaReply.message"), res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"), 2);
                return;
            }
            Certificate[] newCertChain = null;
            if (!this.applicationSettings.getEnableImportCaReplyTrustCheck()) {
                newCertChain = certs;
            } else {
                KeyStore caCertificates = this.getCaCertificates();
                KeyStore windowsTrustedRootCertificates = this.getWindowsTrustedRootCertificates();
                if (certs.length > 1) {
                    Certificate rootCert = certs[certs.length - 1];
                    String matchAlias = null;
                    if (caCertificates != null) {
                        matchAlias = X509CertUtil.matchCertificate(caCertificates, (X509Certificate)rootCert);
                    }
                    if (windowsTrustedRootCertificates != null && matchAlias == null) {
                        matchAlias = X509CertUtil.matchCertificate(windowsTrustedRootCertificates, (X509Certificate)rootCert);
                    }
                    if (matchAlias == null) {
                        matchAlias = X509CertUtil.matchCertificate(keyStore, (X509Certificate)rootCert);
                    }
                    if (matchAlias == null) {
                        JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromFileAction.NoMatchRootCertCaReplyConfirm.message"), res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"), 1);
                        DViewCertificate dViewCertificate = new DViewCertificate(this.frame, MessageFormat.format(res.getString("ImportCaReplyFromFileAction.CertDetailsFile.Title"), caReplyFile.getName()), new X509Certificate[]{rootCert}, null, DViewCertificate.NONE);
                        dViewCertificate.setLocationRelativeTo(this.frame);
                        dViewCertificate.setVisible(true);
                        int selected = JOptionPane.showConfirmDialog(this.frame, res.getString("ImportCaReplyFromFileAction.AcceptCaReply.message"), res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"), 0);
                        if (selected != 0) {
                            return;
                        }
                        newCertChain = certs;
                    } else {
                        newCertChain = certs;
                    }
                } else {
                    X509Certificate[] trustChain;
                    ArrayList<KeyStore> compKeyStores = new ArrayList<KeyStore>();
                    compKeyStores.add(keyStore);
                    if (caCertificates != null) {
                        compKeyStores.add(caCertificates);
                    }
                    if (windowsTrustedRootCertificates != null) {
                        compKeyStores.add(windowsTrustedRootCertificates);
                    }
                    if ((trustChain = X509CertUtil.establishTrust((X509Certificate)certs[0], compKeyStores.toArray(new KeyStore[compKeyStores.size()]))) != null) {
                        newCertChain = trustChain;
                    } else {
                        JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromFileAction.NoTrustCaReply.message"), res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"), 2);
                        return;
                    }
                }
            }
            if (keyStoreType.isFileBased()) {
                keyStore.deleteEntry(alias);
                keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), newCertChain);
            } else {
                keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), newCertChain);
            }
            currentState.append(newState);
            this.kseFrame.updateControls(true);
            JOptionPane.showMessageDialog(this.frame, res.getString("ImportCaReplyFromFileAction.ImportCaReplySuccessful.message"), res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"), 1);
        }
        catch (Exception ex) {
            DError.displayError(this.frame, (Throwable)ex);
        }
    }

    private File chooseCaFile() {
        JFileChooser chooser = FileChooserFactory.getCaReplyFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("ImportCaReplyFromFileAction.ImportCaReply.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("ImportCaReplyFromFileAction.ImportCaReply.button"));
        int rtnValue = chooser.showOpenDialog(this.frame);
        if (rtnValue == 0) {
            File openFile = chooser.getSelectedFile();
            CurrentDirectory.updateForFile(openFile);
            return openFile;
        }
        return null;
    }

    private X509Certificate[] openCaReply(File caReply) {
        try {
            byte[] caReplyData = FileUtils.readFileToByteArray((File)caReply);
            X509Certificate[] certs = X509CertUtil.loadCertificates(caReplyData);
            if (certs.length == 0) {
                JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("ImportCaReplyFromFileAction.NoCertsFound.message"), caReply), res.getString("ImportCaReplyFromFileAction.OpenCaReply.Title"), 2);
            }
            return certs;
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.frame, MessageFormat.format(res.getString("ImportCaReplyFromFileAction.NoReadFile.message"), caReply), res.getString("ImportCaReplyFromFileAction.OpenCaReply.Title"), 2);
            return null;
        }
        catch (Exception ex) {
            String problemStr = MessageFormat.format(res.getString("ImportCaReplyFromFileAction.NoOpenCaReply.Problem"), caReply.getName());
            String[] causes = new String[]{res.getString("ImportCaReplyFromFileAction.NotCaReply.Cause"), res.getString("ImportCaReplyFromFileAction.CorruptedCaReply.Cause")};
            Problem problem = new Problem(problemStr, causes, ex);
            DProblem dProblem = new DProblem(this.frame, res.getString("ImportCaReplyFromFileAction.ProblemOpeningCaReply.Title"), problem);
            dProblem.setLocationRelativeTo(this.frame);
            dProblem.setVisible(true);
            return null;
        }
    }
}

