/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PublicKey;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.publickey.KeyIdentifierGenerator;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;

public class DKeyIdentifierChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpKeyIdentifier;
    private JLabel jlGenerationMethod;
    private JRadioButton jrb160BitHash;
    private JRadioButton jrb64BitHash;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PublicKey publicKey;
    private byte[] keyIdentifier160Bit;
    private byte[] keyIdentifier64Bit;
    private byte[] keyIdentifier;

    public DKeyIdentifierChooser(JFrame parent, String title, PublicKey publicKey, byte[] keyIdentifier) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.publicKey = publicKey;
        this.initComponents(keyIdentifier);
    }

    public DKeyIdentifierChooser(JDialog parent, String title, PublicKey publicKey, byte[] keyIdentifier) throws CryptoException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.publicKey = publicKey;
        this.initComponents(keyIdentifier);
    }

    private void initComponents(byte[] keyIdentifier) throws CryptoException {
        this.jlGenerationMethod = new JLabel(res.getString("DKeyIdentifierChooser.jlGenerationMethod.text"));
        this.jrb160BitHash = new JRadioButton(res.getString("DKeyIdentifierChooser.jrb160BitHash.text"));
        this.jrb160BitHash.setToolTipText(res.getString("DKeyIdentifierChooser.jrb160BitHash.tooltip"));
        this.jrb64BitHash = new JRadioButton(res.getString("DKeyIdentifierChooser.jrb64BitHash.text"));
        this.jrb64BitHash.setToolTipText(res.getString("DKeyIdentifierChooser.jrb64BitHash.tooltip"));
        ButtonGroup bgKeyIdentifier = new ButtonGroup();
        bgKeyIdentifier.add(this.jrb160BitHash);
        bgKeyIdentifier.add(this.jrb64BitHash);
        this.jpKeyIdentifier = new JPanel(new GridLayout(3, 1));
        this.jpKeyIdentifier.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpKeyIdentifier.add(this.jlGenerationMethod);
        this.jpKeyIdentifier.add(this.jrb160BitHash);
        this.jpKeyIdentifier.add(this.jrb64BitHash);
        this.jbOK = new JButton(res.getString("DKeyIdentifierChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyIdentifierChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DKeyIdentifierChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyIdentifierChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DKeyIdentifierChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpKeyIdentifier);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(keyIdentifier);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(byte[] keyIdentifier) throws CryptoException {
        KeyIdentifierGenerator keyIdentifierGenerator = new KeyIdentifierGenerator(this.publicKey);
        this.keyIdentifier160Bit = keyIdentifierGenerator.generate160BitHashId();
        this.keyIdentifier64Bit = keyIdentifierGenerator.generate64BitHashId();
        if (keyIdentifier == null || keyIdentifier.length == this.keyIdentifier160Bit.length) {
            this.jrb160BitHash.setSelected(true);
        } else {
            this.jrb64BitHash.setSelected(true);
        }
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier;
    }

    private void okPressed() {
        this.keyIdentifier = this.jrb160BitHash.isSelected() ? this.keyIdentifier160Bit : this.keyIdentifier64Bit;
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

