/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.miginfocom.swing.MigLayout;
import org.kse.crypto.jcepolicy.JcePolicy;
import org.kse.crypto.jcepolicy.JcePolicyUtil;
import org.kse.gui.CurrentDirectory;
import org.kse.gui.CursorUtil;
import org.kse.gui.FileChooserFactory;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.error.DError;
import org.kse.utilities.DialogViewer;
import org.kse.utilities.io.CopyUtil;

public class DUpgradeCryptoStrength
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JLabel jlUpgradeInstructions;
    private JLabel jlDownloadPolicyInstructions;
    private JButton jbDownloadPolicy;
    private JLabel jlDropPolicyInstructions;
    private PolicyZipDropTarget policyZipDropTarget;
    private JButton jbBrowsePolicy;
    private JPanel jpButtons;
    private JButton jbUpgrade;
    private JButton jbCancel;
    private byte[] localPolicyJarContents;
    private byte[] usExportPolicyJarContents;
    private boolean cryptoStrengthUpgraded = false;
    private boolean cryptoStrengthUpgradeFailed = false;

    public DUpgradeCryptoStrength(JFrame parent) {
        super((Window)parent, res.getString("DUpgradeCryptoStrength.Title"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
    }

    private void initComponents() {
        this.jlUpgradeInstructions = new JLabel(res.getString("DUpgradeCryptoStrength.jlUpgradeInstructions.text"));
        this.jlDownloadPolicyInstructions = new JLabel(res.getString("DUpgradeCryptoStrength.jlDownloadPolicyInstructions.text"));
        this.jbDownloadPolicy = new JButton(res.getString("DUpgradeCryptoStrength.jbDownloadPolicy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbDownloadPolicy, res.getString("DUpgradeCryptoStrength.jbDownloadPolicy.mnemonic").charAt(0));
        this.jlDropPolicyInstructions = new JLabel(res.getString("DUpgradeCryptoStrength.jlDropPolicyInstructions.text"));
        this.policyZipDropTarget = new PolicyZipDropTarget();
        this.jbBrowsePolicy = new JButton(res.getString("DUpgradeCryptoStrength.jbBrowsePolicy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbBrowsePolicy, res.getString("DUpgradeCryptoStrength.jbBrowsePolicy.mnemonic").charAt(0));
        this.jbUpgrade = new JButton(res.getString("DUpgradeCryptoStrength.jbUpgrade.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbUpgrade, res.getString("DUpgradeCryptoStrength.jbUpgrade.mnemonic").charAt(0));
        this.jbUpgrade.setEnabled(false);
        this.jbCancel = new JButton(res.getString("DUpgradeCryptoStrength.jbCancel.text"));
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbUpgrade, this.jbCancel);
        Container pane = this.getContentPane();
        pane.setLayout((LayoutManager)new MigLayout("insets dialog, fill", "", "[]para[]"));
        pane.add((Component)this.jlUpgradeInstructions, "wrap");
        pane.add((Component)this.jlDownloadPolicyInstructions, "wrap");
        pane.add((Component)this.jbDownloadPolicy, "wrap");
        pane.add((Component)this.jlDropPolicyInstructions, "split");
        pane.add((Component)this.policyZipDropTarget, "gap para, pad para, wrap");
        pane.add((Component)this.jbBrowsePolicy, "wrap");
        pane.add((Component)new JSeparator(), "spanx, growx, wrap para");
        pane.add((Component)this.jpButtons, "right, spanx");
        this.jbDownloadPolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DUpgradeCryptoStrength.this);
                    DUpgradeCryptoStrength.this.downloadPolicyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DUpgradeCryptoStrength.this);
                }
            }
        });
        this.jbUpgrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUpgradeCryptoStrength.this.upgradePressed();
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUpgradeCryptoStrength.this.cancelPressed();
            }
        });
        this.jbBrowsePolicy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DUpgradeCryptoStrength.this);
                    DUpgradeCryptoStrength.this.browsePolicyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DUpgradeCryptoStrength.this);
                }
            }
        });
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DUpgradeCryptoStrength.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DUpgradeCryptoStrength.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbUpgrade);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePressed() {
        try {
            CursorUtil.setCursorBusy(this);
            File localPolicyJar = JcePolicyUtil.getJarFile(JcePolicy.LOCAL_POLICY);
            File localPolicyJarBkp = new File(localPolicyJar.getPath() + ".bkp");
            File usExportPolicyJar = JcePolicyUtil.getJarFile(JcePolicy.US_EXPORT_POLICY);
            File usExportPolicyJarBkp = new File(usExportPolicyJar.getPath() + ".bkp");
            CopyUtil.copyClose(new FileInputStream(localPolicyJar), new FileOutputStream(localPolicyJarBkp));
            CopyUtil.copyClose(new FileInputStream(usExportPolicyJar), new FileOutputStream(usExportPolicyJarBkp));
            CopyUtil.copyClose(new ByteArrayInputStream(this.localPolicyJarContents), new FileOutputStream(localPolicyJar));
            CopyUtil.copyClose(new ByteArrayInputStream(this.usExportPolicyJarContents), new FileOutputStream(usExportPolicyJar));
            this.cryptoStrengthUpgraded = true;
        }
        catch (IOException ex) {
            this.upgradeFailedShowManualInstructions();
        }
        finally {
            CursorUtil.setCursorFree(this);
        }
        this.closeDialog();
    }

    private void upgradeFailedShowManualInstructions() {
        this.cryptoStrengthUpgradeFailed = true;
        JOptionPane.showMessageDialog(this, res.getString("DUpgradeCryptoStrength.NoUpdatePolicy.message"), this.getTitle(), 2);
        String javaHome = System.getProperty("java.home");
        String fileSeparator = System.getProperty("file.separator");
        String manualInstructions = MessageFormat.format(res.getString("DUpgradeCryptoStrength.ManualInstructions.message"), javaHome, fileSeparator);
        JOptionPane.showMessageDialog(this, manualInstructions, this.getTitle(), 1);
    }

    public boolean hasCryptoStrengthBeenUpgraded() {
        return this.cryptoStrengthUpgraded;
    }

    public boolean hasCryptoStrengthUpgradeFailed() {
        return this.cryptoStrengthUpgradeFailed;
    }

    private void downloadPolicyPressed() {
        String websiteAddress = JcePolicyUtil.getJcePolicyDownloadUrl();
        try {
            Desktop.getDesktop().browse(URI.create(websiteAddress));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(res.getString("DUpgradeCryptoStrength.NoLaunchBrowser.message"), websiteAddress), this.getTitle(), 1);
        }
    }

    private void browsePolicyPressed() {
        JFileChooser chooser = FileChooserFactory.getZipFileChooser();
        chooser.setCurrentDirectory(CurrentDirectory.get());
        chooser.setDialogTitle(res.getString("DUpgradeCryptoStrength.Title.ChoosePolicyZip.Title"));
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(res.getString("DUpgradeCryptoStrength.Title.PolicyZipChooser.button"));
        int rtnValue = chooser.showOpenDialog(this);
        if (rtnValue == 0) {
            File chosenFile = chooser.getSelectedFile();
            if (!chosenFile.isFile()) {
                JOptionPane.showMessageDialog(this, res.getString("DUpgradeCryptoStrength.NotPolicyZip.message"), res.getString("DUpgradeCryptoStrength.Title"), 2);
                return;
            }
            this.processPolicyZipFile(chosenFile);
        }
    }

    private void processPolicyZipFile(File droppedFile) {
        try (ZipFile zip = new ZipFile(droppedFile);){
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                if (zipEntry.getName().endsWith(JcePolicy.LOCAL_POLICY.jar())) {
                    ByteArrayOutputStream localPolicyJarBaos = new ByteArrayOutputStream();
                    CopyUtil.copyClose(zip.getInputStream(zipEntry), localPolicyJarBaos);
                    this.localPolicyJarContents = localPolicyJarBaos.toByteArray();
                    continue;
                }
                if (!zipEntry.getName().endsWith(JcePolicy.US_EXPORT_POLICY.jar())) continue;
                ByteArrayOutputStream usExportPolicyJarBaos = new ByteArrayOutputStream();
                CopyUtil.copyClose(zip.getInputStream(zipEntry), usExportPolicyJarBaos);
                this.usExportPolicyJarContents = usExportPolicyJarBaos.toByteArray();
            }
            if (this.localPolicyJarContents != null && this.usExportPolicyJarContents != null) {
                this.jbDownloadPolicy.setEnabled(false);
                this.jbBrowsePolicy.setEnabled(false);
                this.policyZipDropTarget.policyZipAccepted();
                this.jbUpgrade.setEnabled(true);
            } else {
                JOptionPane.showMessageDialog(this, res.getString("DUpgradeCryptoStrength.NotPolicyZip.message"), res.getString("DUpgradeCryptoStrength.Title"), 2);
            }
        }
        catch (IOException ex) {
            DError.displayError(this, (Throwable)ex);
        }
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        DUpgradeCryptoStrength dialog = new DUpgradeCryptoStrength(new JFrame());
        DialogViewer.run(dialog);
    }

    private class PolicyZipDropTarget
    extends JLabel
    implements DropTargetListener {
        private static final long serialVersionUID = 1L;
        private boolean policyZipAccepted = false;

        public PolicyZipDropTarget() {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("images/drag_policy_here.png"));
            this.setIcon(icon);
            this.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            new DropTarget(this, this);
        }

        @Override
        public void drop(DropTargetDropEvent evt) {
            if (this.policyZipAccepted) {
                evt.rejectDrop();
                return;
            }
            try {
                List droppedFiles;
                evt.acceptDrop(2);
                Transferable trans = evt.getTransferable();
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (droppedFiles = (List)trans.getTransferData(DataFlavor.javaFileListFlavor)).size() == 1) {
                    File droppedFile = (File)droppedFiles.get(0);
                    DUpgradeCryptoStrength.this.processPolicyZipFile(droppedFile);
                }
            }
            catch (IOException ex) {
                DError.displayError(DUpgradeCryptoStrength.this, (Throwable)ex);
            }
            catch (UnsupportedFlavorException ex) {
                DError.displayError(DUpgradeCryptoStrength.this, (Throwable)ex);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent evt) {
        }

        @Override
        public void dragExit(DropTargetEvent evt) {
        }

        @Override
        public void dragOver(DropTargetDragEvent evt) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent evt) {
        }

        public void policyZipAccepted() {
            this.policyZipAccepted = true;
            ImageIcon icon = new ImageIcon(this.getClass().getResource("images/dragged_policy.png"));
            this.setIcon(icon);
        }
    }
}

