/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.kse.crypto.CryptoException;
import org.kse.crypto.jcepolicy.JcePolicy;
import org.kse.crypto.jcepolicy.JcePolicyUtil;
import org.kse.gui.CursorUtil;
import org.kse.gui.JEscDialog;
import org.kse.gui.LnfUtil;
import org.kse.gui.PlatformUtil;

public class DViewJcePolicy
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JPanel jpButtons;
    private JButton jbCopy;
    private JButton jbOK;
    private JPanel jpPolicy;
    private JScrollPane jspPolicy;
    private JTextArea jtaPolicy;
    private JcePolicy jcePolicy;

    public DViewJcePolicy(JFrame parent, JcePolicy jcePolicy) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.jcePolicy = jcePolicy;
        this.initComponents();
    }

    public DViewJcePolicy(JDialog parent, JcePolicy jcePolicy) throws CryptoException {
        super((Window)parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.jcePolicy = jcePolicy;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        this.jbCopy = new JButton(res.getString("DViewJcePolicy.jbCopy.text"));
        PlatformUtil.setMnemonic((AbstractButton)this.jbCopy, res.getString("DViewJcePolicy.jbCopy.mnemonic").charAt(0));
        this.jbCopy.setToolTipText(res.getString("DViewJcePolicy.jbCopy.tooltip"));
        this.jbCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(DViewJcePolicy.this);
                    DViewJcePolicy.this.copyPressed();
                }
                finally {
                    CursorUtil.setCursorFree(DViewJcePolicy.this);
                }
            }
        });
        this.jbOK = new JButton(res.getString("DViewJcePolicy.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DViewJcePolicy.this.okPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, null, this.jbCopy);
        this.jpPolicy = new JPanel(new BorderLayout());
        this.jpPolicy.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jtaPolicy = new JTextArea();
        this.jtaPolicy.setFont(new Font("Monospaced", 0, LnfUtil.getDefaultFontSize()));
        this.jtaPolicy.setEditable(false);
        this.jtaPolicy.setTabSize(4);
        this.jtaPolicy.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.jtaPolicy.setToolTipText(res.getString("DViewJcePolicy.jtaPolicy.tooltip"));
        this.jtaPolicy.setText(JcePolicyUtil.getPolicyDetails(this.jcePolicy));
        this.jtaPolicy.setCaretPosition(0);
        this.jspPolicy = PlatformUtil.createScrollPane(this.jtaPolicy, 22, 32);
        this.jspPolicy.setPreferredSize(new Dimension(500, 200));
        this.jpPolicy.add((Component)this.jspPolicy, "Center");
        this.getContentPane().add((Component)this.jpPolicy, "Center");
        this.getContentPane().add((Component)this.jpButtons, "South");
        this.setTitle(this.jcePolicy.friendly());
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DViewJcePolicy.this.closeDialog();
            }
        });
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DViewJcePolicy.this.jbOK.requestFocus();
            }
        });
    }

    private void copyPressed() {
        String policy = this.jtaPolicy.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection copy = new StringSelection(policy);
        clipboard.setContents(copy, copy);
    }

    private void okPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

