/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class JValidityPeriod
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/resources");
    private JSpinner jsValue;
    private JComboBox<?> jcbType;
    private JButton jbApply;
    public static final int YEARS = 0;
    public static final int MONTHS = 1;
    public static final int WEEKS = 2;
    public static final int DAYS = 3;

    public JValidityPeriod(int periodType) {
        this.initComponents(periodType);
    }

    private void initComponents(int periodType) {
        this.jsValue = new JSpinner();
        GridBagConstraints gbc_jsValue = new GridBagConstraints();
        gbc_jsValue.gridheight = 1;
        gbc_jsValue.gridwidth = 1;
        gbc_jsValue.gridx = 0;
        gbc_jsValue.gridy = 0;
        gbc_jsValue.insets = new Insets(0, 0, 0, 5);
        this.jcbType = new JComboBox<String>(new String[]{res.getString("JValidityPeriod.jcbType.years.text"), res.getString("JValidityPeriod.jcbType.months.text"), res.getString("JValidityPeriod.jcbType.weeks.text"), res.getString("JValidityPeriod.jcbType.days.text")});
        GridBagConstraints gbc_jcbType = new GridBagConstraints();
        gbc_jcbType.gridheight = 1;
        gbc_jcbType.gridwidth = 1;
        gbc_jcbType.gridx = 1;
        gbc_jcbType.gridy = 0;
        gbc_jcbType.insets = new Insets(0, 0, 0, 5);
        switch (periodType) {
            case 0: {
                this.jcbType.setSelectedIndex(0);
                this.typeChanged(0);
                break;
            }
            case 1: {
                this.jcbType.setSelectedIndex(1);
                this.typeChanged(1);
                break;
            }
            case 2: {
                this.jcbType.setSelectedIndex(2);
                this.typeChanged(2);
                break;
            }
            default: {
                this.jcbType.setSelectedIndex(3);
                this.typeChanged(3);
            }
        }
        this.jcbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JValidityPeriod.this.typeChanged(((JComboBox)evt.getSource()).getSelectedIndex());
            }
        });
        this.jbApply = new JButton(res.getString("JValidityPeriod.jbApply.text"));
        GridBagConstraints gbc_jbApply = new GridBagConstraints();
        gbc_jbApply.gridheight = 1;
        gbc_jbApply.gridwidth = 1;
        gbc_jbApply.gridx = 2;
        gbc_jbApply.gridy = 0;
        gbc_jbApply.insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jsValue, gbc_jsValue);
        this.add(this.jcbType, gbc_jcbType);
        this.add((Component)this.jbApply, gbc_jbApply);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jsValue.setToolTipText(toolTipText);
        this.jcbType.setToolTipText(toolTipText);
    }

    private void typeChanged(int periodType) {
        SpinnerNumberModel model;
        Number value = ((SpinnerNumberModel)this.jsValue.getModel()).getNumber();
        switch (periodType) {
            case 0: {
                model = new SpinnerNumberModel(1, 1, 999, 1);
                break;
            }
            case 1: {
                model = new SpinnerNumberModel(1, 1, 12, 1);
                break;
            }
            case 2: {
                model = new SpinnerNumberModel(1, 1, 52, 1);
                break;
            }
            default: {
                model = new SpinnerNumberModel(1, 1, 365, 1);
            }
        }
        if (model.getMaximum().compareTo(value) >= 0 && model.getMinimum().compareTo(value) <= 0) {
            model.setValue(value);
        }
        this.jsValue.setModel(model);
    }

    public long getValidityPeriodMs() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return this.getValidityPeriodMs(now.getTime());
    }

    public long getValidityPeriodMs(Date validityStart) {
        Date validityEnd = this.getValidityEnd(validityStart);
        return validityEnd.getTime() - validityStart.getTime();
    }

    public Date getValidityEnd(Date validityStart) {
        Calendar validityDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        validityDate.setTime(validityStart);
        int periodType = this.jcbType.getSelectedIndex();
        int periodValue = ((Number)this.jsValue.getValue()).intValue();
        switch (periodType) {
            case 0: {
                validityDate.add(1, periodValue);
                break;
            }
            case 1: {
                validityDate.add(2, periodValue);
                break;
            }
            case 2: {
                validityDate.add(4, periodValue);
                break;
            }
            default: {
                validityDate.add(7, periodValue);
            }
        }
        return validityDate.getTime();
    }

    public void addApplyActionListener(ActionListener listener) {
        this.jbApply.addActionListener(listener);
    }
}

