/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.accessdescription;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.kse.gui.CursorUtil;
import org.kse.gui.JKseTable;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.accessdescription.AccessDescriptionsTableCellRend;
import org.kse.gui.crypto.accessdescription.AccessDescriptionsTableHeadRend;
import org.kse.gui.crypto.accessdescription.AccessDescriptionsTableModel;
import org.kse.gui.crypto.accessdescription.DAccessDescriptionChooser;
import org.kse.utilities.os.OperatingSystem;

public class JAccessDescriptions
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/accessdescription/resources");
    private JPanel jpAccessDescriptionButtons;
    private JButton jbAdd;
    private JButton jbEdit;
    private JButton jbRemove;
    private JScrollPane jspAccessDescriptions;
    private JKseTable jtAccessDescriptions;
    private String title;
    private List<AccessDescription> accessDescriptions;
    private boolean enabled = true;

    public JAccessDescriptions(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.jbAdd = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/add_access_desc.png"))));
        this.jbAdd.setMargin(new Insets(2, 2, 0, 0));
        this.jbAdd.setToolTipText(res.getString("JAccessDescriptions.jbAdd.tooltip"));
        this.jbAdd.setMnemonic(res.getString("JAccessDescriptions.jbAdd.mnemonic").charAt(0));
        this.jbAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JAccessDescriptions.this);
                    JAccessDescriptions.this.addPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JAccessDescriptions.this);
                }
            }
        });
        this.jbEdit = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/edit_access_desc.png"))));
        this.jbEdit.setMargin(new Insets(2, 2, 0, 0));
        this.jbEdit.setToolTipText(res.getString("JAccessDescriptions.jbEdit.tooltip"));
        this.jbEdit.setMnemonic(res.getString("JAccessDescriptions.jbEdit.mnemonic").charAt(0));
        this.jbEdit.setEnabled(false);
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JAccessDescriptions.this);
                    JAccessDescriptions.this.editPressed();
                }
                finally {
                    CursorUtil.setCursorFree(JAccessDescriptions.this);
                }
            }
        });
        this.jbRemove = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("images/remove_access_desc.png"))));
        this.jbRemove.setMargin(new Insets(2, 2, 0, 0));
        this.jbRemove.setToolTipText(res.getString("JAccessDescriptions.jbRemove.tooltip"));
        this.jbRemove.setMnemonic(res.getString("JAccessDescriptions.jbRemove.mnemonic").charAt(0));
        this.jbRemove.setEnabled(false);
        this.jbRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JAccessDescriptions.this);
                    JAccessDescriptions.this.removePressed();
                }
                finally {
                    CursorUtil.setCursorFree(JAccessDescriptions.this);
                }
            }
        });
        this.jpAccessDescriptionButtons = new JPanel();
        this.jpAccessDescriptionButtons.setLayout(new BoxLayout(this.jpAccessDescriptionButtons, 1));
        this.jpAccessDescriptionButtons.add(Box.createVerticalGlue());
        this.jpAccessDescriptionButtons.add(this.jbAdd);
        this.jpAccessDescriptionButtons.add(Box.createVerticalStrut(3));
        this.jpAccessDescriptionButtons.add(this.jbEdit);
        this.jpAccessDescriptionButtons.add(Box.createVerticalStrut(3));
        this.jpAccessDescriptionButtons.add(this.jbRemove);
        this.jpAccessDescriptionButtons.add(Box.createVerticalGlue());
        AccessDescriptionsTableModel accessDescriptionsTableModel = new AccessDescriptionsTableModel();
        this.jtAccessDescriptions = new JKseTable(accessDescriptionsTableModel);
        TableRowSorter<AccessDescriptionsTableModel> sorter = new TableRowSorter<AccessDescriptionsTableModel>(accessDescriptionsTableModel);
        sorter.setComparator(0, new AccessDescriptionsTableModel.AccessDescriptionMethodComparator());
        sorter.setComparator(1, new AccessDescriptionsTableModel.AccessDescriptionLocationComparator());
        this.jtAccessDescriptions.setRowSorter(sorter);
        this.jtAccessDescriptions.setShowGrid(false);
        this.jtAccessDescriptions.setRowMargin(0);
        this.jtAccessDescriptions.getColumnModel().setColumnMargin(0);
        this.jtAccessDescriptions.getTableHeader().setReorderingAllowed(false);
        this.jtAccessDescriptions.setAutoResizeMode(4);
        this.jtAccessDescriptions.setRowHeight(Math.max(18, this.jtAccessDescriptions.getRowHeight()));
        for (int i = 0; i < this.jtAccessDescriptions.getColumnCount(); ++i) {
            TableColumn column = this.jtAccessDescriptions.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new AccessDescriptionsTableHeadRend(this.jtAccessDescriptions.getTableHeader().getDefaultRenderer()));
            column.setCellRenderer(new AccessDescriptionsTableCellRend());
        }
        ListSelectionModel selectionModel = this.jtAccessDescriptions.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    JAccessDescriptions.this.updateButtonControls();
                }
            }
        });
        this.jtAccessDescriptions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JAccessDescriptions.this.maybeEditAccessDescription(evt);
            }
        });
        this.jtAccessDescriptions.addKeyListener(new KeyAdapter(){
            boolean deleteLastPressed = false;

            @Override
            public void keyPressed(KeyEvent evt) {
                if (!OperatingSystem.isMacOs()) {
                    this.deleteLastPressed = evt.getKeyCode() == 127;
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (!OperatingSystem.isMacOs() && this.deleteLastPressed && evt.getKeyCode() == 127) {
                    try {
                        CursorUtil.setCursorBusy(JAccessDescriptions.this);
                        this.deleteLastPressed = false;
                        JAccessDescriptions.this.removeSelectedAccessDescription();
                    }
                    finally {
                        CursorUtil.setCursorFree(JAccessDescriptions.this);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                if (OperatingSystem.isMacOs() && evt.getKeyChar() == '\b') {
                    try {
                        CursorUtil.setCursorBusy(JAccessDescriptions.this);
                        JAccessDescriptions.this.removeSelectedAccessDescription();
                    }
                    finally {
                        CursorUtil.setCursorFree(JAccessDescriptions.this);
                    }
                }
            }
        });
        this.jspAccessDescriptions = PlatformUtil.createScrollPane(this.jtAccessDescriptions, 20, 31);
        this.jspAccessDescriptions.getViewport().setBackground(this.jtAccessDescriptions.getBackground());
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 150));
        this.add((Component)this.jspAccessDescriptions, "Center");
        this.add((Component)this.jpAccessDescriptionButtons, "East");
        this.populate();
    }

    public List<AccessDescription> getAccessDescriptions() {
        return this.accessDescriptions;
    }

    public void setAccessDescriptions(List<AccessDescription> accessDescriptions) {
        this.accessDescriptions = accessDescriptions;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateButtonControls();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jspAccessDescriptions.setToolTipText(toolTipText);
        this.jtAccessDescriptions.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.accessDescriptions == null) {
            this.accessDescriptions = new ArrayList<AccessDescription>();
        }
        this.reloadAccessDescriptionsTable();
        this.selectFirstAccessDescriptionInTable();
        this.updateButtonControls();
    }

    private void addPressed() {
        Container container = this.getTopLevelAncestor();
        DAccessDescriptionChooser dAccessDescriptionChooser = null;
        dAccessDescriptionChooser = container instanceof JDialog ? new DAccessDescriptionChooser((JDialog)container, this.title, null) : new DAccessDescriptionChooser((JFrame)container, this.title, null);
        dAccessDescriptionChooser.setLocationRelativeTo(container);
        dAccessDescriptionChooser.setVisible(true);
        AccessDescription newAccessDescription = dAccessDescriptionChooser.getAccessDescription();
        if (newAccessDescription == null) {
            return;
        }
        this.accessDescriptions.add(newAccessDescription);
        this.populate();
        this.selectAccessDescriptionInTable(newAccessDescription);
    }

    private void removePressed() {
        this.removeSelectedAccessDescription();
    }

    private void removeSelectedAccessDescription() {
        int selectedRow = this.jtAccessDescriptions.getSelectedRow();
        if (selectedRow != -1) {
            AccessDescription accessDescription = (AccessDescription)this.jtAccessDescriptions.getValueAt(selectedRow, 0);
            this.accessDescriptions.remove(accessDescription);
            this.reloadAccessDescriptionsTable();
            this.selectFirstAccessDescriptionInTable();
            this.updateButtonControls();
        }
    }

    private void editPressed() {
        this.editSelectedAccessDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEditAccessDescription(MouseEvent evt) {
        Point point;
        int row;
        if (evt.getClickCount() > 1 && (row = this.jtAccessDescriptions.rowAtPoint(point = new Point(evt.getX(), evt.getY()))) != -1) {
            try {
                CursorUtil.setCursorBusy(this);
                this.jtAccessDescriptions.setRowSelectionInterval(row, row);
                this.editSelectedAccessDescription();
            }
            finally {
                CursorUtil.setCursorFree(this);
            }
        }
    }

    private void updateButtonControls() {
        if (!this.enabled) {
            this.jbAdd.setEnabled(false);
            this.jbEdit.setEnabled(false);
            this.jbRemove.setEnabled(false);
        } else {
            this.jbAdd.setEnabled(true);
            int selectedRow = this.jtAccessDescriptions.getSelectedRow();
            if (selectedRow == -1) {
                this.jbEdit.setEnabled(false);
                this.jbRemove.setEnabled(false);
            } else {
                this.jbEdit.setEnabled(true);
                this.jbRemove.setEnabled(true);
            }
        }
    }

    private void editSelectedAccessDescription() {
        int selectedRow = this.jtAccessDescriptions.getSelectedRow();
        if (selectedRow != -1) {
            AccessDescription accessDescription = (AccessDescription)this.jtAccessDescriptions.getValueAt(selectedRow, 0);
            Container container = this.getTopLevelAncestor();
            DAccessDescriptionChooser dAccessDescriptionChooser = null;
            dAccessDescriptionChooser = container instanceof JDialog ? new DAccessDescriptionChooser((JDialog)container, this.title, accessDescription) : new DAccessDescriptionChooser((JFrame)container, this.title, accessDescription);
            dAccessDescriptionChooser.setLocationRelativeTo(container);
            dAccessDescriptionChooser.setVisible(true);
            AccessDescription newAccessDescription = dAccessDescriptionChooser.getAccessDescription();
            if (newAccessDescription == null) {
                return;
            }
            this.accessDescriptions.remove(accessDescription);
            this.accessDescriptions.add(newAccessDescription);
            this.populate();
            this.selectAccessDescriptionInTable(newAccessDescription);
        }
    }

    private void selectAccessDescriptionInTable(AccessDescription accessDescription) {
        for (int i = 0; i < this.jtAccessDescriptions.getRowCount(); ++i) {
            if (!accessDescription.equals(this.jtAccessDescriptions.getValueAt(i, 0))) continue;
            this.jtAccessDescriptions.changeSelection(i, 0, false, false);
            return;
        }
    }

    private void reloadAccessDescriptionsTable() {
        this.getAccessDescriptionsTableModel().load(this.accessDescriptions);
    }

    private void selectFirstAccessDescriptionInTable() {
        if (this.getAccessDescriptionsTableModel().getRowCount() > 0) {
            this.jtAccessDescriptions.changeSelection(0, 0, false, false);
        }
    }

    private AccessDescriptionsTableModel getAccessDescriptionsTableModel() {
        return (AccessDescriptionsTableModel)this.jtAccessDescriptions.getModel();
    }
}

