/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.generalsubtree;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.kse.crypto.x509.GeneralNameUtil;
import org.kse.crypto.x509.GeneralSubtrees;

public class GeneralSubtreesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/generalsubtree/resources");
    private String[] columnNames = new String[3];
    private Object[][] data;

    public GeneralSubtreesTableModel() {
        this.columnNames[0] = res.getString("GeneralSubtreesTableModel.BaseColumn");
        this.columnNames[1] = res.getString("GeneralSubtreesTableModel.MinimumColumn");
        this.columnNames[2] = res.getString("GeneralSubtreesTableModel.MaximumColumn");
        this.data = new Object[0][0];
    }

    public void load(GeneralSubtrees generalSubtrees) {
        List<GeneralSubtree> generalSubtreesList = generalSubtrees.getGeneralSubtrees();
        Collections.sort(generalSubtreesList, new GeneralSubtreeBaseComparator());
        this.data = new Object[generalSubtreesList.size()][3];
        int i = 0;
        for (GeneralSubtree generalSubtree : generalSubtreesList) {
            this.data[i][0] = generalSubtree;
            this.data[i][1] = generalSubtree;
            this.data[i][2] = generalSubtree;
            ++i;
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return GeneralSubtree.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    static class GeneralSubtreeMaximumComparator
    implements Comparator<GeneralSubtree> {
        GeneralSubtreeMaximumComparator() {
        }

        @Override
        public int compare(GeneralSubtree subtree1, GeneralSubtree subtree2) {
            BigInteger maximum1 = BigInteger.valueOf(-1L);
            BigInteger maximum2 = BigInteger.valueOf(-1L);
            if (subtree1.getMaximum() != null) {
                maximum1 = subtree1.getMaximum();
            }
            if (subtree2.getMaximum() != null) {
                maximum2 = subtree2.getMaximum();
            }
            return maximum1.compareTo(maximum2);
        }
    }

    static class GeneralSubtreeMinimumComparator
    implements Comparator<GeneralSubtree> {
        GeneralSubtreeMinimumComparator() {
        }

        @Override
        public int compare(GeneralSubtree subtree1, GeneralSubtree subtree2) {
            return subtree1.getMinimum().compareTo(subtree2.getMinimum());
        }
    }

    static class GeneralSubtreeBaseComparator
    implements Comparator<GeneralSubtree> {
        GeneralSubtreeBaseComparator() {
        }

        @Override
        public int compare(GeneralSubtree subtree1, GeneralSubtree subtree2) {
            return GeneralNameUtil.safeToString(subtree1.getBase(), false).compareToIgnoreCase(GeneralNameUtil.safeToString(subtree2.getBase(), false));
        }
    }
}

