/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.crypto.policyinformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.kse.gui.JEscDialog;
import org.kse.gui.PlatformUtil;
import org.kse.gui.crypto.policyinformation.JPolicyQualifierInfo;
import org.kse.gui.error.DError;
import org.kse.gui.oid.JObjectId;

public class DPolicyInformationChooser
extends JEscDialog {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/crypto/policyinformation/resources");
    private static final String CANCEL_KEY = "CANCEL_KEY";
    private JPanel jpPolicyInformation;
    private JLabel jlPolicyIdentifier;
    private JObjectId joiPolicyIdentifier;
    private JLabel jlPolicyQualifiers;
    private JPolicyQualifierInfo jpqPolicyQualifiers;
    private JPanel jpButtons;
    private JButton jbOK;
    private JButton jbCancel;
    private PolicyInformation policyInformation;

    public DPolicyInformationChooser(JFrame parent, String title, PolicyInformation policyInformation) throws IOException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyInformation);
    }

    public DPolicyInformationChooser(JDialog parent, String title, PolicyInformation policyInformation) throws IOException {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents(policyInformation);
    }

    private void initComponents(PolicyInformation policyInformation) throws IOException {
        this.jlPolicyIdentifier = new JLabel(res.getString("DPolicyInformationChooser.jlPolicyIdentifier.text"));
        GridBagConstraints gbc_jlPolicyIdentifier = new GridBagConstraints();
        gbc_jlPolicyIdentifier.gridx = 0;
        gbc_jlPolicyIdentifier.gridy = 0;
        gbc_jlPolicyIdentifier.gridwidth = 1;
        gbc_jlPolicyIdentifier.gridheight = 1;
        gbc_jlPolicyIdentifier.insets = new Insets(5, 5, 5, 5);
        gbc_jlPolicyIdentifier.anchor = 13;
        this.joiPolicyIdentifier = new JObjectId(res.getString("DPolicyInformationChooser.PolicyIdentifier.Text"));
        this.joiPolicyIdentifier.setToolTipText(res.getString("DPolicyInformationChooser.joiPolicyIdentifier.tooltip"));
        GridBagConstraints gbc_joiPolicyIdentifier = new GridBagConstraints();
        gbc_joiPolicyIdentifier.gridx = 1;
        gbc_joiPolicyIdentifier.gridy = 0;
        gbc_joiPolicyIdentifier.gridwidth = 1;
        gbc_joiPolicyIdentifier.gridheight = 1;
        gbc_joiPolicyIdentifier.insets = new Insets(5, 5, 5, 5);
        gbc_joiPolicyIdentifier.anchor = 17;
        this.jlPolicyQualifiers = new JLabel(res.getString("DPolicyInformationChooser.jlPolicyQualifiers.text"));
        GridBagConstraints gbc_jlPolicyQualifiers = new GridBagConstraints();
        gbc_jlPolicyQualifiers.gridx = 0;
        gbc_jlPolicyQualifiers.gridy = 1;
        gbc_jlPolicyQualifiers.gridwidth = 1;
        gbc_jlPolicyQualifiers.gridheight = 1;
        gbc_jlPolicyQualifiers.insets = new Insets(5, 5, 5, 5);
        gbc_jlPolicyQualifiers.anchor = 12;
        this.jpqPolicyQualifiers = new JPolicyQualifierInfo(res.getString("DPolicyInformationChooser.PolicyQualifierInfo.Title"));
        this.jpqPolicyQualifiers.setPreferredSize(new Dimension(400, 150));
        GridBagConstraints gbc_jpqPolicyQualifiers = new GridBagConstraints();
        gbc_jpqPolicyQualifiers.gridx = 1;
        gbc_jpqPolicyQualifiers.gridy = 1;
        gbc_jpqPolicyQualifiers.gridwidth = 1;
        gbc_jpqPolicyQualifiers.gridheight = 1;
        gbc_jpqPolicyQualifiers.insets = new Insets(5, 5, 5, 5);
        gbc_jpqPolicyQualifiers.anchor = 17;
        this.jpPolicyInformation = new JPanel(new GridBagLayout());
        this.jpPolicyInformation.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        this.jpPolicyInformation.add((Component)this.jlPolicyIdentifier, gbc_jlPolicyIdentifier);
        this.jpPolicyInformation.add((Component)this.joiPolicyIdentifier, gbc_joiPolicyIdentifier);
        this.jpPolicyInformation.add((Component)this.jlPolicyQualifiers, gbc_jlPolicyQualifiers);
        this.jpPolicyInformation.add((Component)this.jpqPolicyQualifiers, gbc_jpqPolicyQualifiers);
        this.jbOK = new JButton(res.getString("DPolicyInformationChooser.jbOK.text"));
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyInformationChooser.this.okPressed();
            }
        });
        this.jbCancel = new JButton(res.getString("DPolicyInformationChooser.jbCancel.text"));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyInformationChooser.this.cancelPressed();
            }
        });
        this.jbCancel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), CANCEL_KEY);
        this.jbCancel.getActionMap().put(CANCEL_KEY, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                DPolicyInformationChooser.this.cancelPressed();
            }
        });
        this.jpButtons = PlatformUtil.createDialogButtonPanel(this.jbOK, this.jbCancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jpPolicyInformation);
        this.getContentPane().add("South", this.jpButtons);
        this.populate(policyInformation);
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.jbOK);
        this.pack();
    }

    private void populate(PolicyInformation policyInformation) throws IOException {
        if (policyInformation != null) {
            this.joiPolicyIdentifier.setObjectId(policyInformation.getPolicyIdentifier());
            ASN1Sequence policyQualifierInfoSeq = policyInformation.getPolicyQualifiers();
            if (policyQualifierInfoSeq != null) {
                ArrayList<PolicyQualifierInfo> policyQualifierInfo = new ArrayList<PolicyQualifierInfo>();
                for (int i = 0; i < policyQualifierInfoSeq.size(); ++i) {
                    PolicyQualifierInfo policyQualInfo = PolicyQualifierInfo.getInstance((Object)policyQualifierInfoSeq.getObjectAt(i));
                    policyQualifierInfo.add(policyQualInfo);
                }
                this.jpqPolicyQualifiers.setPolicyQualifierInfo(policyQualifierInfo);
            }
        }
    }

    public PolicyInformation getPolicyInformation() {
        return this.policyInformation;
    }

    private void okPressed() {
        ASN1ObjectIdentifier policyIdentifer = this.joiPolicyIdentifier.getObjectId();
        if (policyIdentifer == null) {
            JOptionPane.showMessageDialog(this, res.getString("DPolicyInformationChooser.PolicyIdentifierValueReq.message"), this.getTitle(), 2);
            return;
        }
        List<PolicyQualifierInfo> policyQualifierInfo = this.jpqPolicyQualifiers.getPolicyQualifierInfo();
        if (!policyQualifierInfo.isEmpty()) {
            ASN1EncodableVector policyQualifiersVec = new ASN1EncodableVector();
            for (PolicyQualifierInfo policyQualInfo : policyQualifierInfo) {
                try {
                    policyQualifiersVec.add((ASN1Encodable)policyQualInfo);
                }
                catch (Exception e) {
                    DError.displayError(this, (Throwable)e);
                    return;
                }
            }
            DERSequence policyQualifiersSeq = new DERSequence(policyQualifiersVec);
            this.policyInformation = new PolicyInformation(policyIdentifer, (ASN1Sequence)policyQualifiersSeq);
        } else {
            this.policyInformation = new PolicyInformation(policyIdentifer);
        }
        this.closeDialog();
    }

    private void cancelPressed() {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

