/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.datetime;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kse.gui.CursorUtil;
import org.kse.gui.datetime.DDateTimeChooser;
import org.kse.utilities.StringUtils;

public class JDateTime
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle res = ResourceBundle.getBundle("org/kse/gui/datetime/resources");
    private JTextField jtfDateTime;
    private JButton jbEditDateTime;
    private JButton jbClearDateTime;
    private String title;
    private Date date;
    private boolean showClearButton = true;

    public JDateTime(String title) {
        this(title, true);
    }

    public JDateTime(String title, boolean showClearButton) {
        this.title = title;
        this.showClearButton = showClearButton;
        this.initComponents();
    }

    private void initComponents() {
        this.jtfDateTime = new JTextField(18);
        this.jtfDateTime.setEditable(false);
        GridBagConstraints gbc_jtfDateTime = new GridBagConstraints();
        gbc_jtfDateTime.gridwidth = 1;
        gbc_jtfDateTime.gridheight = 1;
        gbc_jtfDateTime.gridx = 0;
        gbc_jtfDateTime.gridy = 0;
        gbc_jtfDateTime.insets = new Insets(0, 0, 0, 5);
        ImageIcon editIcon = new ImageIcon(this.getClass().getResource("images/edit_date_time.png"));
        this.jbEditDateTime = new JButton(editIcon);
        this.jbEditDateTime.setToolTipText(res.getString("JDateTime.jbEditDateTime.tooltip"));
        this.jbEditDateTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CursorUtil.setCursorBusy(JDateTime.this);
                    JDateTime.this.editDateTime();
                }
                finally {
                    CursorUtil.setCursorFree(JDateTime.this);
                }
            }
        });
        GridBagConstraints gbc_jbEditDateTime = new GridBagConstraints();
        gbc_jbEditDateTime.gridwidth = 1;
        gbc_jbEditDateTime.gridheight = 1;
        gbc_jbEditDateTime.gridx = 1;
        gbc_jbEditDateTime.gridy = 0;
        gbc_jbEditDateTime.insets = new Insets(0, 0, 0, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jtfDateTime, gbc_jtfDateTime);
        this.add((Component)this.jbEditDateTime, gbc_jbEditDateTime);
        if (this.showClearButton) {
            ImageIcon clearIcon = new ImageIcon(this.getClass().getResource("images/clear_date_time.png"));
            this.jbClearDateTime = new JButton(clearIcon);
            this.jbClearDateTime.setToolTipText(res.getString("JDateTime.jbClearDateTime.tooltip"));
            this.jbClearDateTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        CursorUtil.setCursorBusy(JDateTime.this);
                        JDateTime.this.clearDateTime();
                    }
                    finally {
                        CursorUtil.setCursorFree(JDateTime.this);
                    }
                }
            });
            GridBagConstraints gbc_jbClearDateTime = new GridBagConstraints();
            gbc_jbClearDateTime.gridwidth = 1;
            gbc_jbClearDateTime.gridheight = 1;
            gbc_jbClearDateTime.gridx = 2;
            gbc_jbClearDateTime.gridy = 0;
            gbc_jbClearDateTime.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.jbClearDateTime, gbc_jbClearDateTime);
        }
        this.populate();
    }

    public Date getDateTime() {
        return this.date;
    }

    public void setDateTime(Date date) {
        this.date = date;
        this.populate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jbEditDateTime.setEnabled(enabled);
        this.jbClearDateTime.setEnabled(enabled);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        super.setToolTipText(toolTipText);
        this.jtfDateTime.setToolTipText(toolTipText);
    }

    private void populate() {
        if (this.date != null) {
            this.jtfDateTime.setText(StringUtils.formatDate(this.date));
            if (this.showClearButton) {
                this.jbClearDateTime.setEnabled(true);
            }
        } else {
            this.jtfDateTime.setText("");
            if (this.showClearButton) {
                this.jbClearDateTime.setEnabled(false);
            }
        }
        this.jtfDateTime.setCaretPosition(0);
    }

    private void editDateTime() {
        Container container = this.getTopLevelAncestor();
        DDateTimeChooser dDateTimeChooser = null;
        if (container instanceof JDialog) {
            dDateTimeChooser = new DDateTimeChooser((JDialog)container, this.title, this.date);
            dDateTimeChooser.setLocationRelativeTo(container);
            dDateTimeChooser.setVisible(true);
        } else {
            dDateTimeChooser = new DDateTimeChooser((JFrame)container, this.title, this.date);
            dDateTimeChooser.setLocationRelativeTo(container);
            dDateTimeChooser.setVisible(true);
        }
        Date newDate = dDateTimeChooser.getDate();
        if (newDate == null) {
            return;
        }
        this.setDateTime(newDate);
    }

    private void clearDateTime() {
        this.setDateTime(null);
    }
}

