/*
 * Decompiled with CFR 0.152.
 */
package org.kse.gui.dialogs;

import java.awt.Component;
import java.security.cert.X509Certificate;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.kse.crypto.x509.X500NameUtils;
import org.kse.crypto.x509.X509CertUtil;

public class CertificateTreeCellRend
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree jtrHierarchy, Object value, boolean isSelected, boolean isExpanded, boolean leaf, int row, boolean hasFocus) {
        JLabel cell = (JLabel)super.getTreeCellRendererComponent(jtrHierarchy, value, isSelected, isExpanded, leaf, row, hasFocus);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        if (userObject instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)userObject;
            cell.setText(X509CertUtil.getShortName(cert));
            ImageIcon icon = new ImageIcon(this.getClass().getResource("images/certificate_node.png"));
            cell.setIcon(icon);
            cell.setToolTipText(X500NameUtils.x500PrincipalToX500Name(cert.getSubjectX500Principal()).toString());
        }
        return cell;
    }
}

